/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.Mods;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IInteraction;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.PowerInfo;
import binnie.core.machines.power.PowerInterface;
import binnie.core.machines.power.PowerSystem;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.Interface(iface="binnie.core.machines.component.IBuildcraft.TriggerProvider", modid="BuildCraft|Silicon")
public class ComponentPowerReceptor
extends MachineComponent
implements IPoweredMachine,
IInteraction.ChunkUnload,
IInteraction.Invalidation {
    static final int inputAverageTicks = 20;
    float previousPower = 0.0f;
    LinkedList<Float> inputs = new LinkedList();
    private boolean registeredToIC2EnergyNet = false;
    private PowerInterface container;

    public ComponentPowerReceptor(IMachine machine) {
        this(machine, 1000);
    }

    public ComponentPowerReceptor(IMachine machine, int storage) {
        super(machine);
        this.container = new PowerInterface(storage);
        if (!this.registeredToIC2EnergyNet) {
            this.addToEnergyNet();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.container.readFromNBT(nbttagcompound);
        if (!this.registeredToIC2EnergyNet) {
            this.addToEnergyNet();
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound2) {
        NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound2);
        this.container.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void onUpdate() {
        if (!this.registeredToIC2EnergyNet && !this.getMachine().getTileEntity().func_145837_r()) {
            this.addToEnergyNet();
        }
    }

    @Override
    public PowerInfo getPowerInfo() {
        return new PowerInfo(this, 0.0f);
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return this.container.getEnergySpace(PowerSystem.EU);
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.container.addEnergy(PowerSystem.EU, amount, true);
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return this.acceptsPowerSystem(PowerSystem.EU);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.container.addEnergy(PowerSystem.RF, maxReceive, !simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.container.useEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return (int)this.container.getEnergy(PowerSystem.RF);
    }

    public int getMaxEnergyStored() {
        return (int)this.container.getCapacity(PowerSystem.RF);
    }

    public boolean canReceive() {
        return this.acceptsPowerSystem(PowerSystem.RF);
    }

    public boolean canExtract() {
        return false;
    }

    @Override
    public PowerInterface getInterface() {
        return this.container;
    }

    private boolean acceptsPowerSystem(PowerSystem system) {
        return true;
    }

    @Override
    public void onInvalidation() {
        this.removeFromEnergyNet();
    }

    @Override
    public void onChunkUnload() {
        this.removeFromEnergyNet();
    }

    private void addToEnergyNet() {
        if (this.getMachine().getWorld() == null) {
            return;
        }
        if (Mods.IC2.active()) {
            this.do_addToEnergyNet();
        }
    }

    private void removeFromEnergyNet() {
        if (this.getMachine().getWorld() == null) {
            return;
        }
        if (Mods.IC2.active()) {
            this.do_removeFromEnergyNet();
        }
    }

    @Optional.Method(modid="ic2")
    private void do_addToEnergyNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.getMachine().getTileEntity()));
        this.registeredToIC2EnergyNet = true;
    }

    @Optional.Method(modid="ic2")
    private void do_removeFromEnergyNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.getMachine().getTileEntity()));
        this.registeredToIC2EnergyNet = false;
    }
}

