/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.ManagerBase;
import binnie.core.liquid.BinnieFluid;
import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.IFluidType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ManagerLiquid
extends ManagerBase {
    public static final String WATER = "water";
    public static final String CREOSOTE = "fluid.creosote";
    Map<String, IFluidType> fluids = new LinkedHashMap<String, IFluidType>();

    public Collection<IFluidType> getFluidTypes() {
        return this.fluids.values();
    }

    public void createLiquids(IFluidType[] liquids) {
        for (IFluidType liquid : liquids) {
            BinnieFluid fluid = this.createLiquid(liquid);
            if (fluid != null) continue;
            throw new RuntimeException("Liquid registered incorrectly - " + liquid.getIdentifier());
        }
    }

    public BinnieFluid createLiquid(IFluidType fluid) {
        this.fluids.put(fluid.getIdentifier().toLowerCase(), fluid);
        BinnieFluid bFluid = new BinnieFluid(fluid);
        FluidRegistry.registerFluid((Fluid)bFluid);
        FluidRegistry.addBucketForFluid((Fluid)bFluid);
        return bFluid;
    }

    @Nullable
    public FluidStack getFluidStack(String name, int amount) {
        return FluidRegistry.getFluidStack((String)name.toLowerCase(), (int)amount);
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        GameRegistry.addShapelessRecipe((ItemStack)FluidContainerType.GLASS.get(1), (Object[])new Object[]{Items.field_151069_bo});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151069_bo), (Object[])new Object[]{FluidContainerType.GLASS.get(1)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FluidContainerType.GLASS.get(3), new Object[]{" b ", "g g", " g ", Character.valueOf('g'), "blockGlass", Character.valueOf('b'), "slabWood"}));
    }

    public IFluidType getFluidType(String liquid) {
        return this.fluids.get(liquid.toLowerCase());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureStitchEvent event) {
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        for (IFluidType fluid : this.fluids.values()) {
            textureMap.func_174942_a(fluid.getFlowing());
            textureMap.func_174942_a(fluid.getStill());
        }
    }
}

