/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.integration.extrabees;

import binnie.core.IInitializable;
import com.google.common.base.Preconditions;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ExtraBeesIntegration
implements IInitializable {
    private static final boolean loaded = Loader.isModLoaded((String)"extrabees");
    public static IAlleleBeeSpecies water;
    public static IAlleleBeeSpecies rock;
    public static IAlleleBeeSpecies basalt;
    public static IAlleleBeeSpecies marble;
    public static Block hive;
    public static Item dictionary;

    public static boolean isLoaded() {
        return loaded;
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        hive = (Block)Preconditions.checkNotNull((Object)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("extrabees", "hive")));
        dictionary = (Item)Preconditions.checkNotNull((Object)ForgeRegistries.ITEMS.getValue(new ResourceLocation("genetics", "dictionary")));
    }

    @Override
    public void postInit() {
        water = this.getExtraBeesSpecies("water");
        rock = this.getExtraBeesSpecies("rock");
        basalt = this.getExtraBeesSpecies("basalt");
        marble = this.getExtraBeesSpecies("marble");
    }

    public static ItemStack getHive(IAlleleSpecies speciesCurrent) {
        if (speciesCurrent == water) {
            return new ItemStack(hive, 1, 0);
        }
        if (speciesCurrent == rock) {
            return new ItemStack(hive, 1, 1);
        }
        if (speciesCurrent == basalt) {
            return new ItemStack(hive, 1, 2);
        }
        if (speciesCurrent == marble) {
            return new ItemStack(hive, 1, 3);
        }
        return ItemStack.field_190927_a;
    }

    private IAlleleBeeSpecies getExtraBeesSpecies(String species) {
        return (IAlleleBeeSpecies)Preconditions.checkNotNull((Object)((IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("extrabees.species." + species)));
    }
}

