/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.core.gui.Attribute;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.database.EnumDiscoveryState;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.util.I18N;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlDatabaseIndividualDisplay
extends ControlItemDisplay
implements ITooltip {
    EnumDiscoveryState discovered = EnumDiscoveryState.Show;
    @Nullable
    private IAlleleSpecies species = null;

    public ControlDatabaseIndividualDisplay(IWidget parent, int x, int y) {
        this(parent, x, y, 16);
    }

    public ControlDatabaseIndividualDisplay(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size);
        this.addSelfEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (event.getButton() == 0 && ControlDatabaseIndividualDisplay.this.species != null && EnumDiscoveryState.Show == ControlDatabaseIndividualDisplay.this.discovered) {
                    ((WindowAbstractDatabase)ControlDatabaseIndividualDisplay.this.getTopParent()).gotoSpeciesDelayed(ControlDatabaseIndividualDisplay.this.species);
                }
            }
        });
    }

    public void setSpecies(IAlleleSpecies species) {
        this.setSpecies(species, EnumDiscoveryState.Show);
    }

    public void setSpecies(IAlleleSpecies species, EnumDiscoveryState state) {
        ISpeciesRoot speciesRoot = Binnie.GENETICS.getSpeciesRoot(species);
        BreedingSystem system = Binnie.GENETICS.getSystem(speciesRoot);
        IAllele[] template = system.getSpeciesRoot().getTemplate(species);
        IIndividual ind = system.getSpeciesRoot().templateAsIndividual(template);
        super.setItemStack(system.getSpeciesRoot().getMemberStack(ind, system.getDefaultType()));
        this.species = species;
        GameProfile username = ((Window)Window.get(this)).getUsername();
        if (state == EnumDiscoveryState.Undetermined) {
            EnumDiscoveryState enumDiscoveryState = state = system.isSpeciesDiscovered(species, ((Window)Window.get(this)).getWorld(), username) ? EnumDiscoveryState.Discovered : EnumDiscoveryState.Undiscovered;
        }
        if (Window.get(this) instanceof WindowAbstractDatabase && ((WindowAbstractDatabase)Window.get((IWidget)this)).isNEI) {
            state = EnumDiscoveryState.Show;
        }
        this.discovered = state;
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        TextureAtlasSprite icon = null;
        if (this.species == null) {
            return;
        }
        BreedingSystem system = Binnie.GENETICS.getSystem(this.species.getRoot());
        switch (this.discovered) {
            case Show: {
                super.onRenderForeground(guiWidth, guiHeight);
                return;
            }
            case Discovered: {
                icon = system.getDiscoveredIcon();
                break;
            }
            case Undiscovered: {
                icon = system.getUndiscoveredIcon();
            }
        }
        if (icon != null) {
            RenderUtil.drawGuiSprite(Point.ZERO, icon);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.species != null) {
            switch (this.discovered) {
                case Show: {
                    tooltip.add(this.species.getAlleleName());
                    break;
                }
                case Discovered: {
                    tooltip.add(I18N.localise("binniecore.gui.database.discovered.discovered"));
                    break;
                }
                case Undiscovered: {
                    tooltip.add(I18N.localise("binniecore.gui.database.discovered.undiscovered"));
                }
            }
        }
    }
}

