/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.block;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityMetadata
extends TileEntity {
    private int meta;
    private boolean droppedBlock = false;

    @Nullable
    public static TileEntityMetadata getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityMetadata)) {
            return null;
        }
        return (TileEntityMetadata)tile;
    }

    public static ItemStack getItemStack(Block block, int damage) {
        Item item = Item.func_150898_a((Block)block);
        Preconditions.checkNotNull((Object)item, (String)"Could not get item for block %s", (Object[])new Object[]{block});
        ItemStack itemStack = new ItemStack(item, 1, 0);
        TileEntityMetadata.setItemDamage(itemStack, damage);
        return itemStack;
    }

    public static void setItemDamage(ItemStack item, int i) {
        item.func_77964_b(i < 16387 ? i : 16387);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("meta", i);
        item.func_77982_d(tag);
    }

    public static int getItemDamage(ItemStack item) {
        if (item.func_77942_o() && item.func_77978_p().func_74764_b("meta")) {
            return item.func_77978_p().func_74762_e("meta");
        }
        return item.func_77952_i();
    }

    public static int getTileMetadata(IBlockAccess world, BlockPos pos) {
        TileEntityMetadata tile = TileEntityMetadata.getTile(world, pos);
        return tile == null ? 0 : tile.getTileMetadata();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 42) {
            this.meta = type;
            this.func_70296_d();
        }
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.field_145850_b != null) {
            this.setTileMetadata(nbt.func_74762_e("meta"), this.field_145850_b.field_72995_K);
        } else {
            this.meta = nbt.func_74762_e("meta");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("meta", this.meta);
        return nbt;
    }

    public int getTileMetadata() {
        return this.meta;
    }

    public void setTileMetadata(int meta, boolean notify) {
        if (this.meta != meta) {
            this.meta = meta;
            if (notify) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public boolean hasDroppedBlock() {
        return this.droppedBlock;
    }

    public void dropBlock() {
        this.droppedBlock = true;
    }
}

