/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.IGardeningManager;
import binnie.botany.ceramic.BlockCeramic;
import binnie.botany.ceramic.BlockCeramicPatterned;
import binnie.botany.ceramic.BlockStainedGlass;
import binnie.botany.ceramic.CeramicTileRecipe;
import binnie.botany.ceramic.ItemCeramic;
import binnie.botany.ceramic.ItemStainedGlass;
import binnie.botany.ceramic.PigmentRecipe;
import binnie.botany.ceramic.TileCeramic;
import binnie.botany.ceramic.brick.BlockCeramicBrick;
import binnie.botany.ceramic.brick.ItemCeramicBrick;
import binnie.botany.ceramic.brick.TileCeramicBrick;
import binnie.botany.core.BotanyCore;
import binnie.botany.farm.CircuitGarden;
import binnie.botany.flower.ItemInsulatedTube;
import binnie.botany.gardening.BlockPlant;
import binnie.botany.gardening.BlockSoil;
import binnie.botany.gardening.ItemSoil;
import binnie.botany.gardening.ItemSoilMeter;
import binnie.botany.gardening.ItemTrowel;
import binnie.botany.gardening.ItemWeed;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.items.BotanyItems;
import binnie.botany.items.ItemClay;
import binnie.botany.items.ItemPigment;
import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.Mods;
import binnie.core.block.TileEntityMetadata;
import binnie.core.item.ItemMisc;
import binnie.extratrees.carpentry.ItemDesign;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ModuleGardening
implements IInitializable {
    public static final HashMap<ItemStack, Integer> queuedAcidFertilisers = new HashMap();
    public static final HashMap<ItemStack, Integer> queuedAlkalineFertilisers = new HashMap();
    public static final HashMap<ItemStack, Integer> queuedNutrientFertilisers = new HashMap();
    public BlockPlant plant;
    public ItemTrowel trowelWood;
    public ItemTrowel trowelStone;
    public ItemTrowel trowelIron;
    public ItemTrowel trowelDiamond;
    public ItemTrowel trowelGold;
    public BlockSoil soil;
    public BlockSoil loam;
    public BlockSoil flowerbed;
    public BlockSoil soilNoWeed;
    public BlockSoil loamNoWeed;
    public BlockSoil flowerbedNoWeed;
    public ItemInsulatedTube insulatedTube;
    public ItemSoilMeter soilMeter;
    public ItemMisc misc;
    public ItemPigment pigment;
    public ItemClay clay;
    public BlockCeramic ceramic;
    public BlockCeramicPatterned ceramicTile;
    public BlockStainedGlass stained;
    public BlockCeramicBrick ceramicBrick;

    @Override
    public void preInit() {
        this.plant = new BlockPlant();
        this.soil = new BlockSoil(EnumSoilType.SOIL, "soil", false);
        this.loam = new BlockSoil(EnumSoilType.LOAM, "loam", false);
        this.flowerbed = new BlockSoil(EnumSoilType.FLOWERBED, "flowerbed", false);
        this.soilNoWeed = new BlockSoil(EnumSoilType.SOIL, "soil_no_weed", true);
        this.loamNoWeed = new BlockSoil(EnumSoilType.LOAM, "loam_no_weed", true);
        this.flowerbedNoWeed = new BlockSoil(EnumSoilType.FLOWERBED, "flowerbed_no_weed", true);
        this.soilMeter = new ItemSoilMeter();
        this.insulatedTube = new ItemInsulatedTube();
        this.trowelWood = new ItemTrowel(Item.ToolMaterial.WOOD, "wood");
        this.trowelStone = new ItemTrowel(Item.ToolMaterial.STONE, "stone");
        this.trowelIron = new ItemTrowel(Item.ToolMaterial.IRON, "iron");
        this.trowelDiamond = new ItemTrowel(Item.ToolMaterial.DIAMOND, "diamond");
        this.trowelGold = new ItemTrowel(Item.ToolMaterial.GOLD, "gold");
        this.misc = new ItemMisc(CreativeTabBotany.instance, BotanyItems.values());
        this.pigment = new ItemPigment();
        this.clay = new ItemClay();
        this.ceramic = new BlockCeramic();
        this.stained = new BlockStainedGlass();
        this.ceramicTile = new BlockCeramicPatterned();
        this.ceramicBrick = new BlockCeramicBrick();
        Botany.proxy.registerBlock(this.plant, (ItemBlock)new ItemWeed((Block)this.plant));
        Botany.proxy.registerBlock(this.soil, (ItemBlock)new ItemSoil(this.soil));
        Botany.proxy.registerBlock(this.loam, (ItemBlock)new ItemSoil(this.loam));
        Botany.proxy.registerBlock(this.flowerbed, (ItemBlock)new ItemSoil(this.flowerbed));
        Botany.proxy.registerBlock(this.soilNoWeed, (ItemBlock)new ItemSoil(this.soilNoWeed));
        Botany.proxy.registerBlock(this.loamNoWeed, (ItemBlock)new ItemSoil(this.loamNoWeed));
        Botany.proxy.registerBlock(this.flowerbedNoWeed, (ItemBlock)new ItemSoil(this.flowerbedNoWeed));
        Botany.proxy.registerItem(this.soilMeter);
        Botany.proxy.registerItem(this.insulatedTube);
        Botany.proxy.registerItem(this.trowelWood);
        Botany.proxy.registerItem(this.trowelStone);
        Botany.proxy.registerItem(this.trowelIron);
        Botany.proxy.registerItem(this.trowelDiamond);
        Botany.proxy.registerItem(this.trowelGold);
        Botany.proxy.registerItem(this.misc);
        Botany.proxy.registerItem(this.pigment);
        Botany.proxy.registerItem(this.clay);
        Botany.proxy.registerBlock(this.ceramic, (ItemBlock)new ItemCeramic(this.ceramic));
        Botany.proxy.registerBlock(this.stained, (ItemBlock)new ItemStainedGlass(this.stained));
        Botany.proxy.registerBlock(this.ceramicTile, (ItemBlock)new ItemDesign(this.ceramicTile));
        Botany.proxy.registerBlock(this.ceramicBrick, (ItemBlock)new ItemCeramicBrick(this.ceramicBrick));
        BinnieCore.getBinnieProxy().registerTileEntity(TileCeramic.class, "botany.tile.ceramic");
        BinnieCore.getBinnieProxy().registerTileEntity(TileCeramicBrick.class, "botany.tile.ceramicBrick");
        OreDictionary.registerOre((String)"pigment", (Item)this.pigment);
        OreDictionary.registerOre((String)"toolTrowel", (Item)this.trowelWood);
        OreDictionary.registerOre((String)"toolTrowel", (Item)this.trowelStone);
        OreDictionary.registerOre((String)"toolTrowel", (Item)this.trowelIron);
        OreDictionary.registerOre((String)"toolTrowel", (Item)this.trowelGold);
        OreDictionary.registerOre((String)"toolTrowel", (Item)this.trowelDiamond);
    }

    @Override
    public void init() {
        RecipeSorter.register((String)"botany:ceramictile", CeramicTileRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"botany:pigment", PigmentRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        ItemStack yellow = new ItemStack((Block)Blocks.field_150327_N, 1);
        ItemStack red = new ItemStack((Block)Blocks.field_150328_O, 1);
        ItemStack blue = new ItemStack((Block)Blocks.field_150328_O, 1, 7);
        for (boolean manual : new boolean[]{true, false}) {
            for (boolean fertilised : new boolean[]{true, false}) {
                for (EnumMoisture moist : EnumMoisture.values()) {
                    ItemStack icon = moist == EnumMoisture.DRY ? yellow : (moist == EnumMoisture.NORMAL ? red : blue);
                    int insulate = 2 - moist.ordinal();
                    if (fertilised) {
                        insulate += 3;
                    }
                    new CircuitGarden(moist, null, manual, fertilised, new ItemStack((Item)this.insulatedTube, 1, 128 * insulate), icon);
                    new CircuitGarden(moist, EnumAcidity.ACID, manual, fertilised, new ItemStack((Item)this.insulatedTube, 1, 1 + 128 * insulate), icon);
                    new CircuitGarden(moist, EnumAcidity.NEUTRAL, manual, fertilised, new ItemStack((Item)this.insulatedTube, 1, 2 + 128 * insulate), icon);
                    new CircuitGarden(moist, EnumAcidity.ALKALINE, manual, fertilised, new ItemStack((Item)this.insulatedTube, 1, 3 + 128 * insulate), icon);
                }
            }
        }
    }

    @Override
    public void postInit() {
        IGardeningManager gardening = BotanyCore.getGardening();
        GameRegistry.addRecipe((IRecipe)new CeramicTileRecipe());
        for (int mat = 0; mat < 4; ++mat) {
            for (int insulate = 0; insulate < 6; ++insulate) {
                ItemStack tubes = new ItemStack((Item)this.insulatedTube, 2, mat + 128 * insulate);
                ItemStack insulateStack = ItemInsulatedTube.getInsulateStack(tubes);
                ItemStack forestryTube = new ItemStack(Mods.Forestry.item("thermionic_tubes"), 1, mat);
                GameRegistry.addShapelessRecipe((ItemStack)tubes, (Object[])new Object[]{forestryTube, forestryTube, insulateStack});
            }
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this.trowelWood, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this.trowelStone, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "cobblestone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this.trowelIron, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this.trowelGold, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this.trowelDiamond, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "gemDiamond"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this.soilMeter, new Object[]{" gg", " rg", "i  ", Character.valueOf('g'), "ingotGold", Character.valueOf('r'), "dustRedstone", Character.valueOf('i'), "ingotIron"}));
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.WEEDKILLER.get(4), (Object[])new Object[]{new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151014_N)});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_ASH.get(4), (Object[])new Object[]{Mods.Forestry.stack("ash")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_MULCH.get(4), (Object[])new Object[]{Mods.Forestry.stack("mulch")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_COMPOST.get(4), (Object[])new Object[]{Mods.Forestry.stack("fertilizer_bio")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_FERTILISER.get(4), (Object[])new Object[]{Mods.Forestry.stack("fertilizer_compound")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_PULP.get(4), (Object[])new Object[]{Mods.Forestry.stack("wood_pulp")});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(BotanyItems.POWDER_SULPHUR.get(4), new Object[]{"dustSulphur"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)this.pigment, 2, EnumFlowerColor.Black.ordinal()), new Object[]{"pigment", "pigment", "dyeBlack"}));
        gardening.registerAcidFertiliser(BotanyItems.POWDER_SULPHUR.get(1), 1);
        gardening.registerAcidFertiliser(BotanyItems.POWDER_MULCH.get(1), 1);
        gardening.registerAcidFertiliser(Mods.Forestry.stack("mulch"), 2);
        for (ItemStack stack : OreDictionary.getOres((String)"dustSulfur")) {
            gardening.registerAcidFertiliser(stack, 2);
        }
        gardening.registerAlkalineFertiliser(BotanyItems.POWDER_ASH.get(1), 1);
        gardening.registerAlkalineFertiliser(BotanyItems.POWDER_PULP.get(1), 1);
        gardening.registerAlkalineFertiliser(Mods.Forestry.stack("ash"), 2);
        gardening.registerAlkalineFertiliser(Mods.Forestry.stack("wood_pulp"), 2);
        gardening.registerNutrientFertiliser(BotanyItems.POWDER_COMPOST.get(1), 1);
        gardening.registerNutrientFertiliser(BotanyItems.POWDER_FERTILISER.get(1), 1);
        gardening.registerNutrientFertiliser(Mods.Forestry.stack("fertilizer_bio"), 2);
        gardening.registerNutrientFertiliser(Mods.Forestry.stack("fertilizer_compound"), 2);
        for (Map.Entry<ItemStack, Integer> entry : queuedAcidFertilisers.entrySet()) {
            this.addAcidFertiliserRecipe(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ItemStack, Integer> entry : queuedAlkalineFertilisers.entrySet()) {
            this.addAlkalineFertiliserRecipe(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ItemStack, Integer> entry : queuedNutrientFertilisers.entrySet()) {
            this.addNutrientFertiliserRecipe(entry.getKey(), entry.getValue());
        }
        GameRegistry.addRecipe((ItemStack)BotanyItems.MORTAR.get(6), (Object[])new Object[]{" c ", "cgc", " c ", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('g'), Blocks.field_150351_n});
        for (EnumFlowerColor c : EnumFlowerColor.values()) {
            ItemStack clay = new ItemStack((Item)this.clay, 1, c.ordinal());
            ItemStack pigment = new ItemStack((Item)this.pigment, 1, c.ordinal());
            GameRegistry.addShapelessRecipe((ItemStack)clay, (Object[])new Object[]{Items.field_151119_aD, Items.field_151119_aD, Items.field_151119_aD, pigment});
            GameRegistry.addSmelting((ItemStack)clay, (ItemStack)TileEntityMetadata.getItemStack(this.ceramic, c.ordinal()), (float)0.0f);
            ItemStack glass = TileEntityMetadata.getItemStack(this.stained, c.ordinal());
            glass.func_190920_e(4);
            GameRegistry.addShapedRecipe((ItemStack)glass, (Object[])new Object[]{" g ", "gpg", " g ", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('p'), pigment});
        }
        GameRegistry.addRecipe((IRecipe)new PigmentRecipe());
    }

    private ItemStack getStack(int type, int pH, int moisture) {
        if (type >= 0 && type <= 2 && pH >= 0 && pH <= 2 && moisture >= 0 && moisture <= 2) {
            return new ItemStack(BotanyCore.getGardening().getSoilBlock(EnumSoilType.values()[type]), 1, BlockSoil.getMeta(EnumAcidity.values()[pH], EnumMoisture.values()[moisture]));
        }
        return ItemStack.field_190927_a;
    }

    private void addAcidFertiliserRecipe(ItemStack stack, int strengthMax) {
        for (int moisture = 0; moisture < 3; ++moisture) {
            for (int pH = 0; pH < 3; ++pH) {
                for (int type = 0; type < 3; ++type) {
                    int numOfBlocks = strengthMax * strengthMax;
                    for (int strength = 1; strength < strengthMax; ++strength) {
                        ItemStack start = this.getStack(type, pH, moisture);
                        ItemStack end = this.getStack(type, pH - strength, moisture);
                        if (!start.func_190926_b() && !end.func_190926_b()) {
                            end.func_190920_e(numOfBlocks);
                            Object[] stacks = new Object[numOfBlocks + 1];
                            for (int i = 0; i < numOfBlocks; ++i) {
                                stacks[i] = start;
                            }
                            stacks[numOfBlocks] = stack.func_77946_l();
                            GameRegistry.addShapelessRecipe((ItemStack)end, (Object[])stacks);
                        }
                        numOfBlocks /= 2;
                    }
                }
            }
        }
    }

    private void addAlkalineFertiliserRecipe(ItemStack stack, int strengthMax) {
        for (int moisture = 0; moisture < 3; ++moisture) {
            for (int pH = 0; pH < 3; ++pH) {
                for (int type = 0; type < 3; ++type) {
                    int numOfBlocks = strengthMax * strengthMax;
                    for (int strength = 1; strength < strengthMax; ++strength) {
                        ItemStack start = this.getStack(type, pH, moisture);
                        ItemStack end = this.getStack(type, pH + strength, moisture);
                        if (!end.func_190926_b()) {
                            end.func_190920_e(numOfBlocks);
                            Object[] stacks = new Object[numOfBlocks + 1];
                            for (int i = 0; i < numOfBlocks; ++i) {
                                stacks[i] = start;
                            }
                            stacks[numOfBlocks] = stack.func_77946_l();
                            GameRegistry.addShapelessRecipe((ItemStack)end, (Object[])stacks);
                        }
                        numOfBlocks /= 2;
                    }
                }
            }
        }
    }

    private void addNutrientFertiliserRecipe(ItemStack stack, int strengthMax) {
        for (int moisture = 0; moisture < 3; ++moisture) {
            for (int pH = 0; pH < 3; ++pH) {
                for (int type = 0; type < 3; ++type) {
                    int numOfBlocks = strengthMax * strengthMax;
                    for (int strength = 1; strength < strengthMax; ++strength) {
                        ItemStack start = this.getStack(type, pH, moisture);
                        ItemStack end = this.getStack(type + strength, pH, moisture);
                        if (!end.func_190926_b()) {
                            end.func_190920_e(numOfBlocks);
                            Object[] stacks = new Object[numOfBlocks + 1];
                            for (int i = 0; i < numOfBlocks; ++i) {
                                stacks[i] = start;
                            }
                            stacks[numOfBlocks] = stack.func_77946_l();
                            GameRegistry.addShapelessRecipe((ItemStack)end, (Object[])stacks);
                        }
                        numOfBlocks /= 2;
                    }
                }
            }
        }
    }
}

