/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.farm;

import binnie.botany.Botany;
import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerRoot;
import binnie.botany.core.BotanyCore;
import binnie.botany.farm.FlowerCrop;
import binnie.botany.flower.TileEntityFlower;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableFlower
implements IFarmable {
    public boolean isSaplingAt(World world, BlockPos pos) {
        return world.func_180495_p(pos) == Botany.flower;
    }

    @Nullable
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        IFlower flower = null;
        if (world.func_175625_s(pos) instanceof TileEntityFlower) {
            flower = ((TileEntityFlower)world.func_175625_s(pos)).getFlower();
        }
        if (flower != null && flower.getAge() > 1) {
            IFlowerRoot flowerRoot = BotanyCore.getFlowerRoot();
            ItemStack mature = flowerRoot.getMemberStack(flower, EnumFlowerStage.FLOWER);
            ItemStack seed = flowerRoot.getMemberStack(flower, EnumFlowerStage.SEED);
            if (mature != null && seed != null) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                return new FlowerCrop(pos, mature, seed);
            }
        }
        return null;
    }

    public boolean isGermling(ItemStack itemstack) {
        EnumFlowerStage stage = BotanyCore.getFlowerRoot().getType(itemstack);
        return stage == EnumFlowerStage.FLOWER || stage == EnumFlowerStage.SEED;
    }

    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        IFlowerRoot flowerRoot = BotanyCore.getFlowerRoot();
        IFlower flower = flowerRoot.getMember(germling);
        flowerRoot.plant(world, pos, flower, player.func_146103_bH());
        return true;
    }
}

