package binnie.extrabees.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.IHiveTile;
import forestry.api.core.Tabs;
import forestry.apiculture.tiles.TileHive;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.blocks.type.EnumHiveType;

public class BlockExtraBeeHive extends Block implements ITileEntityProvider {

	public static final PropertyEnum<EnumHiveType> hiveType = PropertyEnum.func_177709_a("type", EnumHiveType.class);

	public BlockExtraBeeHive() {
		super(ExtraBees.materialBeehive);
		this.func_149715_a(0.2f);
		this.func_149711_c(1.0f);
		this.func_149675_a(true);
		this.setRegistryName("hive");
		this.func_149647_a(Tabs.tabApiculture);
	}

	public String getUnlocalizedName(final ItemStack itemStack) {
		return "extrabees.block.hive." + itemStack.func_77952_i();
	}

	@Override
	public void func_149666_a(@Nonnull final Item itemIn, final CreativeTabs tab, final NonNullList<ItemStack> itemList) {
		for (int i = 0; i < EnumHiveType.values().length; ++i) {
			itemList.add(new ItemStack(this, 1, i));
		}
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(hiveType).ordinal();
	}

	@Override
	@Nonnull
	@SuppressWarnings("deprecation")
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(hiveType, EnumHiveType.values()[meta]);
	}
	
	@Override
	public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
		super.func_180649_a(world, pos, player);
		TileEntity tile = world.func_175625_s(pos);
		if (tile instanceof IHiveTile) {
			IHiveTile hive = (IHiveTile) tile;
			hive.onAttack(world, pos, player);
		}
	}
	
	@Override
	public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
		TileEntity tile = world.func_175625_s(pos);
		if (tile instanceof IHiveTile) {
			IHiveTile hive = (IHiveTile) tile;
			hive.onBroken(world, pos, player, canHarvestBlock(world, pos, player));
		}
	}
	
	@Nullable
	@Override
	public TileEntity func_149915_a(World worldIn, int meta) {
		return new TileHive();
	}
	
	@Override
	@Nonnull
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, hiveType);
	}

	@Override
	@Nonnull
	public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
		List<ItemStack> drops = new ArrayList<>();

		Random random = world instanceof World ? ((World) world).field_73012_v : RANDOM;

		List<IHiveDrop> hiveDrops = getDropsForHive(func_176201_c(state));
		Collections.shuffle(hiveDrops);

		// Grab a princess
		int tries = 0;
		boolean hasPrincess = false;
		while (tries <= 10 && !hasPrincess) {
			tries++;

			for (IHiveDrop drop : hiveDrops) {
				if (random.nextDouble() < drop.getChance(world, pos, fortune)) {
					IBee bee = drop.getBeeType(world, pos);
					if (random.nextFloat() < drop.getIgnobleChance(world, pos, fortune)) {
						bee.setIsNatural(false);
					}

					ItemStack princess = BeeManager.beeRoot.getMemberStack(bee, EnumBeeType.PRINCESS);
					drops.add(princess);
					hasPrincess = true;
					break;
				}
			}
		}

		// Grab drones
		for (IHiveDrop drop : hiveDrops) {
			if (random.nextDouble() < drop.getChance(world, pos, fortune)) {
				IBee bee = drop.getBeeType(world, pos);
				ItemStack drone = BeeManager.beeRoot.getMemberStack(bee, EnumBeeType.DRONE);
				drops.add(drone);
				break;
			}
		}

		// Grab anything else on offer
		for (IHiveDrop drop : hiveDrops) {
			if (random.nextDouble() < drop.getChance(world, pos, fortune)) {
				drops.addAll(drop.getExtraItems(world, pos, fortune));
				break;
			}
		}

		return drops;
	}

	private static List<IHiveDrop> getDropsForHive(int meta) {
		EnumHiveType hive = getHiveNameForMeta(meta);
		if (hive == null) {
			return Collections.emptyList();
		}
		return hive.drops;
	}

	@Nullable
	private static EnumHiveType getHiveNameForMeta(int meta) {
		if (meta < 0 || meta >= EnumHiveType.values().length) {
			return null;
		}
		return EnumHiveType.values()[meta];
	}

}
