package binnie.core.util;

import java.util.IllegalFormatException;

import net.minecraft.util.text.translation.I18n;

import forestry.core.utils.Log;

public class I18N {
	
	public static String localiseOrBlank(String key) {
		String trans = localise(key);
		return trans.equals(key) ? "" : trans;
	}
	
	@SuppressWarnings("deprecation")
	public static String localise(String key) {
		if (I18n.func_94522_b(key)) {
			return I18n.func_74838_a(key);
		} else {
			return I18n.func_150826_b(key);
		}
	}
	
	@SuppressWarnings("deprecation")
	public static boolean canLocalise(String key) {
		return I18n.func_94522_b(key);
	}
	
	public static String localise(String key, Object... format) {
		String s = localise(key);
		try {
			return String.format(s, format);
		} catch (IllegalFormatException e) {
			String errorMessage = "Format error: " + s;
			Log.error(errorMessage, e);
			return errorMessage;
		}
	}
}
