package binnie.core.gui.minecraft;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.events.EventKey;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.renderer.RenderUtil;

@SideOnly(Side.CLIENT)
public class GuiCraftGUI extends GuiContainer {
	Point mousePos;
	private Window window;
	private ItemStack draggedItem;

	public GuiCraftGUI(final Window window) {
		super(window.getContainer());
		this.mousePos = Point.ZERO;
		this.window = window;
		this.draggedItem = ItemStack.field_190927_a;
		this.resize(window.getSize());
	}

	@Override
	public void func_73876_c() {
		this.window.updateClient();
	}

	public Minecraft getMinecraft() {
		return this.field_146297_k;
	}

	@Override
	protected void func_146976_a(final float var1, final int var2, final int var3) {
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
		this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
		this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
		this.window.setSize(new Point(this.field_146999_f, this.field_147000_g));
		this.window.setPosition(new Point(this.field_147003_i, this.field_147009_r));
		this.window.initGui();
	}

	public ItemStack getDraggedItem() {
		return this.draggedItem;
	}

	@Override
	public void func_73863_a(final int mouseX, final int mouseY, final float partialTicks) {
		this.window.setMousePosition(mouseX - this.window.getPosition().xPos(), mouseY - this.window.getPosition().yPos());
		this.func_146276_q_();
		GlStateManager.func_179101_C();
		RenderHelper.func_74518_a();
		GlStateManager.func_179140_f();
		GlStateManager.func_179097_i();
		this.field_73735_i = 10.0f;
		//GuiScreen.itemRender.zLevel = this.zLevel;
		this.window.render(this.field_146294_l, this.field_146295_m);


		GlStateManager.func_179094_E();
		GlStateManager.func_179091_B();
		OpenGlHelper.func_77475_a(OpenGlHelper.field_77476_b, 240.0f, 240.0f);
		final InventoryPlayer playerInventory = this.field_146297_k.field_71439_g.field_71071_by;
		this.draggedItem = playerInventory.func_70445_o();
		if (!this.draggedItem.func_190926_b()) {
			GlStateManager.func_179109_b(0, 0, 200);
			RenderUtil.drawItem(new Point(mouseX - 8, mouseY - 8), this.draggedItem, false);
		}
		RenderHelper.func_74520_c();
		GlStateManager.func_179101_C();
		GlStateManager.func_179121_F();
		GlStateManager.func_179140_f();
		GlStateManager.func_179097_i();
		if(draggedItem.func_190926_b()) {
			final MinecraftTooltip tooltip = new MinecraftTooltip();
			if (this.isHelpMode()) {
				tooltip.setType(Tooltip.Type.HELP);
				this.window.getHelpTooltip(tooltip);
			} else {
				tooltip.setType(Tooltip.Type.STANDARD);
				this.window.getTooltip(tooltip);
			}
			if (tooltip.exists()) {
				this.renderTooltip(new Point(mouseX, mouseY), tooltip);
			}
		}
		this.field_73735_i = 0.0f;
		GlStateManager.func_179145_e();
		GlStateManager.func_179126_j();
	}

	public void renderTooltip(final Point mousePosition, final MinecraftTooltip tooltip) {
		final int mouseX = mousePosition.xPos();
		final int mouseY = mousePosition.yPos();
		final FontRenderer font = this.getFontRenderer();

		boolean containsItemRender = false;

		int k = 0;
		final List<String> strings = new ArrayList<>();
		for (final String string : tooltip.getList()) {
			if (string != null) {
				if (!string.contains(Tooltip.NBT_SEPARATOR)) {
					strings.addAll(font.func_78271_c(string, tooltip.maxWidth));
				} else {
					strings.add(string);
					containsItemRender = true;
				}
			}
		}
		for (final String s : strings) {
			int l = font.func_78256_a(s);
			if (s.contains(Tooltip.NBT_SEPARATOR)) {
				l = 12 + font.func_78256_a(s.replaceAll(Tooltip.NBT_SEPARATOR + "(.*?)" + Tooltip.NBT_SEPARATOR, ""));
			}
			if (l > k) {
				k = l;
			}
		}

		if (!containsItemRender) {
			ItemStack itemStack = tooltip.getItemStack();
			GuiUtils.drawHoveringText(itemStack, strings, mouseX, mouseY, field_146294_l, field_146295_m, tooltip.maxWidth, font);
		} else {
			GlStateManager.func_179101_C();
			RenderHelper.func_74518_a();
			GlStateManager.func_179140_f();
			GlStateManager.func_179097_i();

			int i1 = mouseX + 12;
			int j1 = mouseY - 12;
			int k2 = 8;
			if (strings.size() > 1) {
				k2 += 2 + (strings.size() - 1) * 10;
			}
			if (i1 + k > this.field_146294_l) {
				i1 -= 28 + k;
			}
			if (j1 + k2 + 6 > this.field_146295_m) {
				j1 = this.field_146295_m - k2 - 6;
			}
			this.field_73735_i = 300.0f;
			//GuiScreen.itemRender.zLevel = 300.0f;
			final int l2 = -267386864;
			final int j2;
			final int i2 = j2 = 1342177280 + MinecraftTooltip.getOutline(tooltip.getType());
			this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l2, l2);
			this.func_73733_a(i1 - 3, j1 + k2 + 3, i1 + k + 3, j1 + k2 + 4, l2, l2);
			this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k2 + 3, l2, l2);
			this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k2 + 3, l2, l2);
			this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k2 + 3, l2, l2);
			this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k2 + 3 - 1, i2, j2);
			this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k2 + 3 - 1, i2, j2);
			this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
			this.func_73733_a(i1 - 3, j1 + k2 + 2, i1 + k + 3, j1 + k2 + 3, j2, j2);
			for (int k3 = 0; k3 < strings.size(); ++k3) {
				String s2 = strings.get(k3);
				if (k3 == 0) {
					s2 = MinecraftTooltip.getTitle(tooltip.getType()) + s2;
				} else {
					s2 = MinecraftTooltip.getBody(tooltip.getType()) + s2;
				}
				if (s2.contains(Tooltip.NBT_SEPARATOR)) {
					final String split = s2.split(Tooltip.NBT_SEPARATOR)[1];
					try {
						final NBTTagCompound nbt = JsonToNBT.func_180713_a(split);
						final ItemStack stack = new ItemStack(nbt);
						GlStateManager.func_179094_E();
						GlStateManager.func_179109_b(i1, j1 - 1.5f, 0.0f);
						GlStateManager.func_179152_a(0.6f, 0.6f, 1.0f);
						RenderUtil.drawItem(Point.ZERO, stack, false);
						GlStateManager.func_179121_F();
					} catch (NBTException e) {
						e.printStackTrace();
					}
					s2 = "   " + s2.replaceAll(Tooltip.NBT_SEPARATOR + "(.*?)" + Tooltip.NBT_SEPARATOR, "");
				}
				font.func_175063_a(s2, i1, j1, -1);
				if (k3 == 0) {
					j1 += 2;
				}
				j1 += 10;
			}
			this.field_73735_i = 0.0f;
			//GuiScreen.itemRender.zLevel = 0.0f;
			GlStateManager.func_179145_e();
			GlStateManager.func_179126_j();
			RenderHelper.func_74519_b();
			GlStateManager.func_179091_B();
		}
	}

	@Override
	protected void func_73864_a(final int x, final int y, final int button) {
		IWidget origin = this.window;
		if (this.window.getMousedOverWidget() != null) {
			origin = this.window.getMousedOverWidget();
		}
		this.window.callEvent(new EventMouse.Down(origin, x, y, button));
	}

	public boolean isShiftDown() {
		return Keyboard.isKeyDown(this.field_146297_k.field_71474_y.field_74311_E.func_151463_i());
	}

	@Override
	protected void func_73869_a(final char c, final int key) {
		if (key == 1 || (key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && this.window.getFocusedWidget() == null)) {
			this.field_146297_k.field_71439_g.func_71053_j();
		}
		final IWidget origin = (this.window.getFocusedWidget() == null) ? this.window : this.window.getFocusedWidget();
		this.window.callEvent(new EventKey.Down(origin, c, key));
	}

	@Override
	protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
		//super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
		mouseMovedOrUp(mouseX, mouseY, clickedMouseButton);
	}

	@Override
	protected void func_146286_b(int mouseX, int mouseY, int state) {
		//super.mouseReleased(mouseX, mouseY, state);
		mouseMovedOrUp(mouseX, mouseY, -1);
	}

	//@Override
	protected void mouseMovedOrUp(final int x, final int y, final int button) {
		final IWidget origin = (this.window.getMousedOverWidget() == null) ? this.window : this.window.getMousedOverWidget();
		if (button == 0) {
			final float dx = Mouse.getEventDX() * this.field_146294_l / (float) this.field_146297_k.field_71443_c;
			final float dy = -(Mouse.getEventDY() * this.field_146295_m / (float) this.field_146297_k.field_71440_d);
		} else {
			this.window.callEvent(new EventMouse.Up(origin, x, y, button));
		}
	}

	@Override
	public void func_146274_d() throws IOException {
		super.func_146274_d();
		final int dWheel = Mouse.getDWheel();
		final IWidget origin = (this.window.getFocusedWidget() == null) ? this.window : this.window.getFocusedWidget();
		if (dWheel != 0) {
			this.window.callEvent(new EventMouse.Wheel(this.window, dWheel));
		}
	}

	@Override
	public void func_146281_b() {
		this.window.onClose();
		if (field_146297_k.field_71439_g != null) {
			field_147002_h.func_75134_a(field_146297_k.field_71439_g);
		}
	}

	public boolean isHelpMode() {
		return Keyboard.isKeyDown(15);
	}

	public FontRenderer getFontRenderer() {
		return this.field_146289_q;
	}

	public void resize(final Point size) {
		this.field_146999_f = size.xPos();
		this.field_147000_g = size.yPos();
		this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
		this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
		this.window.setPosition(new Point(this.field_147003_i, this.field_147009_r));
	}
}
