package binnie.botany.genetics;

import net.minecraft.util.IStringSerializable;

import forestry.api.genetics.AlleleManager;

import binnie.botany.core.BotanyCore;
import binnie.core.util.I18N;

//TODO: Clean Up
public enum EnumFlowerColor implements IStringSerializable {
	Aquamarine("aquamarine", 8388564),
	Black("black", 2631720),
	Blue("blue", 255),
	Brown("brown", 10824234),
	CadetBlue("cadetBlue", 6266528),
	Chocolate("chocolate", 13789470),
	Coral("coral", 16744272),
	Crimson("crimson", 14423100),
	Cyan("cyan", 65535),
	DarkGoldenrod("darkGoldenrod", 12092939),
	DarkGray("darkGray", 11119017),
	DarkGreen("darkGreen", 25600),
	DarkKhaki("darkKhaki", 12433259),
	DarkOliveGreen("darkOliveGreen", 5597999),
	DarkOrange("darkOrange", 16747520),
	DarkSalmon("darkSalmon", 15308410),
	DarkSeaGreen("darkSeaGreen", 9419915),
	DarkSlateBlue("darkSlateBlue", 4734347),
	DarkSlateGray("darkSlateGray", 3100495),
	DarkTurquoise("darkTurquoise", 52945),
	DarkViolet("darkViolet", 9699539),
	DeepPink("deepPink", 16716947),
	DeepSkyBlue("deepSkyBlue", 49151),
	DimGray("dimGray", 6908265),
	DodgerBlue("dodgerBlue", 2003199),
	Gold("gold", 16766720),
	Goldenrod("goldenrod", 14329120),
	Gray("gray", 8421504),
	Green("green", 32768),
	HotPink("hotPink", 16738740),
	IndianRed("indianRed", 13458524),
	Indigo("indigo", 4915330),
	Khaki("khaki", 15787660),
	Lavender("lavender", 15132410),
	LemonChiffon("lemonChiffon", 16775885),
	LightGray("lightGray", 13882323),
	LightSeaGreen("lightSeaGreen", 2142890),
	LightSteelBlue("lightSteelBlue", 11584734),
	Lime("lime", 65280),
	LimeGreen("limeGreen", 3329330),
	Magenta("magenta", 16711935),
	Maroon("maroon", 8388608),
	MediumAquamarine("mediumAquamarine", 6737322),
	MediumOrchid("mediumOrchid", 12211667),
	MediumPurple("mediumPurple", 9662683),
	MediumSeaGreen("mediumSeaGreen", 3978097),
	MediumVioletRed("mediumVioletRed", 13047173),
	MistyRose("mistyRose", 16770273),
	Navy("navy", 128),
	Olive("olive", 8421376),
	OliveDrab("oliveDrab", 7048739),
	Orange("orange", 16753920),
	PaleGreen("paleGreen", 10025880),
	PaleTurquoise("paleTurquoise", 11529966),
	PaleVioletRed("paleVioletRed", 14381203),
	Peru("peru", 13468991),
	Pink("pink", 16761035),
	Plum("plum", 14524637),
	Purple("purple", 8388736),
	Red("red", 16711680),
	RosyBrown("rosyBrown", 12357519),
	RoyalBlue("royalBlue", 4286945),
	Salmon("salmon", 16416882),
	SandyBrown("sandyBrown", 16032864),
	SeaGreen("seaGreen", 3050327),
	Sienna("sienna", 10506797),
	SkyBlue("skyBlue", 8900331),
	SlateBlue("slateBlue", 6970061),
	SlateGray("slateGray", 7372944),
	SpringGreen("springGreen", 65407),
	SteelBlue("steelBlue", 4620980),
	Tan("tan", 13808780),
	Teal("teal", 32896),
	Thistle("thistle", 14204888),
	Turquoise("turquoise", 4251856),
	Violet("violet", 15631086),
	Wheat("wheat", 16113331),
	White("white", 16777215),
	Yellow("yellow", 16776960),
	YellowGreen("yellowGreen", 10145074);

	public static final EnumFlowerColor[] VALUES = values();

	private FlowerColorAllele allele;

	EnumFlowerColor(String ident, int c) {
		this(c);
	}

	EnumFlowerColor(int color) {
		int r = color >> 16 & 0xFF;
		int g = color >> 8 & 0xFF;
		int b = color & 0xFF;
		r = (int) (0.45 * (r + 214));
		g = (int) (0.45 * (g + 174));
		b = (int) (0.45 * (b + 131));
		int colorDis = (r << 16) + (g << 8) + b;
		String uid = "botany.color" + name();
		allele = new FlowerColorAllele(uid, ordinal(), color, colorDis, name().toLowerCase(), uid, true);
	}

	public static void addMix(EnumFlowerColor start1, EnumFlowerColor start2, EnumFlowerColor result, int chance) {
		BotanyCore.getFlowerRoot().registerColourMix(new ColorMix(start1.allele, start2.allele, result.allele, chance));
	}

	public static void setupMutations() {
		addMix(EnumFlowerColor.Blue, EnumFlowerColor.Aquamarine, EnumFlowerColor.SteelBlue, 55);
		addMix(EnumFlowerColor.Blue, EnumFlowerColor.Black, EnumFlowerColor.Navy, 85);
		addMix(EnumFlowerColor.Brown, EnumFlowerColor.Aquamarine, EnumFlowerColor.Gray, 50);
		addMix(EnumFlowerColor.Brown, EnumFlowerColor.Black, EnumFlowerColor.Maroon, 90);
		addMix(EnumFlowerColor.Brown, EnumFlowerColor.Blue, EnumFlowerColor.Indigo, 85);
		addMix(EnumFlowerColor.CadetBlue, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumAquamarine, 100);
		addMix(EnumFlowerColor.CadetBlue, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateGray, 75);
		addMix(EnumFlowerColor.CadetBlue, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 85);
		addMix(EnumFlowerColor.Chocolate, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkKhaki, 65);
		addMix(EnumFlowerColor.Chocolate, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 65);
		addMix(EnumFlowerColor.Chocolate, EnumFlowerColor.Brown, EnumFlowerColor.Sienna, 100);
		addMix(EnumFlowerColor.Coral, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkKhaki, 65);
		addMix(EnumFlowerColor.Coral, EnumFlowerColor.Black, EnumFlowerColor.Sienna, 65);
		addMix(EnumFlowerColor.Coral, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 65);
		addMix(EnumFlowerColor.Coral, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.Coral, EnumFlowerColor.CadetBlue, EnumFlowerColor.RosyBrown, 80);
		addMix(EnumFlowerColor.Coral, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 115);
		addMix(EnumFlowerColor.Crimson, EnumFlowerColor.Aquamarine, EnumFlowerColor.RosyBrown, 45);
		addMix(EnumFlowerColor.Crimson, EnumFlowerColor.Black, EnumFlowerColor.Maroon, 80);
		addMix(EnumFlowerColor.Crimson, EnumFlowerColor.Blue, EnumFlowerColor.Indigo, 85);
		addMix(EnumFlowerColor.Crimson, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 115);
		addMix(EnumFlowerColor.Crimson, EnumFlowerColor.Chocolate, EnumFlowerColor.Red, 100);
		addMix(EnumFlowerColor.Crimson, EnumFlowerColor.Coral, EnumFlowerColor.IndianRed, 105);
		addMix(EnumFlowerColor.Cyan, EnumFlowerColor.Aquamarine, EnumFlowerColor.Turquoise, 115);
		addMix(EnumFlowerColor.Cyan, EnumFlowerColor.Blue, EnumFlowerColor.DodgerBlue, 60);
		addMix(EnumFlowerColor.Cyan, EnumFlowerColor.Brown, EnumFlowerColor.CadetBlue, 50);
		addMix(EnumFlowerColor.Cyan, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkTurquoise, 100);
		addMix(EnumFlowerColor.Cyan, EnumFlowerColor.Chocolate, EnumFlowerColor.MediumAquamarine, 65);
		addMix(EnumFlowerColor.Cyan, EnumFlowerColor.Coral, EnumFlowerColor.MediumAquamarine, 65);
		addMix(EnumFlowerColor.Cyan, EnumFlowerColor.Crimson, EnumFlowerColor.SlateGray, 50);
		addMix(EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 55);
		addMix(EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Brown, EnumFlowerColor.Sienna, 85);
		addMix(EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.CadetBlue, EnumFlowerColor.OliveDrab, 90);
		addMix(EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 110);
		addMix(EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Coral, EnumFlowerColor.Peru, 100);
		addMix(EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Crimson, EnumFlowerColor.Sienna, 85);
		addMix(EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Cyan, EnumFlowerColor.MediumSeaGreen, 75);
		addMix(EnumFlowerColor.DarkGray, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.DarkGray, EnumFlowerColor.Black, EnumFlowerColor.DimGray, 70);
		addMix(EnumFlowerColor.DarkGray, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 75);
		addMix(EnumFlowerColor.DarkGray, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.DarkGray, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.DarkGray, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 100);
		addMix(EnumFlowerColor.DarkGray, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 90);
		addMix(EnumFlowerColor.DarkGray, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 95);
		addMix(EnumFlowerColor.DarkGray, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.DarkGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumSeaGreen, 75);
		addMix(EnumFlowerColor.DarkGreen, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 65);
		addMix(EnumFlowerColor.DarkGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.DarkGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkOliveGreen, 70);
		addMix(EnumFlowerColor.DarkGreen, EnumFlowerColor.Coral, EnumFlowerColor.Olive, 60);
		addMix(EnumFlowerColor.DarkGreen, EnumFlowerColor.Crimson, EnumFlowerColor.Sienna, 55);
		addMix(EnumFlowerColor.DarkGreen, EnumFlowerColor.Cyan, EnumFlowerColor.MediumSeaGreen, 70);
		addMix(EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkOliveGreen, 85);
		addMix(EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkGray, EnumFlowerColor.SeaGreen, 85);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 100);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.Black, EnumFlowerColor.DarkOliveGreen, 60);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.Brown, EnumFlowerColor.Chocolate, 75);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.Coral, EnumFlowerColor.SandyBrown, 90);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 75);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.Cyan, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Goldenrod, 110);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkGray, EnumFlowerColor.Tan, 105);
		addMix(EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkGreen, EnumFlowerColor.OliveDrab, 85);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 50);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Brown, EnumFlowerColor.Sienna, 80);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkGoldenrod, 85);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Coral, EnumFlowerColor.Peru, 75);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Crimson, EnumFlowerColor.Brown, 70);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Cyan, EnumFlowerColor.LightSeaGreen, 75);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Olive, 100);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkGreen, EnumFlowerColor.Green, 115);
		addMix(EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkKhaki, EnumFlowerColor.OliveDrab, 95);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkKhaki, 70);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.Black, EnumFlowerColor.Sienna, 60);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.Blue, EnumFlowerColor.Violet, 55);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.Brown, EnumFlowerColor.Chocolate, 85);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkGoldenrod, 80);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 115);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.Coral, EnumFlowerColor.SandyBrown, 115);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.Crimson, EnumFlowerColor.Red, 90);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.Cyan, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Peru, 110);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkGray, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkGreen, EnumFlowerColor.Olive, 70);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Goldenrod, 100);
		addMix(EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkGoldenrod, 80);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.Black, EnumFlowerColor.Sienna, 65);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 70);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.Chocolate, EnumFlowerColor.Coral, 110);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.Coral, EnumFlowerColor.Salmon, 120);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 100);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.Cyan, EnumFlowerColor.MediumAquamarine, 75);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Peru, 100);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkGray, EnumFlowerColor.RosyBrown, 105);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkGreen, EnumFlowerColor.Olive, 65);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Peru, 80);
		addMix(EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 110);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumAquamarine, 110);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Black, EnumFlowerColor.DarkOliveGreen, 60);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 60);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Brown, EnumFlowerColor.Sienna, 65);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.MediumAquamarine, 105);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkGoldenrod, 80);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Coral, EnumFlowerColor.Tan, 80);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 60);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Cyan, EnumFlowerColor.Turquoise, 100);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkKhaki, EnumFlowerColor.YellowGreen, 110);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.OliveDrab, 100);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkOrange, EnumFlowerColor.Goldenrod, 85);
		addMix(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Aquamarine, EnumFlowerColor.CadetBlue, 60);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Blue, EnumFlowerColor.Indigo, 110);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Brown, EnumFlowerColor.Purple, 90);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.CadetBlue, EnumFlowerColor.RoyalBlue, 85);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Chocolate, EnumFlowerColor.Brown, 75);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Coral, EnumFlowerColor.IndianRed, 70);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Crimson, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Cyan, EnumFlowerColor.DeepSkyBlue, 60);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Sienna, 65);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkSlateGray, 75);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Gray, 55);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DimGray, 70);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkOrange, EnumFlowerColor.Sienna, 60);
		addMix(EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.SlateGray, 65);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Aquamarine, EnumFlowerColor.LightSeaGreen, 70);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Blue, EnumFlowerColor.Navy, 95);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.CadetBlue, EnumFlowerColor.Teal, 95);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Chocolate, EnumFlowerColor.Sienna, 80);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Coral, EnumFlowerColor.Sienna, 75);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Crimson, EnumFlowerColor.Brown, 80);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Cyan, EnumFlowerColor.LightSeaGreen, 70);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkOliveGreen, 85);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkGray, EnumFlowerColor.Gray, 85);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkOliveGreen, 100);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkOliveGreen, 75);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkGoldenrod, 70);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Gray, 75);
		addMix(EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.SeaGreen, 80);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Aquamarine, EnumFlowerColor.Turquoise, 110);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Black, EnumFlowerColor.Teal, 55);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 65);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Brown, EnumFlowerColor.Teal, 60);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, EnumFlowerColor.LightSeaGreen, 115);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Chocolate, EnumFlowerColor.SeaGreen, 70);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Coral, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Crimson, EnumFlowerColor.SlateGray, 55);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Cyan, EnumFlowerColor.Turquoise, 115);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkGray, EnumFlowerColor.LightSeaGreen, 100);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 80);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkKhaki, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.SeaGreen, 85);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkSalmon, EnumFlowerColor.LightSeaGreen, 80);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumAquamarine, 105);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SteelBlue, 70);
		addMix(EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Teal, 80);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumPurple, 60);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.Black, EnumFlowerColor.Indigo, 85);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.Brown, EnumFlowerColor.Purple, 90);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.CadetBlue, EnumFlowerColor.SlateBlue, 90);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.Chocolate, EnumFlowerColor.MediumVioletRed, 70);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.Coral, EnumFlowerColor.MediumVioletRed, 75);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.Crimson, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.Cyan, EnumFlowerColor.SteelBlue, 60);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.MediumVioletRed, 55);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkGray, EnumFlowerColor.MediumOrchid, 85);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkKhaki, EnumFlowerColor.MediumOrchid, 50);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Purple, 55);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkOrange, EnumFlowerColor.IndianRed, 60);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkSalmon, EnumFlowerColor.MediumOrchid, 75);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumOrchid, 70);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Indigo, 110);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Indigo, 100);
		addMix(EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.RoyalBlue, 70);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 90);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.Brown, EnumFlowerColor.Crimson, 100);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.CadetBlue, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.Chocolate, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.Coral, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 105);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.Cyan, EnumFlowerColor.MediumPurple, 45);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.IndianRed, 70);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkGray, EnumFlowerColor.PaleVioletRed, 95);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkKhaki, EnumFlowerColor.PaleVioletRed, 65);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.MediumVioletRed, 60);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkOrange, EnumFlowerColor.Salmon, 80);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkSalmon, EnumFlowerColor.PaleVioletRed, 95);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.PaleVioletRed, 55);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumPurple, 55);
		addMix(EnumFlowerColor.DeepPink, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumVioletRed, 100);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkTurquoise, 90);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 75);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Brown, EnumFlowerColor.SteelBlue, 60);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.CadetBlue, EnumFlowerColor.SkyBlue, 105);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Chocolate, EnumFlowerColor.CadetBlue, 70);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Coral, EnumFlowerColor.CadetBlue, 70);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Crimson, EnumFlowerColor.SlateBlue, 60);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Cyan, EnumFlowerColor.SkyBlue, 105);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.MediumSeaGreen, 70);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkGray, EnumFlowerColor.SkyBlue, 105);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkGreen, EnumFlowerColor.Teal, 65);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkKhaki, EnumFlowerColor.LightSeaGreen, 75);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.CadetBlue, 70);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkSalmon, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkTurquoise, 85);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SteelBlue, 75);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.SteelBlue, 80);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.SkyBlue, 110);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkViolet, EnumFlowerColor.RoyalBlue, 70);
		addMix(EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumPurple, 55);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumAquamarine, 80);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 90);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.CadetBlue, EnumFlowerColor.SlateGray, 100);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.Chocolate, EnumFlowerColor.Sienna, 95);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.Coral, EnumFlowerColor.IndianRed, 90);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.Crimson, EnumFlowerColor.Brown, 100);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.Cyan, EnumFlowerColor.LightSeaGreen, 80);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Olive, 95);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.DarkGray, EnumFlowerColor.Gray, 105);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkOliveGreen, 100);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.DarkOrange, EnumFlowerColor.Peru, 90);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.DarkSalmon, EnumFlowerColor.RosyBrown, 95);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, 90);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.DarkViolet, EnumFlowerColor.Purple, 95);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumVioletRed, 95);
		addMix(EnumFlowerColor.DimGray, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SteelBlue, 90);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.Aquamarine, EnumFlowerColor.SkyBlue, 80);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateBlue, 75);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 90);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.Brown, EnumFlowerColor.SlateBlue, 75);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.CadetBlue, EnumFlowerColor.SteelBlue, 100);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.Chocolate, EnumFlowerColor.SlateGray, 75);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.Crimson, EnumFlowerColor.SlateBlue, 75);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.Cyan, EnumFlowerColor.DeepSkyBlue, 85);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.CadetBlue, 70);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkGray, EnumFlowerColor.SteelBlue, 100);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkGreen, EnumFlowerColor.Teal, 65);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkKhaki, EnumFlowerColor.CadetBlue, 65);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.SteelBlue, 70);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkOrange, EnumFlowerColor.Gray, 70);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkSalmon, EnumFlowerColor.SlateGray, 80);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DeepSkyBlue, 80);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.RoyalBlue, 90);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.SteelBlue, 90);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DeepSkyBlue, 95);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkViolet, EnumFlowerColor.SlateBlue, 90);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DeepPink, EnumFlowerColor.SlateBlue, 80);
		addMix(EnumFlowerColor.DodgerBlue, EnumFlowerColor.DimGray, EnumFlowerColor.SteelBlue, 95);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.Aquamarine, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.Brown, EnumFlowerColor.Peru, 65);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.Chocolate, EnumFlowerColor.Orange, 90);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.Coral, EnumFlowerColor.Orange, 90);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.Crimson, EnumFlowerColor.Chocolate, 65);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.Cyan, EnumFlowerColor.PaleGreen, 80);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Goldenrod, 105);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkGreen, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Khaki, 110);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkOrange, EnumFlowerColor.Orange, 100);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Goldenrod, 90);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Olive, 65);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.LimeGreen, 80);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DeepPink, EnumFlowerColor.Coral, 55);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DimGray, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.Gold, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkSeaGreen, 60);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.Aquamarine, EnumFlowerColor.YellowGreen, 85);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 45);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.Brown, EnumFlowerColor.Chocolate, 80);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 105);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.Coral, EnumFlowerColor.DarkOrange, 100);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.Crimson, EnumFlowerColor.Chocolate, 80);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.Cyan, EnumFlowerColor.MediumAquamarine, 80);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Orange, 115);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkGreen, EnumFlowerColor.OliveDrab, 80);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkGoldenrod, 110);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Olive, 90);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkOrange, EnumFlowerColor.Orange, 110);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkSalmon, EnumFlowerColor.SandyBrown, 100);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Olive, 75);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumVioletRed, 50);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DeepPink, EnumFlowerColor.IndianRed, 65);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DimGray, EnumFlowerColor.DarkGoldenrod, 90);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.DodgerBlue, EnumFlowerColor.CadetBlue, 65);
		addMix(EnumFlowerColor.Goldenrod, EnumFlowerColor.Gold, EnumFlowerColor.Orange, 115);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 85);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.CadetBlue, EnumFlowerColor.SlateGray, 105);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 100);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 95);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 90);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Olive, 100);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DarkGray, EnumFlowerColor.SlateGray, 115);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkOliveGreen, 95);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DarkOrange, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DarkSalmon, EnumFlowerColor.RosyBrown, 100);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DimGray, 100);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, 95);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DarkViolet, EnumFlowerColor.Purple, 90);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumVioletRed, 95);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DimGray, EnumFlowerColor.SlateGray, 120);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SteelBlue, 100);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.Gold, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.Gray, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkGoldenrod, 95);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Black, EnumFlowerColor.DarkGreen, 85);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 60);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Brown, EnumFlowerColor.DarkOliveGreen, 60);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.CadetBlue, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Chocolate, EnumFlowerColor.Olive, 70);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Coral, EnumFlowerColor.Olive, 65);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Cyan, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.OliveDrab, 90);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkGray, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkOliveGreen, 120);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkKhaki, EnumFlowerColor.OliveDrab, 95);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkGreen, 115);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkOrange, EnumFlowerColor.Olive, 70);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkSalmon, EnumFlowerColor.OliveDrab, 70);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumSeaGreen, 100);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkSlateGray, 70);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkGreen, 95);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SeaGreen, 70);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DimGray, EnumFlowerColor.DarkGreen, 100);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.DodgerBlue, EnumFlowerColor.Teal, 65);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Gold, EnumFlowerColor.YellowGreen, 80);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Goldenrod, EnumFlowerColor.OliveDrab, 85);
		addMix(EnumFlowerColor.Green, EnumFlowerColor.Gray, EnumFlowerColor.SeaGreen, 100);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Aquamarine, EnumFlowerColor.Thistle, 50);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 80);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 90);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.CadetBlue, EnumFlowerColor.Plum, 85);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Chocolate, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Coral, EnumFlowerColor.Salmon, 95);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Crimson, EnumFlowerColor.DeepPink, 100);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Cyan, EnumFlowerColor.SkyBlue, 55);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Salmon, 70);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkGray, EnumFlowerColor.PaleVioletRed, 100);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkKhaki, EnumFlowerColor.RosyBrown, 70);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.IndianRed, 60);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkOrange, EnumFlowerColor.Coral, 80);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkSalmon, EnumFlowerColor.PaleVioletRed, 100);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.RosyBrown, 60);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumOrchid, 85);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DodgerBlue, 60);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DeepPink, EnumFlowerColor.PaleVioletRed, 115);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DodgerBlue, 65);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DimGray, EnumFlowerColor.PaleVioletRed, 95);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.DodgerBlue, EnumFlowerColor.MediumPurple, 85);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Gold, EnumFlowerColor.SandyBrown, 60);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkSalmon, 70);
		addMix(EnumFlowerColor.HotPink, EnumFlowerColor.Gray, EnumFlowerColor.PaleVioletRed, 100);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkGray, 55);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Black, EnumFlowerColor.Maroon, 80);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 80);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Brown, EnumFlowerColor.Crimson, 110);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.CadetBlue, EnumFlowerColor.RosyBrown, 80);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Chocolate, EnumFlowerColor.Red, 105);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Coral, EnumFlowerColor.Salmon, 110);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Crimson, EnumFlowerColor.Brown, 115);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Cyan, EnumFlowerColor.CadetBlue, 60);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Chocolate, 90);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkGray, EnumFlowerColor.RosyBrown, 100);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkOliveGreen, 60);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Peru, 85);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Sienna, 80);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkOrange, EnumFlowerColor.Chocolate, 95);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Salmon, 110);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Peru, 75);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, 65);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DeepPink, EnumFlowerColor.PaleVioletRed, 110);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SteelBlue, 70);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.DodgerBlue, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Gold, EnumFlowerColor.Orange, 75);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Goldenrod, EnumFlowerColor.Peru, 85);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Gray, EnumFlowerColor.RosyBrown, 100);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.Green, EnumFlowerColor.DarkOliveGreen, 60);
		addMix(EnumFlowerColor.IndianRed, EnumFlowerColor.HotPink, EnumFlowerColor.PaleVioletRed, 105);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.Black, EnumFlowerColor.Navy, 95);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.Blue, EnumFlowerColor.Navy, 110);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.Brown, EnumFlowerColor.Purple, 90);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkSlateBlue, 80);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.Coral, EnumFlowerColor.MediumVioletRed, 65);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.Crimson, EnumFlowerColor.Purple, 85);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Brown, 55);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DarkGray, EnumFlowerColor.SlateBlue, 70);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DarkOrange, EnumFlowerColor.Brown, 55);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DarkSalmon, EnumFlowerColor.MediumVioletRed, 65);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Navy, 115);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkSlateBlue, 100);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.RoyalBlue, 55);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DarkViolet, EnumFlowerColor.Purple, 110);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DeepPink, EnumFlowerColor.Purple, 90);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.RoyalBlue, 60);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DimGray, EnumFlowerColor.DarkSlateBlue, 90);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SlateBlue, 80);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.Goldenrod, EnumFlowerColor.Brown, 45);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.Gray, EnumFlowerColor.DarkSlateBlue, 85);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.Green, EnumFlowerColor.DarkSlateGray, 65);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.HotPink, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.Indigo, EnumFlowerColor.IndianRed, EnumFlowerColor.Purple, 85);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleGreen, 100);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Brown, EnumFlowerColor.Peru, 65);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Chocolate, EnumFlowerColor.Goldenrod, 85);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Coral, EnumFlowerColor.SandyBrown, 90);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Crimson, EnumFlowerColor.Salmon, 65);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Cyan, EnumFlowerColor.Aquamarine, 90);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Goldenrod, 100);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkGreen, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Wheat, 115);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkOrange, EnumFlowerColor.Goldenrod, 95);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkKhaki, 105);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Gray, 50);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DeepPink, EnumFlowerColor.PaleVioletRed, 60);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Turquoise, 75);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DimGray, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SkyBlue, 60);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Gold, EnumFlowerColor.Yellow, 115);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Goldenrod, EnumFlowerColor.Gold, 110);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Gray, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.Green, EnumFlowerColor.YellowGreen, 85);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.HotPink, EnumFlowerColor.DarkSalmon, 65);
		addMix(EnumFlowerColor.Khaki, EnumFlowerColor.IndianRed, EnumFlowerColor.SandyBrown, 75);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Blue, EnumFlowerColor.MediumPurple, 65);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Brown, EnumFlowerColor.RosyBrown, 70);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.CadetBlue, EnumFlowerColor.SkyBlue, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkSalmon, 85);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 90);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Cyan, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkGray, EnumFlowerColor.LightGray, 110);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Wheat, 90);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkGray, 75);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 85);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Pink, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumPurple, 70);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkGray, 70);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 75);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 85);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DimGray, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.DodgerBlue, EnumFlowerColor.LightSteelBlue, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 85);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Goldenrod, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Gray, EnumFlowerColor.DarkGray, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Green, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.HotPink, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.IndianRed, EnumFlowerColor.RosyBrown, 85);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Indigo, EnumFlowerColor.MediumPurple, 55);
		addMix(EnumFlowerColor.Lavender, EnumFlowerColor.Khaki, EnumFlowerColor.LemonChiffon, 90);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleGreen, 105);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Blue, EnumFlowerColor.MediumPurple, 45);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Brown, EnumFlowerColor.DarkSalmon, 65);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Chocolate, EnumFlowerColor.SandyBrown, 85);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Coral, EnumFlowerColor.SandyBrown, 90);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Crimson, EnumFlowerColor.Salmon, 70);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Cyan, EnumFlowerColor.Aquamarine, 95);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkGray, EnumFlowerColor.LightGray, 100);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Khaki, 110);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkOrange, EnumFlowerColor.Orange, 95);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Khaki, 105);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkGray, 55);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Turquoise, 95);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkViolet, EnumFlowerColor.Violet, 50);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 65);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.PaleTurquoise, 80);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DimGray, EnumFlowerColor.DarkGray, 80);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SkyBlue, 70);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 105);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Goldenrod, EnumFlowerColor.Khaki, 100);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Gray, EnumFlowerColor.DarkGray, 90);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Green, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.HotPink, EnumFlowerColor.Pink, 75);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.IndianRed, EnumFlowerColor.DarkSalmon, 80);
		addMix(EnumFlowerColor.LemonChiffon, EnumFlowerColor.Khaki, EnumFlowerColor.Wheat, 115);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleTurquoise, 100);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Black, EnumFlowerColor.DimGray, 45);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 65);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Brown, EnumFlowerColor.RosyBrown, 75);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.CadetBlue, EnumFlowerColor.SkyBlue, 100);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Chocolate, EnumFlowerColor.SandyBrown, 90);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 95);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Cyan, EnumFlowerColor.Turquoise, 100);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkGray, EnumFlowerColor.LightSteelBlue, 115);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 75);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Wheat, 105);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 95);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkSalmon, EnumFlowerColor.RosyBrown, 100);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Gray, 75);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Turquoise, 100);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 75);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 90);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 100);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DimGray, EnumFlowerColor.DarkGray, 95);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DeepSkyBlue, 95);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 95);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Gray, EnumFlowerColor.DarkGray, 100);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Green, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.HotPink, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.IndianRed, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Indigo, EnumFlowerColor.MediumPurple, 55);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.Khaki, EnumFlowerColor.LemonChiffon, 105);
		addMix(EnumFlowerColor.LightGray, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Wheat, 110);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.Turquoise, 105);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateGray, 65);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 70);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Brown, EnumFlowerColor.DimGray, 60);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkTurquoise, 120);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 110);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.OliveDrab, 85);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkGray, EnumFlowerColor.CadetBlue, 105);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkOrange, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkSalmon, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumAquamarine, 110);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SteelBlue, 75);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Teal, 90);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Turquoise, 120);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkViolet, EnumFlowerColor.SlateBlue, 75);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumOrchid, 65);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 105);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DimGray, EnumFlowerColor.Teal, 95);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DeepSkyBlue, 95);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Gold, EnumFlowerColor.YellowGreen, 85);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Gray, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Green, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.IndianRed, EnumFlowerColor.Gray, 70);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Indigo, EnumFlowerColor.RoyalBlue, 65);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Khaki, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Lavender, EnumFlowerColor.DarkTurquoise, 95);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.LemonChiffon, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.LightSeaGreen, EnumFlowerColor.LightGray, EnumFlowerColor.DarkTurquoise, 100);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Black, EnumFlowerColor.DimGray, 55);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 80);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Brown, EnumFlowerColor.RosyBrown, 75);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.CadetBlue, EnumFlowerColor.SkyBlue, 105);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkSalmon, 85);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Coral, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 100);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkGray, EnumFlowerColor.LightGray, 115);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 70);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkOrange, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkSalmon, EnumFlowerColor.RosyBrown, 95);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.SlateGray, 80);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.SkyBlue, 105);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumPurple, 85);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 85);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 110);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DimGray, EnumFlowerColor.SlateGray, 95);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DeepSkyBlue, 105);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 80);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Gray, EnumFlowerColor.DarkGray, 105);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Green, EnumFlowerColor.MediumSeaGreen, 75);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.HotPink, EnumFlowerColor.Plum, 90);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.IndianRed, EnumFlowerColor.RosyBrown, 85);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Indigo, EnumFlowerColor.SlateBlue, 65);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Khaki, EnumFlowerColor.LemonChiffon, 85);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Lavender, EnumFlowerColor.LightGray, 115);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.LemonChiffon, EnumFlowerColor.LightGray, 95);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.LightGray, EnumFlowerColor.Lavender, 115);
		addMix(EnumFlowerColor.LightSteelBlue, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkTurquoise, 100);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Aquamarine, EnumFlowerColor.SpringGreen, 105);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.CadetBlue, EnumFlowerColor.LimeGreen, 85);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Chocolate, EnumFlowerColor.YellowGreen, 60);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Coral, EnumFlowerColor.YellowGreen, 55);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Cyan, EnumFlowerColor.SpringGreen, 90);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.LimeGreen, 80);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkGray, EnumFlowerColor.LimeGreen, 90);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkGreen, EnumFlowerColor.LimeGreen, 80);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkKhaki, EnumFlowerColor.LimeGreen, 100);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.LimeGreen, 85);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkOrange, EnumFlowerColor.YellowGreen, 65);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkSalmon, EnumFlowerColor.LimeGreen, 65);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.LimeGreen, 105);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumSeaGreen, 50);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.MediumSeaGreen, 65);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.SpringGreen, 90);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SpringGreen, 65);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DimGray, EnumFlowerColor.LimeGreen, 80);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.DodgerBlue, EnumFlowerColor.MediumSeaGreen, 55);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Gold, EnumFlowerColor.YellowGreen, 95);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Goldenrod, EnumFlowerColor.LimeGreen, 85);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Gray, EnumFlowerColor.LimeGreen, 85);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Green, EnumFlowerColor.LimeGreen, 90);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.IndianRed, EnumFlowerColor.LimeGreen, 45);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Khaki, EnumFlowerColor.PaleGreen, 100);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.Lavender, EnumFlowerColor.PaleGreen, 85);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.LemonChiffon, EnumFlowerColor.PaleGreen, 100);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.LightGray, EnumFlowerColor.SpringGreen, 95);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.LimeGreen, 90);
		addMix(EnumFlowerColor.Lime, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.SpringGreen, 80);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.SpringGreen, 105);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Black, EnumFlowerColor.DarkGreen, 55);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Blue, EnumFlowerColor.SteelBlue, 50);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Brown, EnumFlowerColor.DarkOliveGreen, 45);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.MediumSeaGreen, 95);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.OliveDrab, 65);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Coral, EnumFlowerColor.DarkKhaki, 60);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Cyan, EnumFlowerColor.SpringGreen, 90);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.OliveDrab, 90);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkGray, EnumFlowerColor.MediumSeaGreen, 95);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkGreen, EnumFlowerColor.Green, 90);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkKhaki, EnumFlowerColor.YellowGreen, 105);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.OliveDrab, 95);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkOrange, EnumFlowerColor.YellowGreen, 70);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkSalmon, EnumFlowerColor.YellowGreen, 70);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumSeaGreen, 110);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SeaGreen, 55);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.SeaGreen, 75);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumSeaGreen, 95);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkViolet, EnumFlowerColor.DimGray, 55);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.MediumAquamarine, 70);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DimGray, EnumFlowerColor.SeaGreen, 85);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.DodgerBlue, EnumFlowerColor.LightSeaGreen, 65);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Gold, EnumFlowerColor.YellowGreen, 95);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Goldenrod, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Gray, EnumFlowerColor.MediumSeaGreen, 90);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Green, EnumFlowerColor.MediumSeaGreen, 105);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.IndianRed, EnumFlowerColor.OliveDrab, 55);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateGray, 50);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Khaki, EnumFlowerColor.YellowGreen, 100);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Lavender, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.LemonChiffon, EnumFlowerColor.PaleGreen, 100);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.LightGray, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumSeaGreen, 100);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.LimeGreen, EnumFlowerColor.Lime, EnumFlowerColor.SpringGreen, 115);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Aquamarine, EnumFlowerColor.Violet, 70);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Black, EnumFlowerColor.Purple, 70);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 95);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Brown, EnumFlowerColor.MediumVioletRed, 85);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.CadetBlue, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Chocolate, EnumFlowerColor.DeepPink, 75);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Coral, EnumFlowerColor.DeepPink, 80);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Crimson, EnumFlowerColor.DeepPink, 90);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Cyan, EnumFlowerColor.MediumPurple, 65);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DeepPink, 60);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkGray, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkKhaki, EnumFlowerColor.HotPink, 55);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.MediumVioletRed, 50);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkOrange, EnumFlowerColor.DeepPink, 65);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkSalmon, EnumFlowerColor.HotPink, 85);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumOrchid, 50);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkViolet, 90);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkViolet, 90);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumPurple, 75);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 105);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 110);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.MediumPurple, 70);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DimGray, EnumFlowerColor.MediumOrchid, 90);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SlateBlue, 85);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Goldenrod, EnumFlowerColor.DeepPink, 55);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Gray, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.HotPink, EnumFlowerColor.Violet, 110);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.IndianRed, EnumFlowerColor.DeepPink, 95);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Indigo, EnumFlowerColor.DarkViolet, 90);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Khaki, EnumFlowerColor.HotPink, 50);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.Lavender, EnumFlowerColor.Violet, 90);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Violet, 60);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.LightGray, EnumFlowerColor.Violet, 90);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.Magenta, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Blue, EnumFlowerColor.Indigo, 80);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Chocolate, EnumFlowerColor.Sienna, 95);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Coral, EnumFlowerColor.Sienna, 85);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Crimson, EnumFlowerColor.Brown, 105);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Sienna, 85);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DarkGray, EnumFlowerColor.Brown, 75);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Sienna, 65);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DarkOrange, EnumFlowerColor.Sienna, 80);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Brown, 80);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Sienna, 55);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkSlateGray, 50);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DarkViolet, EnumFlowerColor.Purple, 85);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DeepPink, EnumFlowerColor.Crimson, 90);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.RoyalBlue, 50);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DimGray, EnumFlowerColor.Brown, 95);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkSlateBlue, 70);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Gold, EnumFlowerColor.Chocolate, 55);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Goldenrod, EnumFlowerColor.Sienna, 70);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Gray, EnumFlowerColor.Brown, 90);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Green, EnumFlowerColor.Olive, 60);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.HotPink, EnumFlowerColor.Crimson, 80);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.IndianRed, EnumFlowerColor.Brown, 100);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Indigo, EnumFlowerColor.Purple, 90);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Khaki, EnumFlowerColor.Chocolate, 55);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Lavender, EnumFlowerColor.RosyBrown, 60);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkSalmon, 55);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.LightGray, EnumFlowerColor.IndianRed, 65);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DimGray, 60);
		addMix(EnumFlowerColor.Maroon, EnumFlowerColor.Magenta, EnumFlowerColor.MediumVioletRed, 75);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Aquamarine, EnumFlowerColor.Turquoise, 115);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateGray, 55);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 60);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Brown, EnumFlowerColor.Gray, 55);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.CadetBlue, EnumFlowerColor.LightSeaGreen, 110);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Coral, EnumFlowerColor.Tan, 70);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Crimson, EnumFlowerColor.RosyBrown, 55);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Cyan, EnumFlowerColor.Turquoise, 110);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkSeaGreen, 100);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 85);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkSeaGreen, 105);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumSeaGreen, 115);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SlateGray, 65);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Teal, 80);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Turquoise, 115);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkViolet, EnumFlowerColor.SlateBlue, 70);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DeepPink, EnumFlowerColor.PaleVioletRed, 45);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkTurquoise, 95);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DimGray, EnumFlowerColor.CadetBlue, 90);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DeepSkyBlue, 85);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Gold, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Gray, EnumFlowerColor.CadetBlue, 95);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Green, EnumFlowerColor.MediumSeaGreen, 95);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.HotPink, EnumFlowerColor.Thistle, 55);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.IndianRed, EnumFlowerColor.DarkGray, 65);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Indigo, EnumFlowerColor.SlateBlue, 55);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Khaki, EnumFlowerColor.DarkSeaGreen, 100);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Lavender, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkSeaGreen, 100);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.LightGray, EnumFlowerColor.PaleTurquoise, 100);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Turquoise, 115);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.PaleTurquoise, 100);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 100);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.LimeGreen, EnumFlowerColor.MediumSeaGreen, 110);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 75);
		addMix(EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Maroon, EnumFlowerColor.DimGray, 50);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Aquamarine, EnumFlowerColor.LightSteelBlue, 70);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Black, EnumFlowerColor.Purple, 75);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 100);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Brown, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.CadetBlue, EnumFlowerColor.MediumPurple, 95);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Chocolate, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Coral, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Crimson, EnumFlowerColor.MediumVioletRed, 95);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Cyan, EnumFlowerColor.DodgerBlue, 70);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.IndianRed, 65);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkGray, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkKhaki, EnumFlowerColor.RosyBrown, 60);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkOrange, EnumFlowerColor.IndianRed, 70);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkSalmon, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Plum, 55);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SlateBlue, 100);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkSlateBlue, 95);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DodgerBlue, 75);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumVioletRed, 110);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DodgerBlue, 75);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DimGray, EnumFlowerColor.MediumPurple, 95);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.DodgerBlue, EnumFlowerColor.RoyalBlue, 95);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Gold, EnumFlowerColor.SandyBrown, 50);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Goldenrod, EnumFlowerColor.RosyBrown, 60);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Gray, EnumFlowerColor.MediumPurple, 100);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.HotPink, EnumFlowerColor.Violet, 110);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.IndianRed, EnumFlowerColor.MediumVioletRed, 95);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Indigo, EnumFlowerColor.DarkViolet, 100);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Khaki, EnumFlowerColor.RosyBrown, 55);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Lavender, EnumFlowerColor.Plum, 90);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Plum, 65);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.LightGray, EnumFlowerColor.Plum, 90);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.SteelBlue, 80);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.MediumOrchid, EnumFlowerColor.Maroon, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Aquamarine, EnumFlowerColor.SkyBlue, 75);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateBlue, 75);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 100);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Brown, EnumFlowerColor.MediumVioletRed, 85);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.CadetBlue, EnumFlowerColor.SlateGray, 95);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Chocolate, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Coral, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Crimson, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Cyan, EnumFlowerColor.DeepSkyBlue, 75);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.RosyBrown, 65);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkSlateGray, 70);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkKhaki, EnumFlowerColor.RosyBrown, 65);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DimGray, 65);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkSalmon, 70);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkSalmon, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.SlateGray, 80);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SlateBlue, 105);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.SlateBlue, 95);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DodgerBlue, 85);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkViolet, EnumFlowerColor.SlateBlue, 110);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumOrchid, 100);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DodgerBlue, 90);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DimGray, EnumFlowerColor.SlateBlue, 100);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.DodgerBlue, EnumFlowerColor.RoyalBlue, 105);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Gold, EnumFlowerColor.Tan, 55);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Goldenrod, EnumFlowerColor.RosyBrown, 65);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Green, EnumFlowerColor.Teal, 70);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.HotPink, EnumFlowerColor.MediumOrchid, 105);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.IndianRed, EnumFlowerColor.PaleVioletRed, 95);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Indigo, EnumFlowerColor.DarkViolet, 95);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Khaki, EnumFlowerColor.Thistle, 60);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Lavender, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Thistle, 65);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.LightGray, EnumFlowerColor.Plum, 90);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.SteelBlue, 85);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Lime, EnumFlowerColor.MediumSeaGreen, 60);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.LimeGreen, EnumFlowerColor.CadetBlue, 65);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 110);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.Maroon, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DodgerBlue, 80);
		addMix(EnumFlowerColor.MediumPurple, EnumFlowerColor.MediumOrchid, EnumFlowerColor.SlateBlue, 115);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumAquamarine, 105);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Black, EnumFlowerColor.DarkGreen, 65);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 60);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Brown, EnumFlowerColor.DarkOliveGreen, 55);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.LightSeaGreen, 105);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.OliveDrab, 70);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Coral, EnumFlowerColor.DarkKhaki, 65);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Crimson, EnumFlowerColor.Sienna, 50);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Cyan, EnumFlowerColor.MediumAquamarine, 100);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.OliveDrab, 90);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkSeaGreen, 100);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkSeaGreen, 105);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.SeaGreen, 100);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumAquamarine, 115);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Teal, 70);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.SeaGreen, 85);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumAquamarine, 105);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkViolet, EnumFlowerColor.SlateBlue, 65);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.LightSeaGreen, 85);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DimGray, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DodgerBlue, EnumFlowerColor.CadetBlue, 75);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Gold, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Goldenrod, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Gray, EnumFlowerColor.SeaGreen, 100);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Green, EnumFlowerColor.SeaGreen, 105);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.HotPink, EnumFlowerColor.Gray, 45);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateBlue, 60);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Khaki, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Lavender, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.LightGray, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumAquamarine, 110);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 105);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 70);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Maroon, EnumFlowerColor.DarkOliveGreen, 50);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkSeaGreen, 115);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.MediumOrchid, EnumFlowerColor.SlateGray, 75);
		addMix(EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.MediumPurple, EnumFlowerColor.SlateGray, 75);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Black, EnumFlowerColor.Purple, 85);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 95);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Chocolate, EnumFlowerColor.Crimson, 85);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Coral, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Crimson, EnumFlowerColor.DeepPink, 105);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Cyan, EnumFlowerColor.SteelBlue, 45);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.IndianRed, 70);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkGray, EnumFlowerColor.PaleVioletRed, 90);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkKhaki, EnumFlowerColor.PaleVioletRed, 60);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkOrange, EnumFlowerColor.IndianRed, 70);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkSalmon, EnumFlowerColor.PaleVioletRed, 90);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.PaleVioletRed, 55);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Purple, 100);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Purple, 100);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.RoyalBlue, 55);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkViolet, EnumFlowerColor.Purple, 110);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SlateBlue, 60);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DimGray, EnumFlowerColor.Purple, 100);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SlateBlue, 80);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Gold, EnumFlowerColor.Coral, 50);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Goldenrod, EnumFlowerColor.IndianRed, 60);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.HotPink, EnumFlowerColor.DeepPink, 105);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.IndianRed, EnumFlowerColor.DeepPink, 105);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Indigo, EnumFlowerColor.Purple, 100);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Khaki, EnumFlowerColor.PaleVioletRed, 55);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Lavender, EnumFlowerColor.Violet, 80);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.LemonChiffon, EnumFlowerColor.PaleVioletRed, 60);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.LightGray, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.SlateBlue, 65);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.MediumOrchid, 80);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 105);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Maroon, EnumFlowerColor.Brown, 95);
		addMix(EnumFlowerColor.MediumVioletRed, EnumFlowerColor.MediumPurple, EnumFlowerColor.MediumOrchid, 105);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleTurquoise, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Blue, EnumFlowerColor.MediumPurple, 65);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Brown, EnumFlowerColor.RosyBrown, 75);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.CadetBlue, EnumFlowerColor.LightGray, 85);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkSalmon, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 100);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Cyan, EnumFlowerColor.PaleTurquoise, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Tan, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkGray, EnumFlowerColor.LightGray, 105);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Wheat, 100);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 95);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Pink, 105);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.LemonChiffon, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Plum, 65);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkGray, 65);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.PaleTurquoise, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DarkViolet, EnumFlowerColor.Violet, 70);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DimGray, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.DodgerBlue, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 95);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Goldenrod, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Gray, EnumFlowerColor.DarkGray, 95);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Green, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.HotPink, EnumFlowerColor.Pink, 95);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.IndianRed, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Indigo, EnumFlowerColor.MediumOrchid, 50);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Khaki, EnumFlowerColor.Wheat, 100);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Wheat, 105);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.PaleTurquoise, 85);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Lavender, 105);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Lime, EnumFlowerColor.PaleGreen, 80);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.LimeGreen, EnumFlowerColor.PaleGreen, 80);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Magenta, EnumFlowerColor.Violet, 85);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.Maroon, EnumFlowerColor.IndianRed, 60);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.PaleTurquoise, 90);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Plum, 85);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.MediumPurple, EnumFlowerColor.Plum, 85);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.MistyRose, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.HotPink, 80);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.Blue, EnumFlowerColor.Indigo, 110);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.Brown, EnumFlowerColor.Purple, 85);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkSlateBlue, 75);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.Coral, EnumFlowerColor.Purple, 60);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.Crimson, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkSlateBlue, 65);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkSlateGray, 65);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkSlateBlue, 55);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DarkOrange, EnumFlowerColor.Brown, 50);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.RoyalBlue, 55);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Indigo, 110);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkSlateBlue, 95);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.SteelBlue, 55);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DarkViolet, EnumFlowerColor.Indigo, 105);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DeepPink, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.RoyalBlue, 60);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DimGray, EnumFlowerColor.DarkSlateBlue, 90);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkSlateBlue, 80);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.Gray, EnumFlowerColor.DarkSlateBlue, 80);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.Green, EnumFlowerColor.Teal, 60);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.HotPink, EnumFlowerColor.Purple, 75);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.IndianRed, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.LightGray, EnumFlowerColor.SlateBlue, 50);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.RoyalBlue, 65);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.SlateBlue, 60);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.Magenta, EnumFlowerColor.DarkViolet, 85);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.Maroon, EnumFlowerColor.Purple, 85);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.RoyalBlue, 50);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkSlateBlue, 90);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkSlateBlue, 90);
		addMix(EnumFlowerColor.Navy, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Indigo, 95);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 45);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Brown, EnumFlowerColor.Sienna, 80);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.CadetBlue, EnumFlowerColor.OliveDrab, 95);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkGoldenrod, 95);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Coral, EnumFlowerColor.Peru, 85);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Crimson, EnumFlowerColor.Sienna, 75);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Cyan, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkGray, EnumFlowerColor.OliveDrab, 95);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkGreen, EnumFlowerColor.Green, 105);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkKhaki, EnumFlowerColor.OliveDrab, 110);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.OliveDrab, 110);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkGoldenrod, 95);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkGoldenrod, 90);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.OliveDrab, 100);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DimGray, 60);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkOliveGreen, 90);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumVioletRed, 50);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DeepPink, EnumFlowerColor.IndianRed, 60);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.MediumSeaGreen, 70);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DimGray, EnumFlowerColor.DarkOliveGreen, 100);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.DodgerBlue, EnumFlowerColor.Teal, 60);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Gold, EnumFlowerColor.Goldenrod, 95);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkGoldenrod, 105);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Gray, EnumFlowerColor.OliveDrab, 100);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Green, EnumFlowerColor.OliveDrab, 110);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.HotPink, EnumFlowerColor.IndianRed, 60);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.IndianRed, EnumFlowerColor.Peru, 80);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Khaki, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Lavender, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.LightGray, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 90);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.LimeGreen, EnumFlowerColor.OliveDrab, 100);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Magenta, EnumFlowerColor.MediumVioletRed, 45);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Maroon, EnumFlowerColor.Sienna, 80);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.OliveDrab, 95);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.MediumOrchid, EnumFlowerColor.IndianRed, 55);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.MediumPurple, EnumFlowerColor.Gray, 60);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.OliveDrab, 100);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Brown, 60);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.MistyRose, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.Olive, EnumFlowerColor.Navy, EnumFlowerColor.Gray, 50);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Black, EnumFlowerColor.DarkOliveGreen, 75);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Brown, EnumFlowerColor.Sienna, 70);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.CadetBlue, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkGoldenrod, 85);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Coral, EnumFlowerColor.DarkGoldenrod, 75);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Crimson, EnumFlowerColor.Sienna, 65);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Cyan, EnumFlowerColor.MediumAquamarine, 85);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Olive, 100);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkSeaGreen, 100);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkGreen, EnumFlowerColor.Green, 105);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Olive, 110);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Olive, 115);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkGoldenrod, 85);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkGoldenrod, 85);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumSeaGreen, 110);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DimGray, 55);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkOliveGreen, 90);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumSeaGreen, 90);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DeepPink, EnumFlowerColor.IndianRed, 50);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.LightSeaGreen, 70);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DimGray, EnumFlowerColor.DarkOliveGreen, 100);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.DodgerBlue, EnumFlowerColor.CadetBlue, 65);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Gold, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Goldenrod, EnumFlowerColor.Olive, 100);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Gray, EnumFlowerColor.DarkOliveGreen, 100);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Green, EnumFlowerColor.SeaGreen, 115);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.HotPink, EnumFlowerColor.RosyBrown, 55);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.IndianRed, EnumFlowerColor.DarkGoldenrod, 70);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Khaki, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Lavender, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.LightGray, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumSeaGreen, 95);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 95);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.LimeGreen, EnumFlowerColor.MediumSeaGreen, 105);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.Maroon, EnumFlowerColor.Sienna, 70);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.MediumSeaGreen, 100);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.MediumOrchid, EnumFlowerColor.RosyBrown, 50);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.MediumPurple, EnumFlowerColor.Gray, 55);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.SeaGreen, 110);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Brown, 50);
		addMix(EnumFlowerColor.OliveDrab, EnumFlowerColor.MistyRose, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Aquamarine, EnumFlowerColor.YellowGreen, 80);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Blue, EnumFlowerColor.Plum, 45);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Brown, EnumFlowerColor.Chocolate, 80);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkOrange, 105);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Coral, EnumFlowerColor.DarkOrange, 105);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Crimson, EnumFlowerColor.Chocolate, 80);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Cyan, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Goldenrod, 110);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkGray, EnumFlowerColor.Goldenrod, 95);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkGreen, EnumFlowerColor.Olive, 70);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Goldenrod, 105);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkGoldenrod, 85);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 120);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkSalmon, EnumFlowerColor.SandyBrown, 105);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Peru, 55);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkGoldenrod, 70);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DarkViolet, EnumFlowerColor.IndianRed, 55);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DeepPink, EnumFlowerColor.Salmon, 70);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DimGray, EnumFlowerColor.DarkGoldenrod, 85);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Gold, EnumFlowerColor.Goldenrod, 110);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkGoldenrod, 120);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Gray, EnumFlowerColor.DarkGoldenrod, 90);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Green, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.HotPink, EnumFlowerColor.Coral, 75);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.IndianRed, EnumFlowerColor.Peru, 90);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Khaki, EnumFlowerColor.Gold, 105);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Lavender, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Gold, 100);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.LightGray, EnumFlowerColor.Goldenrod, 95);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Lime, EnumFlowerColor.YellowGreen, 75);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.LimeGreen, EnumFlowerColor.YellowGreen, 80);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Magenta, EnumFlowerColor.PaleVioletRed, 60);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Maroon, EnumFlowerColor.Chocolate, 70);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Salmon, 65);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkSalmon, 65);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Red, 65);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.MistyRose, EnumFlowerColor.SandyBrown, 95);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.Olive, EnumFlowerColor.DarkGoldenrod, 95);
		addMix(EnumFlowerColor.Orange, EnumFlowerColor.OliveDrab, EnumFlowerColor.Goldenrod, 90);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.SpringGreen, 115);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Blue, EnumFlowerColor.SteelBlue, 50);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Brown, EnumFlowerColor.DarkKhaki, 45);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkKhaki, 65);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Coral, EnumFlowerColor.DarkKhaki, 65);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Cyan, EnumFlowerColor.Aquamarine, 100);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.YellowGreen, 85);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkGreen, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkKhaki, EnumFlowerColor.YellowGreen, 105);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumAquamarine, 110);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.CadetBlue, 55);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.MediumSeaGreen, 70);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumPurple, 55);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Turquoise, 75);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DimGray, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkTurquoise, 65);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Gold, EnumFlowerColor.YellowGreen, 95);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Goldenrod, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Gray, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Green, EnumFlowerColor.LimeGreen, 90);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.IndianRed, EnumFlowerColor.DarkKhaki, 55);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Khaki, EnumFlowerColor.YellowGreen, 105);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Lavender, EnumFlowerColor.Aquamarine, 90);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.LightGray, EnumFlowerColor.DarkSeaGreen, 100);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumAquamarine, 100);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Lime, EnumFlowerColor.SpringGreen, 115);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.LimeGreen, EnumFlowerColor.SpringGreen, 115);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Aquamarine, 110);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkGray, 65);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.MediumPurple, EnumFlowerColor.CadetBlue, 65);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.LimeGreen, 110);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.MistyRose, EnumFlowerColor.LemonChiffon, 90);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Olive, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.OliveDrab, EnumFlowerColor.LimeGreen, 95);
		addMix(EnumFlowerColor.PaleGreen, EnumFlowerColor.Orange, EnumFlowerColor.Khaki, 80);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Aquamarine, EnumFlowerColor.Turquoise, 110);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 65);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Brown, EnumFlowerColor.RosyBrown, 60);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkTurquoise, 105);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Chocolate, EnumFlowerColor.Tan, 75);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Coral, EnumFlowerColor.Tan, 80);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 65);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Cyan, EnumFlowerColor.Turquoise, 115);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkGray, EnumFlowerColor.SkyBlue, 105);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkGreen, EnumFlowerColor.MediumSeaGreen, 75);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkSalmon, EnumFlowerColor.LightGray, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumAquamarine, 105);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SteelBlue, 65);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.CadetBlue, 75);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Turquoise, 115);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumPurple, 75);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DeepPink, EnumFlowerColor.Plum, 75);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 105);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DimGray, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DeepSkyBlue, 90);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 90);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Gray, EnumFlowerColor.CadetBlue, 95);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Green, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.HotPink, EnumFlowerColor.Plum, 80);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.IndianRed, EnumFlowerColor.RosyBrown, 70);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Indigo, EnumFlowerColor.MediumPurple, 50);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Khaki, EnumFlowerColor.LemonChiffon, 95);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Lavender, EnumFlowerColor.SkyBlue, 105);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LightGray, EnumFlowerColor.SkyBlue, 110);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkTurquoise, 110);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.SkyBlue, 110);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Lime, EnumFlowerColor.SpringGreen, 95);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LimeGreen, EnumFlowerColor.PaleGreen, 95);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Magenta, EnumFlowerColor.Violet, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Maroon, EnumFlowerColor.RosyBrown, 50);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Turquoise, 110);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Plum, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.MediumPurple, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.MediumAquamarine, 100);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Plum, 70);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.MistyRose, EnumFlowerColor.LightGray, 95);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Olive, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Orange, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.PaleTurquoise, EnumFlowerColor.PaleGreen, EnumFlowerColor.Aquamarine, 100);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkGray, 55);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 85);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 100);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.CadetBlue, EnumFlowerColor.RosyBrown, 80);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Chocolate, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Coral, EnumFlowerColor.Salmon, 100);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 105);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Cyan, EnumFlowerColor.SkyBlue, 50);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Chocolate, 80);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkGray, EnumFlowerColor.RosyBrown, 100);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkOliveGreen, 55);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkSalmon, 75);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Sienna, 70);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkOrange, EnumFlowerColor.Coral, 85);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Salmon, 105);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.RosyBrown, 70);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, 60);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 115);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DodgerBlue, 70);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DodgerBlue, EnumFlowerColor.MediumPurple, 85);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Gold, EnumFlowerColor.SandyBrown, 65);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Goldenrod, EnumFlowerColor.Peru, 80);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Gray, EnumFlowerColor.RosyBrown, 100);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Green, EnumFlowerColor.DarkOliveGreen, 55);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.HotPink, EnumFlowerColor.DeepPink, 120);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Indigo, EnumFlowerColor.Purple, 85);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Khaki, EnumFlowerColor.DarkSalmon, 70);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Lavender, EnumFlowerColor.Thistle, 95);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Pink, 80);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.LightGray, EnumFlowerColor.Pink, 95);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.SlateGray, 65);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Plum, 90);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkSeaGreen, 50);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 105);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Maroon, EnumFlowerColor.Brown, 90);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkGray, 60);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.MediumOrchid, EnumFlowerColor.HotPink, 105);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.MediumPurple, EnumFlowerColor.MediumOrchid, 100);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Gray, 55);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DeepPink, 110);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.MistyRose, EnumFlowerColor.Pink, 95);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Navy, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Olive, EnumFlowerColor.Peru, 70);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.OliveDrab, EnumFlowerColor.Peru, 65);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Orange, EnumFlowerColor.SandyBrown, 80);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkKhaki, 55);
		addMix(EnumFlowerColor.PaleVioletRed, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Thistle, 80);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 60);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Brown, EnumFlowerColor.Sienna, 95);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkOrange, 120);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Coral, EnumFlowerColor.Chocolate, 115);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Cyan, EnumFlowerColor.MediumAquamarine, 75);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Goldenrod, 115);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkGray, EnumFlowerColor.Tan, 100);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkOliveGreen, 80);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Goldenrod, 105);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Olive, 90);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 115);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkSalmon, EnumFlowerColor.SandyBrown, 115);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumVioletRed, 65);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DeepPink, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.CadetBlue, 75);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SlateGray, 75);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Gold, EnumFlowerColor.Goldenrod, 100);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkGoldenrod, 110);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Green, EnumFlowerColor.OliveDrab, 80);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.HotPink, EnumFlowerColor.Salmon, 85);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.IndianRed, EnumFlowerColor.Chocolate, 100);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Indigo, EnumFlowerColor.MediumVioletRed, 65);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Khaki, EnumFlowerColor.Goldenrod, 95);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Lavender, EnumFlowerColor.Tan, 90);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.LightGray, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Tan, 90);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 75);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.LimeGreen, EnumFlowerColor.OliveDrab, 80);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Magenta, EnumFlowerColor.DeepPink, 70);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Maroon, EnumFlowerColor.Sienna, 90);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.MediumOrchid, EnumFlowerColor.PaleVioletRed, 75);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.MediumPurple, EnumFlowerColor.PaleVioletRed, 75);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.OliveDrab, 80);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.IndianRed, 80);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.MistyRose, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Olive, EnumFlowerColor.DarkGoldenrod, 100);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.OliveDrab, EnumFlowerColor.Olive, 95);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.Orange, EnumFlowerColor.DarkOrange, 115);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.Peru, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Salmon, 90);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleTurquoise, 75);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 70);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkGray, 80);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkSalmon, 90);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 100);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 90);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Cyan, EnumFlowerColor.PaleTurquoise, 60);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.SandyBrown, 85);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkGray, EnumFlowerColor.Thistle, 105);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkGreen, EnumFlowerColor.OliveDrab, 60);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Tan, 90);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Tan, 70);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 95);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Salmon, 110);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Tan, 80);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Gray, 65);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.SkyBlue, 65);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 80);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 100);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 80);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DimGray, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.DodgerBlue, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Gold, EnumFlowerColor.Goldenrod, 80);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Goldenrod, EnumFlowerColor.SandyBrown, 90);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Gray, EnumFlowerColor.RosyBrown, 95);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Green, EnumFlowerColor.DarkSeaGreen, 60);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.HotPink, EnumFlowerColor.PaleVioletRed, 105);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.IndianRed, EnumFlowerColor.Salmon, 100);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Indigo, EnumFlowerColor.MediumOrchid, 60);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Khaki, EnumFlowerColor.Wheat, 90);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Lavender, EnumFlowerColor.Thistle, 105);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.LemonChiffon, EnumFlowerColor.MistyRose, 95);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.LightGray, EnumFlowerColor.MistyRose, 105);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.CadetBlue, 70);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Thistle, 100);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 60);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Magenta, EnumFlowerColor.Violet, 95);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Maroon, EnumFlowerColor.IndianRed, 65);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.LightGray, 75);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.MediumPurple, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.HotPink, 90);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.MistyRose, EnumFlowerColor.Thistle, 115);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Navy, EnumFlowerColor.SlateBlue, 50);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Olive, EnumFlowerColor.Tan, 75);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Orange, EnumFlowerColor.SandyBrown, 90);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.PaleGreen, EnumFlowerColor.LemonChiffon, 70);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LightGray, 80);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.HotPink, 105);
		addMix(EnumFlowerColor.Pink, EnumFlowerColor.Peru, EnumFlowerColor.DarkSalmon, 95);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Aquamarine, EnumFlowerColor.SkyBlue, 80);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 80);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Brown, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.CadetBlue, EnumFlowerColor.LightSteelBlue, 90);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Chocolate, EnumFlowerColor.Salmon, 85);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Coral, EnumFlowerColor.Salmon, 90);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 90);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Cyan, EnumFlowerColor.SkyBlue, 75);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkSalmon, 75);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkGray, EnumFlowerColor.Thistle, 105);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkKhaki, EnumFlowerColor.RosyBrown, 75);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.RosyBrown, 65);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkSalmon, 80);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Pink, 95);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkGray, 70);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.SkyBlue, 80);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 90);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 105);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DodgerBlue, 80);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Gold, EnumFlowerColor.Tan, 65);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkSalmon, 75);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Gray, EnumFlowerColor.RosyBrown, 100);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Green, EnumFlowerColor.SeaGreen, 50);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.HotPink, EnumFlowerColor.Violet, 115);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.IndianRed, EnumFlowerColor.PaleVioletRed, 95);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Indigo, EnumFlowerColor.MediumOrchid, 70);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Khaki, EnumFlowerColor.MistyRose, 70);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Lavender, EnumFlowerColor.Thistle, 105);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.LemonChiffon, EnumFlowerColor.MistyRose, 80);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.LightGray, EnumFlowerColor.Thistle, 100);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.SkyBlue, 80);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Thistle, 105);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 45);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkSeaGreen, 50);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Magenta, EnumFlowerColor.Violet, 105);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Maroon, EnumFlowerColor.MediumVioletRed, 70);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Violet, 105);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.MediumPurple, EnumFlowerColor.Violet, 105);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.MediumOrchid, 100);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.MistyRose, EnumFlowerColor.Thistle, 105);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Navy, EnumFlowerColor.SlateBlue, 65);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Olive, EnumFlowerColor.Tan, 65);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.OliveDrab, EnumFlowerColor.Tan, 60);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Orange, EnumFlowerColor.SandyBrown, 75);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkSeaGreen, 55);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Lavender, 90);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.HotPink, 110);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Peru, EnumFlowerColor.RosyBrown, 85);
		addMix(EnumFlowerColor.Plum, EnumFlowerColor.Pink, EnumFlowerColor.Thistle, 110);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumPurple, 50);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Black, EnumFlowerColor.Indigo, 95);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Blue, EnumFlowerColor.Indigo, 105);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Brown, EnumFlowerColor.MediumVioletRed, 95);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkSlateBlue, 80);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Chocolate, EnumFlowerColor.Brown, 75);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Coral, EnumFlowerColor.MediumVioletRed, 70);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Crimson, EnumFlowerColor.MediumVioletRed, 95);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Cyan, EnumFlowerColor.SteelBlue, 50);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Brown, 60);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DarkGray, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DarkOrange, EnumFlowerColor.Crimson, 60);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DarkSalmon, EnumFlowerColor.MediumVioletRed, 75);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Indigo, 110);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Indigo, 105);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.RoyalBlue, 60);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DarkViolet, EnumFlowerColor.Indigo, 115);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumVioletRed, 100);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.RoyalBlue, 60);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SlateBlue, 80);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Goldenrod, EnumFlowerColor.IndianRed, 50);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.HotPink, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.IndianRed, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Lavender, EnumFlowerColor.MediumOrchid, 65);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.LemonChiffon, EnumFlowerColor.PaleVioletRed, 50);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.LightGray, EnumFlowerColor.MediumOrchid, 70);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkSlateBlue, 65);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.MediumOrchid, 70);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Magenta, EnumFlowerColor.DarkViolet, 95);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.SlateBlue, 60);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.MediumOrchid, EnumFlowerColor.DarkViolet, 105);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkViolet, 100);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.MistyRose, EnumFlowerColor.PaleVioletRed, 65);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Navy, EnumFlowerColor.Indigo, 110);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Olive, EnumFlowerColor.Brown, 55);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Orange, EnumFlowerColor.IndianRed, 50);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.MediumPurple, 65);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.MediumVioletRed, 95);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Peru, EnumFlowerColor.MediumVioletRed, 70);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Pink, EnumFlowerColor.MediumOrchid, 70);
		addMix(EnumFlowerColor.Purple, EnumFlowerColor.Plum, EnumFlowerColor.MediumOrchid, 80);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSalmon, 50);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Black, EnumFlowerColor.Maroon, 75);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Blue, EnumFlowerColor.Magenta, 70);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Brown, EnumFlowerColor.Crimson, 110);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.CadetBlue, EnumFlowerColor.IndianRed, 75);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 115);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Chocolate, 90);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkGray, EnumFlowerColor.IndianRed, 90);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkGreen, EnumFlowerColor.Maroon, 55);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Chocolate, 80);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Brown, 70);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkOrange, EnumFlowerColor.Coral, 100);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkSalmon, EnumFlowerColor.IndianRed, 105);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.IndianRed, 65);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.Brown, 80);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Brown, 75);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DimGray, 60);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DeepPink, EnumFlowerColor.Crimson, 95);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Plum, 60);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DimGray, EnumFlowerColor.Brown, 95);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.DodgerBlue, EnumFlowerColor.MediumVioletRed, 75);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Gold, EnumFlowerColor.Chocolate, 75);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Goldenrod, EnumFlowerColor.Chocolate, 85);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Gray, EnumFlowerColor.Crimson, 95);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Green, EnumFlowerColor.Sienna, 50);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.HotPink, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.IndianRed, EnumFlowerColor.Crimson, 110);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Indigo, EnumFlowerColor.Brown, 75);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Khaki, EnumFlowerColor.Coral, 75);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Lavender, EnumFlowerColor.Salmon, 80);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Salmon, 75);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.LightGray, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.Sienna, 60);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.IndianRed, 80);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Magenta, EnumFlowerColor.DeepPink, 85);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Maroon, EnumFlowerColor.Brown, 100);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.IndianRed, 60);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.MediumOrchid, EnumFlowerColor.DeepPink, 85);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.MediumPurple, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.Sienna, 55);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Crimson, 95);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.MistyRose, EnumFlowerColor.Salmon, 85);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Olive, EnumFlowerColor.Sienna, 75);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.OliveDrab, EnumFlowerColor.Sienna, 65);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Orange, EnumFlowerColor.Coral, 90);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.PaleGreen, EnumFlowerColor.Peru, 50);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.IndianRed, 65);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Crimson, 100);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Peru, EnumFlowerColor.Chocolate, 105);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Pink, EnumFlowerColor.Salmon, 90);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Plum, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.Red, EnumFlowerColor.Purple, EnumFlowerColor.Crimson, 80);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 80);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkGray, 90);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 105);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 105);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 100);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 75);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkOliveGreen, 75);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkOrange, EnumFlowerColor.Peru, 100);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Salmon, 115);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DimGray, 80);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 85);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DeepPink, EnumFlowerColor.PaleVioletRed, 105);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 85);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DimGray, EnumFlowerColor.Gray, 100);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SteelBlue, 90);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Gold, EnumFlowerColor.Goldenrod, 85);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Goldenrod, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Green, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.HotPink, EnumFlowerColor.PaleVioletRed, 105);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.IndianRed, EnumFlowerColor.PaleVioletRed, 110);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Indigo, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Khaki, EnumFlowerColor.Tan, 90);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Lavender, EnumFlowerColor.Thistle, 100);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Tan, 90);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.LightGray, EnumFlowerColor.DarkGray, 105);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Thistle, 100);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 65);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Maroon, EnumFlowerColor.Brown, 85);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.MediumOrchid, EnumFlowerColor.PaleVioletRed, 100);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.MediumPurple, EnumFlowerColor.Plum, 100);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DeepPink, 100);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.MistyRose, EnumFlowerColor.Pink, 105);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateBlue, 75);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Olive, EnumFlowerColor.DarkGoldenrod, 90);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.OliveDrab, EnumFlowerColor.Olive, 85);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Orange, EnumFlowerColor.SandyBrown, 95);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.HotPink, 115);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Peru, EnumFlowerColor.DarkSalmon, 105);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Pink, EnumFlowerColor.Thistle, 110);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Plum, EnumFlowerColor.Thistle, 105);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Purple, EnumFlowerColor.MediumVioletRed, 85);
		addMix(EnumFlowerColor.RosyBrown, EnumFlowerColor.Red, EnumFlowerColor.IndianRed, 100);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Aquamarine, EnumFlowerColor.DeepSkyBlue, 70);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateBlue, 80);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 105);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Brown, EnumFlowerColor.DarkSlateBlue, 85);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.CadetBlue, EnumFlowerColor.SteelBlue, 95);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Crimson, EnumFlowerColor.Purple, 85);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Cyan, EnumFlowerColor.DeepSkyBlue, 75);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Gray, 65);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkGray, EnumFlowerColor.SteelBlue, 95);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkSlateGray, 70);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkKhaki, EnumFlowerColor.SlateGray, 60);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.SteelBlue, 70);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkOrange, EnumFlowerColor.RosyBrown, 65);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkSalmon, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.SteelBlue, 75);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SlateBlue, 110);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.SlateBlue, 95);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DodgerBlue, 85);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DarkViolet, EnumFlowerColor.Blue, 105);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DeepPink, EnumFlowerColor.DarkViolet, 90);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DodgerBlue, 95);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DimGray, EnumFlowerColor.SlateBlue, 100);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SteelBlue, 110);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Gold, EnumFlowerColor.DarkKhaki, 50);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Goldenrod, EnumFlowerColor.Gray, 60);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Gray, EnumFlowerColor.SteelBlue, 100);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Green, EnumFlowerColor.Teal, 65);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.HotPink, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.IndianRed, EnumFlowerColor.MediumPurple, 85);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateBlue, 100);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Khaki, EnumFlowerColor.DarkGray, 55);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Lavender, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.LemonChiffon, EnumFlowerColor.LightSteelBlue, 65);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.LightGray, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.SteelBlue, 85);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DodgerBlue, 100);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Lime, EnumFlowerColor.MediumSeaGreen, 55);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.LimeGreen, EnumFlowerColor.LightSeaGreen, 60);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Magenta, EnumFlowerColor.DarkViolet, 95);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Maroon, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DodgerBlue, 80);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.MediumOrchid, EnumFlowerColor.SlateBlue, 105);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.MediumPurple, EnumFlowerColor.SlateBlue, 115);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.SteelBlue, 75);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkViolet, 95);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.MistyRose, EnumFlowerColor.LightSteelBlue, 80);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateBlue, 95);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Olive, EnumFlowerColor.DimGray, 60);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.OliveDrab, EnumFlowerColor.SlateGray, 65);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.PaleGreen, EnumFlowerColor.CadetBlue, 60);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DodgerBlue, 80);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Pink, EnumFlowerColor.MediumPurple, 85);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Plum, EnumFlowerColor.MediumPurple, 95);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Purple, EnumFlowerColor.DarkSlateBlue, 95);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.Red, EnumFlowerColor.MediumVioletRed, 75);
		addMix(EnumFlowerColor.RoyalBlue, EnumFlowerColor.RosyBrown, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkKhaki, 60);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Black, EnumFlowerColor.Brown, 65);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 70);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.CadetBlue, EnumFlowerColor.RosyBrown, 80);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Chocolate, EnumFlowerColor.Coral, 110);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 120);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 105);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Cyan, EnumFlowerColor.LightSeaGreen, 65);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkGray, EnumFlowerColor.RosyBrown, 100);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkGreen, EnumFlowerColor.Olive, 60);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkKhaki, EnumFlowerColor.SandyBrown, 90);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Peru, 75);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkOrange, EnumFlowerColor.Coral, 105);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Coral, 120);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Tan, 75);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumVioletRed, 75);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, 70);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DeepPink, EnumFlowerColor.PaleVioletRed, 105);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SlateGray, 70);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DimGray, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.DodgerBlue, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Gold, EnumFlowerColor.Orange, 80);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Goldenrod, EnumFlowerColor.SandyBrown, 95);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Gray, EnumFlowerColor.RosyBrown, 100);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Green, EnumFlowerColor.Olive, 60);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.HotPink, EnumFlowerColor.PaleVioletRed, 105);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.IndianRed, EnumFlowerColor.DarkSalmon, 115);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Indigo, EnumFlowerColor.MediumVioletRed, 70);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Khaki, EnumFlowerColor.SandyBrown, 85);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Lavender, EnumFlowerColor.Pink, 95);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkSalmon, 85);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.LightGray, EnumFlowerColor.DarkSalmon, 100);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkGray, 70);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Lime, EnumFlowerColor.YellowGreen, 50);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkKhaki, 55);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Magenta, EnumFlowerColor.HotPink, 90);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Maroon, EnumFlowerColor.Crimson, 85);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Tan, 70);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.MediumOrchid, EnumFlowerColor.PaleVioletRed, 90);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.MediumPurple, EnumFlowerColor.PaleVioletRed, 90);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkKhaki, 65);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DeepPink, 95);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.MistyRose, EnumFlowerColor.Pink, 100);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Navy, EnumFlowerColor.Purple, 65);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Olive, EnumFlowerColor.Peru, 80);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.OliveDrab, EnumFlowerColor.Peru, 75);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Orange, EnumFlowerColor.DarkOrange, 95);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkKhaki, 60);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.MistyRose, 80);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.IndianRed, 110);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Peru, EnumFlowerColor.Coral, 105);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Pink, EnumFlowerColor.DarkSalmon, 110);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Plum, EnumFlowerColor.PaleVioletRed, 100);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Purple, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.Red, EnumFlowerColor.IndianRed, 110);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkSalmon, 110);
		addMix(EnumFlowerColor.Salmon, EnumFlowerColor.RoyalBlue, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Black, EnumFlowerColor.Sienna, 60);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 55);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Brown, EnumFlowerColor.Chocolate, 85);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.CadetBlue, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 110);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 115);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 90);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Cyan, EnumFlowerColor.MediumAquamarine, 75);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Peru, 110);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkGray, EnumFlowerColor.Tan, 100);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkGreen, EnumFlowerColor.Olive, 70);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Tan, 105);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkGoldenrod, 85);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkOrange, EnumFlowerColor.Orange, 120);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Coral, 115);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.RosyBrown, 65);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumVioletRed, 65);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DeepPink, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.CadetBlue, 75);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DimGray, EnumFlowerColor.Peru, 90);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SlateGray, 75);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Gold, EnumFlowerColor.Goldenrod, 105);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Goldenrod, EnumFlowerColor.Orange, 115);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Gray, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Green, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.HotPink, EnumFlowerColor.Salmon, 85);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.IndianRed, EnumFlowerColor.Coral, 100);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Indigo, EnumFlowerColor.MediumVioletRed, 55);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Khaki, EnumFlowerColor.Tan, 100);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Lavender, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Wheat, 100);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.LightGray, EnumFlowerColor.Tan, 100);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Tan, 90);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Lime, EnumFlowerColor.YellowGreen, 75);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.LimeGreen, EnumFlowerColor.YellowGreen, 80);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Magenta, EnumFlowerColor.HotPink, 70);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Maroon, EnumFlowerColor.Sienna, 75);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.MediumOrchid, EnumFlowerColor.PaleVioletRed, 75);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.MediumPurple, EnumFlowerColor.RosyBrown, 75);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.IndianRed, 75);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.MistyRose, EnumFlowerColor.Tan, 105);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Olive, EnumFlowerColor.DarkGoldenrod, 95);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkGoldenrod, 90);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Orange, EnumFlowerColor.DarkOrange, 115);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Wheat, 85);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Salmon, 90);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Peru, EnumFlowerColor.DarkOrange, 115);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Pink, EnumFlowerColor.DarkSalmon, 100);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Plum, EnumFlowerColor.DarkSalmon, 85);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Purple, EnumFlowerColor.PaleVioletRed, 60);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Red, EnumFlowerColor.Coral, 100);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkSalmon, 105);
		addMix(EnumFlowerColor.SandyBrown, EnumFlowerColor.Salmon, EnumFlowerColor.DarkSalmon, 105);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 70);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.LightSeaGreen, 105);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.Olive, 75);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Coral, EnumFlowerColor.Olive, 70);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Crimson, EnumFlowerColor.Brown, 55);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Cyan, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.OliveDrab, 90);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkGray, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkGreen, EnumFlowerColor.Green, 110);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkSeaGreen, 100);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Green, 110);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkOrange, EnumFlowerColor.Olive, 75);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumSeaGreen, 110);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.DarkSlateGray, 80);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.LightSeaGreen, 100);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkSlateBlue, 75);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumVioletRed, 45);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DimGray, EnumFlowerColor.Teal, 100);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SteelBlue, 80);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Gold, EnumFlowerColor.YellowGreen, 85);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Goldenrod, EnumFlowerColor.OliveDrab, 90);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Green, EnumFlowerColor.DarkGreen, 115);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.HotPink, EnumFlowerColor.RosyBrown, 50);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.IndianRed, EnumFlowerColor.DimGray, 65);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateBlue, 70);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Khaki, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Lavender, EnumFlowerColor.MediumAquamarine, 85);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.LightGray, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumSeaGreen, 105);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.CadetBlue, 90);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 95);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.LimeGreen, EnumFlowerColor.MediumSeaGreen, 105);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Magenta, EnumFlowerColor.DarkViolet, 75);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.MediumSeaGreen, 105);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.MediumPurple, EnumFlowerColor.SlateGray, 80);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.MistyRose, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateBlue, 70);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Olive, EnumFlowerColor.OliveDrab, 105);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.OliveDrab, EnumFlowerColor.Green, 110);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Orange, EnumFlowerColor.Olive, 80);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.PaleGreen, EnumFlowerColor.MediumSeaGreen, 95);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Gray, 60);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Peru, EnumFlowerColor.OliveDrab, 85);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Pink, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Plum, EnumFlowerColor.SlateGray, 80);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Purple, EnumFlowerColor.DarkSlateBlue, 75);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.Red, EnumFlowerColor.Sienna, 60);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.RoyalBlue, EnumFlowerColor.SteelBlue, 80);
		addMix(EnumFlowerColor.SeaGreen, EnumFlowerColor.SandyBrown, EnumFlowerColor.OliveDrab, 80);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 60);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 75);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Brown, EnumFlowerColor.Maroon, 115);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.CadetBlue, EnumFlowerColor.Gray, 85);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Coral, EnumFlowerColor.Chocolate, 105);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Crimson, EnumFlowerColor.Brown, 110);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Cyan, EnumFlowerColor.LightSeaGreen, 60);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Peru, 100);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DarkGray, EnumFlowerColor.RosyBrown, 95);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkOliveGreen, 80);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Peru, 90);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DarkOrange, EnumFlowerColor.Chocolate, 100);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Chocolate, 100);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, 70);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DarkViolet, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DeepPink, EnumFlowerColor.Crimson, 90);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.CadetBlue, 70);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SlateGray, 75);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Gold, EnumFlowerColor.Goldenrod, 80);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Goldenrod, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Green, EnumFlowerColor.DarkOliveGreen, 75);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.HotPink, EnumFlowerColor.IndianRed, 90);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.IndianRed, EnumFlowerColor.Brown, 110);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Indigo, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Khaki, EnumFlowerColor.Tan, 80);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Lavender, EnumFlowerColor.RosyBrown, 80);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Tan, 75);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.LightGray, EnumFlowerColor.RosyBrown, 85);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.SeaGreen, 75);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.RosyBrown, 80);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Lime, EnumFlowerColor.OliveDrab, 55);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.LimeGreen, EnumFlowerColor.OliveDrab, 65);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Magenta, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Maroon, EnumFlowerColor.Brown, 110);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.MediumOrchid, EnumFlowerColor.MediumVioletRed, 85);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkOliveGreen, 70);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Crimson, 95);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.MistyRose, EnumFlowerColor.DarkSalmon, 85);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Navy, EnumFlowerColor.Purple, 75);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Olive, EnumFlowerColor.DarkGoldenrod, 95);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.OliveDrab, EnumFlowerColor.Olive, 85);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Orange, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkKhaki, 65);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkGray, 70);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.IndianRed, 95);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Peru, EnumFlowerColor.Chocolate, 105);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Pink, EnumFlowerColor.DarkSalmon, 90);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Plum, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Purple, EnumFlowerColor.MediumVioletRed, 85);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Red, EnumFlowerColor.Crimson, 110);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.RosyBrown, EnumFlowerColor.IndianRed, 100);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.Salmon, EnumFlowerColor.IndianRed, 100);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.SandyBrown, EnumFlowerColor.Peru, 100);
		addMix(EnumFlowerColor.Sienna, EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkOliveGreen, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Aquamarine, EnumFlowerColor.Turquoise, 100);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateGray, 55);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Brown, EnumFlowerColor.RosyBrown, 60);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkTurquoise, 110);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Chocolate, EnumFlowerColor.Tan, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Coral, EnumFlowerColor.RosyBrown, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 60);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 110);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkGray, EnumFlowerColor.LightSteelBlue, 105);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 70);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkKhaki, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkOrange, EnumFlowerColor.Tan, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkGray, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SteelBlue, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Turquoise, 115);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumOrchid, 65);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DimGray, EnumFlowerColor.CadetBlue, 90);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DeepSkyBlue, 105);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Gold, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Gray, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Green, EnumFlowerColor.MediumSeaGreen, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.HotPink, EnumFlowerColor.Plum, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.IndianRed, EnumFlowerColor.RosyBrown, 70);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Indigo, EnumFlowerColor.SlateBlue, 60);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Khaki, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Lavender, EnumFlowerColor.LightSteelBlue, 105);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.LemonChiffon, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.LightGray, EnumFlowerColor.LightSteelBlue, 110);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkTurquoise, 110);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DeepSkyBlue, 115);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Lime, EnumFlowerColor.SpringGreen, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.LimeGreen, EnumFlowerColor.MediumAquamarine, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 85);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkTurquoise, 100);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.MediumOrchid, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.MediumPurple, EnumFlowerColor.LightSteelBlue, 95);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.MediumOrchid, 70);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.MistyRose, EnumFlowerColor.LightSteelBlue, 90);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Navy, EnumFlowerColor.RoyalBlue, 55);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Olive, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Orange, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.PaleGreen, EnumFlowerColor.MediumAquamarine, 85);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.DarkTurquoise, 115);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Thistle, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Peru, EnumFlowerColor.DarkGray, 80);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Pink, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Plum, EnumFlowerColor.LightSteelBlue, 90);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Purple, EnumFlowerColor.MediumPurple, 65);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Red, EnumFlowerColor.IndianRed, 65);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.RosyBrown, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.RoyalBlue, EnumFlowerColor.DodgerBlue, 95);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Salmon, EnumFlowerColor.RosyBrown, 75);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.SeaGreen, EnumFlowerColor.LightSeaGreen, 90);
		addMix(EnumFlowerColor.SkyBlue, EnumFlowerColor.Sienna, EnumFlowerColor.Gray, 70);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Aquamarine, EnumFlowerColor.DeepSkyBlue, 70);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateBlue, 85);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Blue, EnumFlowerColor.DarkViolet, 110);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Brown, EnumFlowerColor.Purple, 90);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.CadetBlue, EnumFlowerColor.SteelBlue, 95);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Coral, EnumFlowerColor.PaleVioletRed, 75);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Crimson, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Cyan, EnumFlowerColor.DeepSkyBlue, 70);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.RosyBrown, 65);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkGray, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkSlateGray, 70);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Gray, 60);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkOrange, EnumFlowerColor.IndianRed, 65);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkSalmon, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.SlateGray, 75);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkSlateBlue, 100);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DodgerBlue, 80);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DarkViolet, EnumFlowerColor.Blue, 115);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DodgerBlue, 90);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DimGray, EnumFlowerColor.DarkSlateBlue, 100);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.DodgerBlue, EnumFlowerColor.RoyalBlue, 105);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Gold, EnumFlowerColor.Tan, 50);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Goldenrod, EnumFlowerColor.RosyBrown, 60);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Gray, EnumFlowerColor.MediumPurple, 100);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Green, EnumFlowerColor.Teal, 70);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.HotPink, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.IndianRed, EnumFlowerColor.MediumOrchid, 90);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateBlue, 105);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Khaki, EnumFlowerColor.DarkGray, 55);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Lavender, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Thistle, 60);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.LightGray, EnumFlowerColor.MediumPurple, 85);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.SteelBlue, 85);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.MediumPurple, 95);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Lime, EnumFlowerColor.MediumSeaGreen, 55);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.LimeGreen, EnumFlowerColor.CadetBlue, 60);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 100);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Maroon, EnumFlowerColor.Purple, 80);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.SteelBlue, 75);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.MediumOrchid, EnumFlowerColor.MediumPurple, 110);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.MediumPurple, EnumFlowerColor.RoyalBlue, 115);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.SteelBlue, 75);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkViolet, 100);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.MistyRose, EnumFlowerColor.Plum, 80);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateBlue, 100);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Olive, EnumFlowerColor.DimGray, 60);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.OliveDrab, EnumFlowerColor.DimGray, 55);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Orange, EnumFlowerColor.DarkSalmon, 60);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.PaleGreen, EnumFlowerColor.CadetBlue, 60);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LightSteelBlue, 80);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Pink, EnumFlowerColor.Plum, 85);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Plum, EnumFlowerColor.MediumPurple, 95);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Purple, EnumFlowerColor.DarkViolet, 105);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Red, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.RosyBrown, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.RoyalBlue, EnumFlowerColor.MediumPurple, 120);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.Salmon, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.SandyBrown, EnumFlowerColor.RosyBrown, 70);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.SeaGreen, EnumFlowerColor.SteelBlue, 80);
		addMix(EnumFlowerColor.SlateBlue, EnumFlowerColor.SkyBlue, EnumFlowerColor.DodgerBlue, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumAquamarine, 85);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateGray, 85);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 100);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Chocolate, EnumFlowerColor.Sienna, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Coral, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Crimson, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Olive, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkGray, EnumFlowerColor.Gray, 110);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkOrange, EnumFlowerColor.Peru, 85);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkSalmon, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.CadetBlue, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SlateBlue, 105);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DimGray, 105);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DarkViolet, EnumFlowerColor.SlateBlue, 105);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumVioletRed, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SteelBlue, 105);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DimGray, EnumFlowerColor.Gray, 115);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SteelBlue, 110);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Gold, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkGoldenrod, 85);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Gray, EnumFlowerColor.DimGray, 120);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Green, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.HotPink, EnumFlowerColor.PaleVioletRed, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.IndianRed, EnumFlowerColor.RosyBrown, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateBlue, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Khaki, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Lavender, EnumFlowerColor.LightSteelBlue, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.LemonChiffon, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.LightGray, EnumFlowerColor.DarkGray, 100);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkGray, 105);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 75);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.LimeGreen, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 100);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.CadetBlue, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.MediumOrchid, EnumFlowerColor.MediumPurple, 110);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.MediumPurple, EnumFlowerColor.SlateBlue, 115);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.MistyRose, EnumFlowerColor.DarkGray, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateBlue, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Olive, EnumFlowerColor.OliveDrab, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.OliveDrab, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Orange, EnumFlowerColor.DarkGoldenrod, 85);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.SkyBlue, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.RosyBrown, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Pink, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Purple, EnumFlowerColor.DarkSlateBlue, 95);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Red, EnumFlowerColor.Crimson, 85);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.RosyBrown, EnumFlowerColor.Gray, 100);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.RoyalBlue, EnumFlowerColor.SteelBlue, 115);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.Salmon, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.SandyBrown, EnumFlowerColor.Tan, 90);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.SeaGreen, EnumFlowerColor.Teal, 100);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.SkyBlue, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.SlateGray, EnumFlowerColor.SlateBlue, EnumFlowerColor.MediumPurple, 115);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleGreen, 110);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Blue, EnumFlowerColor.SteelBlue, 45);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.LimeGreen, 60);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Coral, EnumFlowerColor.DarkSeaGreen, 55);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Cyan, EnumFlowerColor.Aquamarine, 100);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.LimeGreen, 80);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkGray, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkGreen, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkKhaki, EnumFlowerColor.LimeGreen, 100);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkOrange, EnumFlowerColor.YellowGreen, 65);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.PaleGreen, 105);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.LightSeaGreen, 50);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.MediumSeaGreen, 65);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DarkViolet, EnumFlowerColor.SteelBlue, 55);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.Turquoise, 75);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DimGray, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkTurquoise, 65);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Gold, EnumFlowerColor.Lime, 90);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Goldenrod, EnumFlowerColor.LimeGreen, 85);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Gray, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Green, EnumFlowerColor.LimeGreen, 90);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.IndianRed, EnumFlowerColor.MediumSeaGreen, 45);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Khaki, EnumFlowerColor.PaleGreen, 100);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Lavender, EnumFlowerColor.Aquamarine, 90);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.LemonChiffon, EnumFlowerColor.PaleGreen, 100);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.LightGray, EnumFlowerColor.Aquamarine, 95);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.MediumAquamarine, 85);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Lime, EnumFlowerColor.PaleGreen, 120);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.LimeGreen, EnumFlowerColor.Lime, 115);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Magenta, EnumFlowerColor.MediumPurple, 60);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.PaleGreen, 110);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.MediumOrchid, EnumFlowerColor.CadetBlue, 65);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.MediumPurple, EnumFlowerColor.LightSeaGreen, 65);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.LimeGreen, 110);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.MistyRose, EnumFlowerColor.Aquamarine, 80);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Olive, EnumFlowerColor.LimeGreen, 90);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.OliveDrab, EnumFlowerColor.LimeGreen, 95);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Orange, EnumFlowerColor.YellowGreen, 75);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.PaleGreen, EnumFlowerColor.Lime, 120);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Aquamarine, 100);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Peru, EnumFlowerColor.LimeGreen, 75);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Pink, EnumFlowerColor.MediumAquamarine, 65);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Plum, EnumFlowerColor.MediumAquamarine, 75);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Purple, EnumFlowerColor.Teal, 50);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.RosyBrown, EnumFlowerColor.MediumSeaGreen, 70);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.RoyalBlue, EnumFlowerColor.LightSeaGreen, 60);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Salmon, EnumFlowerColor.DarkSeaGreen, 50);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.SandyBrown, EnumFlowerColor.LimeGreen, 75);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.SeaGreen, EnumFlowerColor.MediumSeaGreen, 95);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.Sienna, EnumFlowerColor.MediumSeaGreen, 55);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.SkyBlue, EnumFlowerColor.Aquamarine, 85);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.SlateBlue, EnumFlowerColor.LightSeaGreen, 60);
		addMix(EnumFlowerColor.SpringGreen, EnumFlowerColor.SlateGray, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkTurquoise, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateBlue, 85);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 100);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.CadetBlue, EnumFlowerColor.SlateGray, 105);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Chocolate, EnumFlowerColor.Gray, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Coral, EnumFlowerColor.RosyBrown, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Crimson, EnumFlowerColor.MediumVioletRed, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 90);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkGray, EnumFlowerColor.SlateGray, 105);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 75);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkKhaki, EnumFlowerColor.CadetBlue, 75);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Teal, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkGoldenrod, 75);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Gray, 85);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.RoyalBlue, 100);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.RoyalBlue, 100);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkViolet, EnumFlowerColor.SlateBlue, 95);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumOrchid, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DodgerBlue, 105);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.DimGray, EnumFlowerColor.SlateGray, 105);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Gold, EnumFlowerColor.DarkKhaki, 60);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Gray, EnumFlowerColor.SlateGray, 110);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Green, EnumFlowerColor.SeaGreen, 75);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.HotPink, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateBlue, 90);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Khaki, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Lavender, EnumFlowerColor.LightSteelBlue, 90);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.LemonChiffon, EnumFlowerColor.SkyBlue, 75);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.LightGray, EnumFlowerColor.LightSteelBlue, 95);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DodgerBlue, 105);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Lime, EnumFlowerColor.MediumSeaGreen, 65);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.LimeGreen, EnumFlowerColor.MediumSeaGreen, 70);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 85);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.CadetBlue, 90);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.MediumOrchid, EnumFlowerColor.MediumPurple, 95);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.MediumPurple, EnumFlowerColor.RoyalBlue, 105);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkViolet, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.MistyRose, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateBlue, 90);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Olive, EnumFlowerColor.SeaGreen, 75);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.OliveDrab, EnumFlowerColor.SeaGreen, 75);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Orange, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.PaleGreen, EnumFlowerColor.MediumAquamarine, 70);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.SkyBlue, 90);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Peru, EnumFlowerColor.Gray, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Pink, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Plum, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Purple, EnumFlowerColor.DarkSlateBlue, 85);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Red, EnumFlowerColor.MediumVioletRed, 75);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.RosyBrown, EnumFlowerColor.SlateGray, 95);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.RoyalBlue, EnumFlowerColor.DodgerBlue, 115);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Salmon, EnumFlowerColor.RosyBrown, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkGray, 80);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.SeaGreen, EnumFlowerColor.Teal, 90);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.Sienna, EnumFlowerColor.DimGray, 85);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.SkyBlue, EnumFlowerColor.DeepSkyBlue, 105);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.SlateBlue, EnumFlowerColor.RoyalBlue, 110);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.SlateGray, EnumFlowerColor.RoyalBlue, 115);
		addMix(EnumFlowerColor.SteelBlue, EnumFlowerColor.SpringGreen, EnumFlowerColor.MediumAquamarine, 70);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Aquamarine, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Black, EnumFlowerColor.DimGray, 60);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 60);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Brown, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Chocolate, EnumFlowerColor.Peru, 105);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 105);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Crimson, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Cyan, EnumFlowerColor.Turquoise, 90);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Goldenrod, 110);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkGreen, EnumFlowerColor.OliveDrab, 80);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Wheat, 115);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.Olive, 90);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 105);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkSalmon, EnumFlowerColor.SandyBrown, 110);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkKhaki, 105);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.Gray, 75);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 65);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DeepPink, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DimGray, EnumFlowerColor.Gray, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SteelBlue, 80);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Gold, EnumFlowerColor.Goldenrod, 105);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkKhaki, 110);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Gray, EnumFlowerColor.DarkGray, 100);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Green, EnumFlowerColor.OliveDrab, 85);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.HotPink, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.IndianRed, EnumFlowerColor.DarkSalmon, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Khaki, EnumFlowerColor.Wheat, 110);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Lavender, EnumFlowerColor.LightGray, 100);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Wheat, 110);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.LightGray, EnumFlowerColor.Wheat, 110);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkGray, 100);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 90);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.LimeGreen, EnumFlowerColor.YellowGreen, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Magenta, EnumFlowerColor.HotPink, 75);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Maroon, EnumFlowerColor.Sienna, 70);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.MediumOrchid, EnumFlowerColor.PaleVioletRed, 75);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.MediumPurple, EnumFlowerColor.Plum, 80);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.PaleVioletRed, 75);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.MistyRose, EnumFlowerColor.Wheat, 110);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateBlue, 50);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Olive, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Orange, EnumFlowerColor.Goldenrod, 110);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LightGray, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.RosyBrown, 90);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Peru, EnumFlowerColor.SandyBrown, 110);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Pink, EnumFlowerColor.DarkSalmon, 100);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Plum, EnumFlowerColor.Pink, 90);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Purple, EnumFlowerColor.MediumVioletRed, 60);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Red, EnumFlowerColor.IndianRed, 90);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkSalmon, 105);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.RoyalBlue, EnumFlowerColor.SlateGray, 75);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Salmon, EnumFlowerColor.DarkSalmon, 100);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.SandyBrown, EnumFlowerColor.Peru, 115);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.Sienna, EnumFlowerColor.Peru, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkGray, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.SlateGray, EnumFlowerColor.DarkGray, 95);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.SpringGreen, EnumFlowerColor.PaleGreen, 90);
		addMix(EnumFlowerColor.Tan, EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Aquamarine, EnumFlowerColor.LightSeaGreen, 90);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Black, EnumFlowerColor.DarkSlateGray, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Blue, EnumFlowerColor.DarkSlateBlue, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Brown, EnumFlowerColor.DimGray, 75);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.CadetBlue, EnumFlowerColor.LightSeaGreen, 115);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkOliveGreen, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Coral, EnumFlowerColor.Gray, 75);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 90);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.OliveDrab, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkGray, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 100);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkKhaki, EnumFlowerColor.SeaGreen, 90);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.SeaGreen, 100);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkOrange, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkSalmon, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.LightSeaGreen, 100);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.LightSeaGreen, 105);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DarkViolet, EnumFlowerColor.DarkSlateBlue, 90);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DeepPink, EnumFlowerColor.Purple, 70);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SteelBlue, 95);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Gold, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Goldenrod, EnumFlowerColor.OliveDrab, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Gray, EnumFlowerColor.CadetBlue, 105);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Green, EnumFlowerColor.SeaGreen, 100);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.IndianRed, EnumFlowerColor.DimGray, 75);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Indigo, EnumFlowerColor.DarkSlateBlue, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Khaki, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Lavender, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.LemonChiffon, EnumFlowerColor.MediumAquamarine, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.LightGray, EnumFlowerColor.CadetBlue, 90);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.CadetBlue, 110);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.CadetBlue, 95);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.LimeGreen, EnumFlowerColor.MediumSeaGreen, 90);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Magenta, EnumFlowerColor.DarkViolet, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Maroon, EnumFlowerColor.Gray, 70);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.LightSeaGreen, 100);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.MediumOrchid, EnumFlowerColor.RoyalBlue, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.MediumPurple, EnumFlowerColor.SteelBlue, 90);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.SeaGreen, 100);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.DarkSlateBlue, 75);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.MistyRose, EnumFlowerColor.CadetBlue, 75);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Navy, EnumFlowerColor.DarkSlateBlue, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Olive, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.OliveDrab, EnumFlowerColor.SeaGreen, 95);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Orange, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.PaleGreen, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LightSeaGreen, 95);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.SlateGray, 70);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Peru, EnumFlowerColor.SeaGreen, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Pink, EnumFlowerColor.CadetBlue, 65);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Plum, EnumFlowerColor.SteelBlue, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Purple, EnumFlowerColor.DarkSlateBlue, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Red, EnumFlowerColor.Brown, 70);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.RosyBrown, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.RoyalBlue, EnumFlowerColor.SteelBlue, 95);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Salmon, EnumFlowerColor.Gray, 70);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.SandyBrown, EnumFlowerColor.SeaGreen, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Sienna, EnumFlowerColor.DarkOliveGreen, 80);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.SkyBlue, EnumFlowerColor.CadetBlue, 100);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.SlateBlue, EnumFlowerColor.SteelBlue, 95);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.SlateGray, EnumFlowerColor.CadetBlue, 105);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.SpringGreen, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.Teal, EnumFlowerColor.Tan, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleTurquoise, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Black, EnumFlowerColor.DimGray, 55);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 75);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Brown, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.CadetBlue, EnumFlowerColor.LightSteelBlue, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkSalmon, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 95);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 80);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkGray, EnumFlowerColor.LightGray, 110);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkGreen, EnumFlowerColor.SeaGreen, 60);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkGray, 75);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Pink, 100);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumPurple, 75);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.SlateGray, 70);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.SkyBlue, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 95);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DimGray, EnumFlowerColor.DarkGray, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.DodgerBlue, EnumFlowerColor.LightSteelBlue, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 80);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Goldenrod, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Gray, EnumFlowerColor.DarkGray, 100);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Green, EnumFlowerColor.MediumSeaGreen, 65);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.HotPink, EnumFlowerColor.Plum, 105);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.IndianRed, EnumFlowerColor.RosyBrown, 95);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Indigo, EnumFlowerColor.MediumOrchid, 60);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Khaki, EnumFlowerColor.Wheat, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Lavender, EnumFlowerColor.MistyRose, 115);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.LemonChiffon, EnumFlowerColor.MistyRose, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.LightGray, EnumFlowerColor.Lavender, 110);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Lavender, 110);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 65);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.LimeGreen, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Magenta, EnumFlowerColor.Violet, 95);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Maroon, EnumFlowerColor.IndianRed, 65);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.PaleTurquoise, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.MediumPurple, EnumFlowerColor.Plum, 100);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.HotPink, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.MistyRose, EnumFlowerColor.Pink, 115);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Navy, EnumFlowerColor.SlateBlue, 55);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Olive, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Orange, EnumFlowerColor.SandyBrown, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.PaleGreen, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LightSteelBlue, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Plum, 105);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Peru, EnumFlowerColor.DarkSalmon, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Pink, EnumFlowerColor.MistyRose, 115);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Plum, EnumFlowerColor.Pink, 115);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Purple, EnumFlowerColor.MediumOrchid, 75);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Red, EnumFlowerColor.IndianRed, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.RosyBrown, EnumFlowerColor.Pink, 110);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.RoyalBlue, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Salmon, EnumFlowerColor.Pink, 100);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkSalmon, 95);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.SeaGreen, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Sienna, EnumFlowerColor.RosyBrown, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.SkyBlue, EnumFlowerColor.LightSteelBlue, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.SlateBlue, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.SlateGray, EnumFlowerColor.DarkGray, 100);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.SpringGreen, EnumFlowerColor.MediumAquamarine, 85);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.SteelBlue, EnumFlowerColor.LightSteelBlue, 90);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Tan, EnumFlowerColor.MistyRose, 100);
		addMix(EnumFlowerColor.Thistle, EnumFlowerColor.Teal, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Aquamarine, EnumFlowerColor.MediumAquamarine, 115);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Black, EnumFlowerColor.Teal, 50);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Blue, EnumFlowerColor.RoyalBlue, 60);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Brown, EnumFlowerColor.Gray, 55);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.CadetBlue, EnumFlowerColor.LightSeaGreen, 110);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Chocolate, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Coral, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Crimson, EnumFlowerColor.Gray, 50);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Cyan, EnumFlowerColor.DarkTurquoise, 120);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkTurquoise, 100);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkGreen, EnumFlowerColor.MediumSeaGreen, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkKhaki, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkOrange, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.MediumAquamarine, 110);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.SteelBlue, 65);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.CadetBlue, 75);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.Cyan, 120);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DarkViolet, EnumFlowerColor.RoyalBlue, 65);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumPurple, 55);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DarkTurquoise, 100);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DimGray, EnumFlowerColor.CadetBlue, 85);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DeepSkyBlue, 90);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Gold, EnumFlowerColor.YellowGreen, 85);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Gray, EnumFlowerColor.LightSeaGreen, 95);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Green, EnumFlowerColor.MediumSeaGreen, 90);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.HotPink, EnumFlowerColor.LightSteelBlue, 65);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.IndianRed, EnumFlowerColor.CadetBlue, 60);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Indigo, EnumFlowerColor.RoyalBlue, 50);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Khaki, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Lavender, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Aquamarine, 100);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.LightGray, EnumFlowerColor.PaleTurquoise, 100);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.DarkTurquoise, 115);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkTurquoise, 100);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Lime, EnumFlowerColor.SpringGreen, 95);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.LimeGreen, EnumFlowerColor.MediumSeaGreen, 100);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Magenta, EnumFlowerColor.MediumPurple, 75);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Maroon, EnumFlowerColor.DimGray, 45);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkTurquoise, 120);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.MediumOrchid, EnumFlowerColor.DodgerBlue, 75);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.MediumPurple, EnumFlowerColor.DeepSkyBlue, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.MediumAquamarine, 110);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.MediumPurple, 60);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.MistyRose, EnumFlowerColor.PaleTurquoise, 90);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Navy, EnumFlowerColor.SteelBlue, 45);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Olive, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.OliveDrab, EnumFlowerColor.MediumSeaGreen, 90);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Orange, EnumFlowerColor.YellowGreen, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.PaleGreen, EnumFlowerColor.Aquamarine, 105);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Cyan, 115);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.DarkGray, 60);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Peru, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Pink, EnumFlowerColor.PaleTurquoise, 75);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Plum, EnumFlowerColor.SkyBlue, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Purple, EnumFlowerColor.RoyalBlue, 55);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Red, EnumFlowerColor.RosyBrown, 55);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.RosyBrown, EnumFlowerColor.CadetBlue, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.RoyalBlue, EnumFlowerColor.DeepSkyBlue, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Salmon, EnumFlowerColor.DarkGray, 65);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.SeaGreen, EnumFlowerColor.MediumAquamarine, 100);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Sienna, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkTurquoise, 110);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.SlateBlue, EnumFlowerColor.DodgerBlue, 75);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.SlateGray, EnumFlowerColor.LightSeaGreen, 95);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.SpringGreen, EnumFlowerColor.Aquamarine, 105);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.SteelBlue, EnumFlowerColor.CadetBlue, 90);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Tan, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Teal, EnumFlowerColor.LightSeaGreen, 100);
		addMix(EnumFlowerColor.Turquoise, EnumFlowerColor.Thistle, EnumFlowerColor.PaleTurquoise, 85);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Aquamarine, EnumFlowerColor.LightSteelBlue, 75);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Black, EnumFlowerColor.Purple, 60);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Blue, EnumFlowerColor.SlateBlue, 85);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Brown, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.CadetBlue, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Chocolate, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Coral, EnumFlowerColor.PaleVioletRed, 85);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Crimson, EnumFlowerColor.DeepPink, 90);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Cyan, EnumFlowerColor.DeepSkyBlue, 70);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Salmon, 65);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkGray, EnumFlowerColor.Plum, 100);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkKhaki, EnumFlowerColor.RosyBrown, 65);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.RosyBrown, 55);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkOrange, EnumFlowerColor.Salmon, 75);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkSalmon, EnumFlowerColor.HotPink, 90);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.Thistle, 60);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.MediumOrchid, 85);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.DodgerBlue, 75);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 95);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 110);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.DodgerBlue, 75);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DimGray, EnumFlowerColor.MediumOrchid, 90);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.DodgerBlue, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Gold, EnumFlowerColor.SandyBrown, 55);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkSalmon, 65);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Gray, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.HotPink, EnumFlowerColor.Plum, 115);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.IndianRed, EnumFlowerColor.PaleVioletRed, 95);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Indigo, EnumFlowerColor.DarkViolet, 80);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Khaki, EnumFlowerColor.Pink, 60);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Lavender, EnumFlowerColor.Plum, 100);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Pink, 70);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.LightGray, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Plum, 100);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Magenta, EnumFlowerColor.MediumOrchid, 115);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Maroon, EnumFlowerColor.MediumVioletRed, 70);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.Thistle, 80);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Magenta, 115);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.MediumPurple, EnumFlowerColor.MediumOrchid, 110);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkGray, 75);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.MediumOrchid, 100);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.MistyRose, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Navy, EnumFlowerColor.DarkViolet, 75);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Olive, EnumFlowerColor.RosyBrown, 55);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.OliveDrab, EnumFlowerColor.RosyBrown, 50);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Orange, EnumFlowerColor.DarkSalmon, 65);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Thistle, 90);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.HotPink, 110);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Peru, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Pink, EnumFlowerColor.Plum, 105);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Plum, EnumFlowerColor.HotPink, 120);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Purple, EnumFlowerColor.MediumOrchid, 85);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Red, EnumFlowerColor.DeepPink, 85);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.RosyBrown, EnumFlowerColor.Plum, 100);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.RoyalBlue, EnumFlowerColor.MediumPurple, 95);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Salmon, EnumFlowerColor.HotPink, 95);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.SandyBrown, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Sienna, EnumFlowerColor.PaleVioletRed, 80);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.SkyBlue, EnumFlowerColor.Plum, 90);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.SlateBlue, EnumFlowerColor.MediumPurple, 100);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.SlateGray, EnumFlowerColor.Plum, 100);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.SpringGreen, EnumFlowerColor.LightSeaGreen, 70);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.SteelBlue, EnumFlowerColor.MediumPurple, 90);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Tan, EnumFlowerColor.Plum, 80);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Teal, EnumFlowerColor.MediumPurple, 80);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Thistle, EnumFlowerColor.Plum, 105);
		addMix(EnumFlowerColor.Violet, EnumFlowerColor.Turquoise, EnumFlowerColor.LightSteelBlue, 75);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleGreen, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Blue, EnumFlowerColor.MediumPurple, 50);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Brown, EnumFlowerColor.DarkSalmon, 75);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Chocolate, EnumFlowerColor.SandyBrown, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Coral, EnumFlowerColor.SandyBrown, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Crimson, EnumFlowerColor.Salmon, 80);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Cyan, EnumFlowerColor.Turquoise, 90);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Goldenrod, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkGray, EnumFlowerColor.Tan, 105);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkGreen, EnumFlowerColor.OliveDrab, 75);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Khaki, 110);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkOrange, EnumFlowerColor.Orange, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Tan, 105);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkKhaki, 105);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkSlateBlue, EnumFlowerColor.RosyBrown, 60);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkGray, 70);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DarkViolet, EnumFlowerColor.MediumOrchid, 60);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DeepPink, EnumFlowerColor.PaleVioletRed, 75);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 80);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DimGray, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SkyBlue, 75);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 110);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkKhaki, 105);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Gray, EnumFlowerColor.Tan, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Green, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.HotPink, EnumFlowerColor.Pink, 80);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.IndianRed, EnumFlowerColor.DarkSalmon, 85);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Khaki, EnumFlowerColor.LemonChiffon, 115);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Lavender, EnumFlowerColor.LightGray, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Khaki, 120);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.LightGray, EnumFlowerColor.LemonChiffon, 110);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.LightGray, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Lime, EnumFlowerColor.PaleGreen, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.LimeGreen, EnumFlowerColor.YellowGreen, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Magenta, EnumFlowerColor.Violet, 70);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Maroon, EnumFlowerColor.IndianRed, 60);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.DarkSeaGreen, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Plum, 70);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.MediumPurple, EnumFlowerColor.Thistle, 75);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.DarkSeaGreen, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.PaleVioletRed, 70);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.MistyRose, EnumFlowerColor.Tan, 110);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Olive, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Orange, EnumFlowerColor.Goldenrod, 105);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.PaleGreen, EnumFlowerColor.LemonChiffon, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.LemonChiffon, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Pink, 85);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Peru, EnumFlowerColor.Tan, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Pink, EnumFlowerColor.MistyRose, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Plum, EnumFlowerColor.Pink, 85);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Purple, EnumFlowerColor.PaleVioletRed, 55);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Red, EnumFlowerColor.Salmon, 85);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.RosyBrown, EnumFlowerColor.Tan, 100);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.RoyalBlue, EnumFlowerColor.LightSteelBlue, 70);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Salmon, EnumFlowerColor.DarkSalmon, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.SandyBrown, EnumFlowerColor.Tan, 110);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Sienna, EnumFlowerColor.Peru, 85);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.SkyBlue, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.SlateBlue, EnumFlowerColor.Plum, 65);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.SlateGray, EnumFlowerColor.DarkGray, 90);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.SpringGreen, EnumFlowerColor.PaleGreen, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkGray, 75);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Tan, EnumFlowerColor.DarkKhaki, 115);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Teal, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Thistle, EnumFlowerColor.MistyRose, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Turquoise, EnumFlowerColor.MediumAquamarine, 95);
		addMix(EnumFlowerColor.Wheat, EnumFlowerColor.Violet, EnumFlowerColor.Pink, 75);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleTurquoise, 100);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Blue, EnumFlowerColor.MediumPurple, 60);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Brown, EnumFlowerColor.RosyBrown, 70);
		addMix(EnumFlowerColor.White, EnumFlowerColor.CadetBlue, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Chocolate, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Coral, EnumFlowerColor.DarkSalmon, 90);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Crimson, EnumFlowerColor.PaleVioletRed, 75);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Cyan, EnumFlowerColor.PaleTurquoise, 100);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Tan, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkGray, EnumFlowerColor.LightGray, 105);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkGreen, EnumFlowerColor.DarkSeaGreen, 70);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkKhaki, EnumFlowerColor.LemonChiffon, 100);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkOrange, EnumFlowerColor.SandyBrown, 90);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkSalmon, EnumFlowerColor.MistyRose, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkGray, 70);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DarkViolet, EnumFlowerColor.Violet, 70);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DeepPink, EnumFlowerColor.HotPink, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.SkyBlue, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DimGray, EnumFlowerColor.DarkGray, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.DodgerBlue, EnumFlowerColor.SkyBlue, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Goldenrod, EnumFlowerColor.Wheat, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Gray, EnumFlowerColor.LightGray, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Green, EnumFlowerColor.DarkSeaGreen, 75);
		addMix(EnumFlowerColor.White, EnumFlowerColor.HotPink, EnumFlowerColor.Pink, 90);
		addMix(EnumFlowerColor.White, EnumFlowerColor.IndianRed, EnumFlowerColor.Pink, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Indigo, EnumFlowerColor.MediumPurple, 50);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Khaki, EnumFlowerColor.LemonChiffon, 105);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Lavender, EnumFlowerColor.LightGray, 115);
		addMix(EnumFlowerColor.White, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Wheat, 110);
		addMix(EnumFlowerColor.White, EnumFlowerColor.LightGray, EnumFlowerColor.Lavender, 120);
		addMix(EnumFlowerColor.White, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.PaleTurquoise, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Lavender, 110);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Lime, EnumFlowerColor.PaleGreen, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.LimeGreen, EnumFlowerColor.PaleGreen, 90);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Magenta, EnumFlowerColor.Violet, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Maroon, EnumFlowerColor.RosyBrown, 55);
		addMix(EnumFlowerColor.White, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.PaleTurquoise, 100);
		addMix(EnumFlowerColor.White, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Plum, 80);
		addMix(EnumFlowerColor.White, EnumFlowerColor.MediumPurple, EnumFlowerColor.Thistle, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.MediumAquamarine, 90);
		addMix(EnumFlowerColor.White, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Plum, 75);
		addMix(EnumFlowerColor.White, EnumFlowerColor.MistyRose, EnumFlowerColor.LightGray, 115);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Olive, EnumFlowerColor.DarkKhaki, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.OliveDrab, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Orange, EnumFlowerColor.Wheat, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.PaleGreen, EnumFlowerColor.Aquamarine, 100);
		addMix(EnumFlowerColor.White, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Pink, 90);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Peru, EnumFlowerColor.Tan, 90);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Pink, EnumFlowerColor.MistyRose, 105);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Plum, EnumFlowerColor.Thistle, 100);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Purple, EnumFlowerColor.Plum, 60);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Red, EnumFlowerColor.Salmon, 80);
		addMix(EnumFlowerColor.White, EnumFlowerColor.RosyBrown, EnumFlowerColor.MistyRose, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.RoyalBlue, EnumFlowerColor.LightSteelBlue, 80);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Salmon, EnumFlowerColor.Pink, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.SandyBrown, EnumFlowerColor.Wheat, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.SeaGreen, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Sienna, EnumFlowerColor.DarkSalmon, 75);
		addMix(EnumFlowerColor.White, EnumFlowerColor.SkyBlue, EnumFlowerColor.PaleTurquoise, 105);
		addMix(EnumFlowerColor.White, EnumFlowerColor.SlateBlue, EnumFlowerColor.LightSteelBlue, 75);
		addMix(EnumFlowerColor.White, EnumFlowerColor.SlateGray, EnumFlowerColor.LightGray, 90);
		addMix(EnumFlowerColor.White, EnumFlowerColor.SpringGreen, EnumFlowerColor.Aquamarine, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.SteelBlue, EnumFlowerColor.LightSteelBlue, 85);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Tan, EnumFlowerColor.Wheat, 105);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Teal, EnumFlowerColor.DarkTurquoise, 80);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Thistle, EnumFlowerColor.Lavender, 105);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Turquoise, EnumFlowerColor.PaleTurquoise, 100);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Violet, EnumFlowerColor.Plum, 95);
		addMix(EnumFlowerColor.White, EnumFlowerColor.Wheat, EnumFlowerColor.LemonChiffon, 110);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleGreen, 95);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Brown, EnumFlowerColor.Goldenrod, 55);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.CadetBlue, EnumFlowerColor.YellowGreen, 80);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Chocolate, EnumFlowerColor.Goldenrod, 80);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Coral, EnumFlowerColor.Goldenrod, 75);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Crimson, EnumFlowerColor.DarkOrange, 55);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Cyan, EnumFlowerColor.PaleGreen, 85);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.Gold, 95);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkGray, EnumFlowerColor.Khaki, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkGreen, EnumFlowerColor.YellowGreen, 70);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkKhaki, EnumFlowerColor.Khaki, 105);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.YellowGreen, 80);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkOrange, EnumFlowerColor.Gold, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkSalmon, EnumFlowerColor.Gold, 80);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.YellowGreen, 95);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.DarkKhaki, 60);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.PaleGreen, 80);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.PaleGreen, 60);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DimGray, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.DodgerBlue, EnumFlowerColor.DarkSeaGreen, 45);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Gold, EnumFlowerColor.Khaki, 115);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Goldenrod, EnumFlowerColor.Gold, 100);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Gray, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Green, EnumFlowerColor.YellowGreen, 80);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.HotPink, EnumFlowerColor.SandyBrown, 50);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.IndianRed, EnumFlowerColor.Goldenrod, 65);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Khaki, EnumFlowerColor.Gold, 115);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Lavender, EnumFlowerColor.Khaki, 80);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Khaki, 105);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.LightGray, EnumFlowerColor.Khaki, 95);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.YellowGreen, 80);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.Khaki, 75);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Lime, EnumFlowerColor.SpringGreen, 105);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.LimeGreen, EnumFlowerColor.YellowGreen, 100);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Maroon, EnumFlowerColor.DarkGoldenrod, 45);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.MistyRose, EnumFlowerColor.Khaki, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Olive, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.OliveDrab, EnumFlowerColor.YellowGreen, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Orange, EnumFlowerColor.Gold, 95);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.PaleGreen, EnumFlowerColor.YellowGreen, 105);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.Khaki, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Goldenrod, 55);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Peru, EnumFlowerColor.Gold, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Pink, EnumFlowerColor.Gold, 75);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Plum, EnumFlowerColor.Khaki, 55);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Red, EnumFlowerColor.DarkOrange, 60);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.RosyBrown, EnumFlowerColor.Gold, 75);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Salmon, EnumFlowerColor.Goldenrod, 70);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.SandyBrown, EnumFlowerColor.Gold, 90);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.SeaGreen, EnumFlowerColor.YellowGreen, 85);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Sienna, EnumFlowerColor.Goldenrod, 70);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.SkyBlue, EnumFlowerColor.YellowGreen, 75);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.SlateGray, EnumFlowerColor.DarkKhaki, 70);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.SpringGreen, EnumFlowerColor.Lime, 100);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.SteelBlue, EnumFlowerColor.YellowGreen, 55);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Tan, EnumFlowerColor.Gold, 100);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Teal, EnumFlowerColor.YellowGreen, 70);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Thistle, EnumFlowerColor.Khaki, 75);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Turquoise, EnumFlowerColor.PaleGreen, 85);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.Wheat, EnumFlowerColor.Khaki, 105);
		addMix(EnumFlowerColor.Yellow, EnumFlowerColor.White, EnumFlowerColor.Khaki, 95);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Aquamarine, EnumFlowerColor.PaleGreen, 100);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Black, EnumFlowerColor.DarkOliveGreen, 55);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Brown, EnumFlowerColor.DarkGoldenrod, 55);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.CadetBlue, EnumFlowerColor.DarkSeaGreen, 90);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Chocolate, EnumFlowerColor.Goldenrod, 75);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Coral, EnumFlowerColor.Goldenrod, 75);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Crimson, EnumFlowerColor.Chocolate, 50);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Cyan, EnumFlowerColor.SpringGreen, 90);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DarkGoldenrod, EnumFlowerColor.DarkKhaki, 95);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DarkGray, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DarkGreen, EnumFlowerColor.OliveDrab, 85);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DarkOliveGreen, EnumFlowerColor.OliveDrab, 95);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DarkOrange, EnumFlowerColor.Goldenrod, 85);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DarkSalmon, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.LimeGreen, 110);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DarkSlateGray, EnumFlowerColor.OliveDrab, 70);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DarkTurquoise, EnumFlowerColor.MediumSeaGreen, 90);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DeepSkyBlue, EnumFlowerColor.MediumAquamarine, 70);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DimGray, EnumFlowerColor.OliveDrab, 85);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.DodgerBlue, EnumFlowerColor.LightSeaGreen, 55);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Gold, EnumFlowerColor.Yellow, 105);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Goldenrod, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Gray, EnumFlowerColor.OliveDrab, 90);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Green, EnumFlowerColor.OliveDrab, 100);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.HotPink, EnumFlowerColor.Tan, 45);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.IndianRed, EnumFlowerColor.DarkGoldenrod, 65);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Khaki, EnumFlowerColor.DarkKhaki, 110);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Lavender, EnumFlowerColor.DarkSeaGreen, 85);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.LemonChiffon, EnumFlowerColor.Khaki, 105);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.LightGray, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.LightSeaGreen, EnumFlowerColor.MediumSeaGreen, 95);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.LightSteelBlue, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Lime, EnumFlowerColor.LimeGreen, 110);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.LimeGreen, EnumFlowerColor.Lime, 115);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.MediumAquamarine, EnumFlowerColor.LimeGreen, 105);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.MediumPurple, EnumFlowerColor.DarkGray, 45);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.MediumSeaGreen, EnumFlowerColor.LimeGreen, 110);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.MistyRose, EnumFlowerColor.Khaki, 90);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Olive, EnumFlowerColor.OliveDrab, 105);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.OliveDrab, EnumFlowerColor.LimeGreen, 110);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Orange, EnumFlowerColor.Gold, 90);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.PaleGreen, EnumFlowerColor.LimeGreen, 110);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.PaleTurquoise, EnumFlowerColor.PaleGreen, 95);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.PaleVioletRed, EnumFlowerColor.Tan, 60);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Peru, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Pink, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Plum, EnumFlowerColor.DarkKhaki, 55);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Red, EnumFlowerColor.Chocolate, 55);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.RosyBrown, EnumFlowerColor.DarkKhaki, 80);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.RoyalBlue, EnumFlowerColor.CadetBlue, 55);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Salmon, EnumFlowerColor.Goldenrod, 70);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.SandyBrown, EnumFlowerColor.DarkKhaki, 90);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.SeaGreen, EnumFlowerColor.MediumSeaGreen, 100);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Sienna, EnumFlowerColor.Olive, 70);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.SkyBlue, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.SlateGray, EnumFlowerColor.DarkSeaGreen, 80);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.SpringGreen, EnumFlowerColor.LimeGreen, 110);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.SteelBlue, EnumFlowerColor.DarkSeaGreen, 65);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Tan, EnumFlowerColor.DarkKhaki, 100);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Teal, EnumFlowerColor.MediumSeaGreen, 85);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Thistle, EnumFlowerColor.DarkKhaki, 75);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Turquoise, EnumFlowerColor.PaleGreen, 95);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Wheat, EnumFlowerColor.Khaki, 100);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.White, EnumFlowerColor.Khaki, 95);
		addMix(EnumFlowerColor.YellowGreen, EnumFlowerColor.Yellow, EnumFlowerColor.Khaki, 110);
	}

	public static void initColours() {
		for (EnumFlowerColor color : EnumFlowerColor.values()) {
			AlleleManager.alleleRegistry.registerAllele(color.allele);
		}
	}

	public static EnumFlowerColor get(int i) {
		return values()[Math.max(0, i) % values().length];
	}

	public String getDisplayName() {
		return I18N.localise("botany.color." + func_176610_l());
	}

	@Override
	public String func_176610_l() {
		return name().toLowerCase();
	}

	public String getHTMLName() {
		return name();
	}

	public FlowerColorAllele getFlowerColorAllele() {
		return allele;
	}
}
