/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.distillery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class DistilleryRecipes {
    private static final int LEVELS = 3;
    private static final List<Map<Fluid, Pair<FluidStack, FluidStack>>> recipes = new ArrayList<Map<Fluid, Pair<FluidStack, FluidStack>>>();

    @Nullable
    public static FluidStack getOutput(@Nullable FluidStack fluid, int level) {
        Map<Fluid, Pair<FluidStack, FluidStack>> recipesForLevel;
        Pair<FluidStack, FluidStack> recipe;
        if (fluid != null && (recipe = (recipesForLevel = recipes.get(level)).get(fluid.getFluid())) != null) {
            return ((FluidStack)recipe.getValue()).copy();
        }
        return null;
    }

    public static boolean isValidInputLiquid(FluidStack fluid) {
        for (int i = 0; i < 3; ++i) {
            Map<Fluid, Pair<FluidStack, FluidStack>> recipesForLevel = recipes.get(i);
            Pair<FluidStack, FluidStack> recipe = recipesForLevel.get(fluid.getFluid());
            if (!((FluidStack)recipe.getKey()).isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidOutputLiquid(FluidStack fluid) {
        for (int i = 0; i < 3; ++i) {
            Map<Fluid, Pair<FluidStack, FluidStack>> recipesForLevel = recipes.get(i);
            for (Pair<FluidStack, FluidStack> recipe : recipesForLevel.values()) {
                if (!((FluidStack)recipe.getValue()).isFluidEqual(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addRecipe(FluidStack input, FluidStack output, int level) {
        Map<Fluid, Pair<FluidStack, FluidStack>> recipesForLevel = recipes.get(level);
        recipesForLevel.put(input.getFluid(), (Pair<FluidStack, FluidStack>)Pair.of((Object)input, (Object)output));
    }

    public static Collection<Pair<FluidStack, FluidStack>> getRecipes(int level) {
        Map<Fluid, Pair<FluidStack, FluidStack>> recipesForLevel = recipes.get(level);
        return Collections.unmodifiableCollection(recipesForLevel.values());
    }

    static {
        for (int i = 0; i < 3; ++i) {
            recipes.add(new HashMap());
        }
    }
}

