/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.block;

import binnie.core.BinnieCore;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMetadata
extends BlockContainer
implements IBlockMetadata {
    static int temporyMeta = -1;

    public BlockMetadata(Material material) {
        super(material);
    }

    public static ItemStack getBlockDropped(IBlockMetadata block, IBlockAccess world, BlockPos pos) {
        TileEntityMetadata tile = TileEntityMetadata.getTile(world, pos);
        if (tile != null && !tile.hasDroppedBlock()) {
            int meta = block.getDroppedMeta(world.func_180495_p(pos), tile.getTileMetadata());
            return TileEntityMetadata.getItemStack((Block)block, meta);
        }
        return ItemStack.field_190927_a;
    }

    public static NonNullList<ItemStack> getBlockDroppedAsList(IBlockMetadata block, IBlockAccess world, BlockPos pos) {
        ItemStack drop = BlockMetadata.getBlockDropped(block, world, pos);
        NonNullList list = NonNullList.func_191196_a();
        if (!drop.func_190926_b()) {
            list.add((Object)drop);
        }
        return list;
    }

    public static boolean breakBlock(IBlockMetadata blockMetadata, @Nullable EntityPlayer player, World world, BlockPos pos) {
        boolean hasBeenBroken;
        List drops = new ArrayList();
        Block block = (Block)blockMetadata;
        TileEntityMetadata tile = TileEntityMetadata.getTile((IBlockAccess)world, pos);
        if (tile != null && !tile.hasDroppedBlock()) {
            drops = block.getDrops((IBlockAccess)world, pos, world.func_180495_p(pos), 0);
        }
        if ((hasBeenBroken = world.func_175698_g(pos)) && BinnieCore.getBinnieProxy().isSimulating(world) && drops.size() > 0 && (player == null || !player.field_71075_bZ.field_75098_d)) {
            for (ItemStack drop : drops) {
                BlockMetadata.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            if (tile != null) {
                tile.dropBlock();
            }
        }
        return hasBeenBroken;
    }

    public static ItemStack getPickBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return BlockMetadata.getBlockDropped((IBlockMetadata)block, (IBlockAccess)world, pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return BlockMetadata.getBlockDroppedAsList(this, world, pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return BlockMetadata.breakBlock(this, player, world, pos);
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return BlockMetadata.getPickBlock(world, pos);
    }

    @Override
    public String getDisplayName(ItemStack itemStack) {
        return this.func_149732_F();
    }

    @Override
    public int getPlacedMeta(ItemStack item, World world, BlockPos pos, EnumFacing clickedBlock) {
        return TileEntityMetadata.getItemDamage(item);
    }

    @Override
    public int getDroppedMeta(IBlockState state, int tileMetadata) {
        return this.func_176201_c(state);
    }
}

