package binnie.botany.genetics;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;

import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.core.BotanyGUI;
import binnie.core.util.I18N;

public class ItemDictionary extends Item implements IItemModelRegister {
	public ItemDictionary() {
		func_77637_a(CreativeTabBotany.instance);
		func_77655_b("database");
		func_77625_d(1);
		setRegistryName("database");
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
		super.func_150895_a(itemIn, tab, subItems);
		subItems.add(new ItemStack(itemIn, 1, 1));
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, 0, "botanist_database");
		manager.registerItemModel(item, 1, "master_botanist_database");
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
		ItemStack itemStack = playerIn.func_184586_b(handIn);
		if (itemStack.func_77960_j() == 0) {
			Botany.proxy.openGui(BotanyGUI.DATABASE, playerIn, playerIn.func_180425_c());
		} else {
			Botany.proxy.openGui(BotanyGUI.DATABASE_NEI, playerIn, playerIn.func_180425_c());
		}
		return super.func_77659_a(worldIn, playerIn, handIn);
	}

	@Override
	public String func_77653_i(ItemStack i) {
		return I18N.localise("item.botany.database." + ((i.func_77952_i() == 0) ? "name" : "master.name"));
	}
}
