/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.acclimatiser;

import binnie.core.genetics.EnumTolerance;
import binnie.core.genetics.Gene;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import binnie.genetics.machine.acclimatiser.ToleranceType;
import binnie.genetics.machine.inoculator.Inoculator;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Random;
import net.minecraft.item.ItemStack;

class ToleranceSystem {
    String uid;
    IChromosomeType chromosomeOrdinal;
    ToleranceType type;

    ToleranceSystem(String uid, IChromosomeType chromosomeOrdinal, ToleranceType type) {
        this.uid = uid;
        this.chromosomeOrdinal = chromosomeOrdinal;
        this.type = type;
    }

    public boolean canAlter(ItemStack stack, ItemStack acclim) {
        IIndividual member = AlleleManager.alleleRegistry.getIndividual(stack);
        IGenome genome = member.getGenome();
        IAlleleTolerance tolAllele = (IAlleleTolerance)genome.getActiveAllele(this.chromosomeOrdinal);
        EnumTolerance tol = EnumTolerance.get(tolAllele.getValue());
        float effect = this.type.getEffect(acclim);
        return effect > 0.0f && tol.getBounds()[1] < 5 || effect < 0.0f && tol.getBounds()[0] > -5;
    }

    public ItemStack alter(ItemStack stack, ItemStack acc) {
        Random rand = new Random();
        float effect = this.type.getEffect(acc);
        if (rand.nextFloat() > Math.abs(effect)) {
            return stack;
        }
        IIndividual member = AlleleManager.alleleRegistry.getIndividual(stack);
        IGenome genome = member.getGenome();
        IAlleleTolerance tolAllele = (IAlleleTolerance)genome.getActiveAllele(this.chromosomeOrdinal);
        EnumTolerance tol = EnumTolerance.get(tolAllele.getValue());
        EnumTolerance newTol = Acclimatiser.alterTolerance(tol, effect);
        if (rand.nextFloat() > 1.0f / (float)(-newTol.getBounds()[0] + newTol.getBounds()[1])) {
            return stack;
        }
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
        Inoculator.setGene(new Gene(newTol.getAllele(), this.chromosomeOrdinal, root), stack, rand.nextInt(2));
        return stack;
    }
}

