/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst.flower;

import binnie.botany.Botany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.IFlower;
import binnie.botany.gardening.BlockSoil;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.util.I18N;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import binnie.genetics.gui.analyst.ControlToleranceBar;
import forestry.api.genetics.EnumTolerance;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class AnalystPageSoil
extends ControlAnalystPage {
    public AnalystPageSoil(IWidget parent, Area area, IFlower flower) {
        super(parent, area);
        this.setColor(0x663300);
        EnumMoisture moisture = flower.getGenome().getPrimary().getMoisture();
        EnumTolerance moistureTol = flower.getGenome().getToleranceMoisture();
        EnumAcidity pH = flower.getGenome().getPrimary().getPH();
        EnumTolerance pHTol = flower.getGenome().getTolerancePH();
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlText(this, new Area(4, y += 16, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.soil.tolerance.moisture"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        this.createMoisture(this, (this.getWidth() - 100) / 2, y += 12, 100, 10, moisture, moistureTol);
        new ControlText(this, new Area(4, y += 16, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.soil.tolerance.ph"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        this.createAcidity(this, (this.getWidth() - 100) / 2, y += 12, 100, 10, pH, pHTol);
        new ControlText(this, new Area(4, y += 16, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.soil.recommended"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        y += 12;
        EnumMoisture recomMoisture = EnumMoisture.NORMAL;
        boolean canTolNormal = binnie.core.genetics.EnumTolerance.canTolerate(moisture, EnumMoisture.NORMAL, moistureTol);
        boolean canTolDamp = binnie.core.genetics.EnumTolerance.canTolerate(moisture, EnumMoisture.DAMP, moistureTol);
        boolean canTolDry = binnie.core.genetics.EnumTolerance.canTolerate(moisture, EnumMoisture.DRY, moistureTol);
        if (canTolNormal) {
            if (canTolDamp && !canTolDry) {
                recomMoisture = EnumMoisture.DAMP;
            } else if (canTolDry && !canTolDamp) {
                recomMoisture = EnumMoisture.DRY;
            }
        } else {
            if (canTolDamp) {
                recomMoisture = EnumMoisture.DAMP;
            }
            if (canTolDry) {
                recomMoisture = EnumMoisture.DRY;
            }
        }
        EnumAcidity recomPH = EnumAcidity.NEUTRAL;
        boolean canTolNeutral = binnie.core.genetics.EnumTolerance.canTolerate(pH, EnumAcidity.NEUTRAL, pHTol);
        boolean canTolAcid = binnie.core.genetics.EnumTolerance.canTolerate(pH, EnumAcidity.ACID, pHTol);
        boolean canTolAlkaline = binnie.core.genetics.EnumTolerance.canTolerate(pH, EnumAcidity.ALKALINE, pHTol);
        if (canTolNeutral) {
            if (canTolAcid && !canTolAlkaline) {
                recomPH = EnumAcidity.ACID;
            } else if (canTolAlkaline && !canTolAcid) {
                recomPH = EnumAcidity.ALKALINE;
            }
        } else {
            if (canTolAcid) {
                recomPH = EnumAcidity.ACID;
            }
            if (canTolAlkaline) {
                recomPH = EnumAcidity.ALKALINE;
            }
        }
        ItemStack stack = new ItemStack((Block)Botany.gardening().soil, 1, BlockSoil.getMeta(recomPH, recomMoisture));
        ControlItemDisplay recomSoil = new ControlItemDisplay(this, (this.getWidth() - 24) / 2, y, 24);
        recomSoil.setItemStack(stack);
        recomSoil.setTooltip();
        new ControlText(this, new Area(4, y += 32, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.soil.other"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        y += 12;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EnumAcidity a : EnumSet.range(EnumAcidity.ACID, EnumAcidity.ALKALINE)) {
            for (EnumMoisture b : EnumSet.range(EnumMoisture.DRY, EnumMoisture.DAMP)) {
                if (!binnie.core.genetics.EnumTolerance.canTolerate(pH, a, pHTol) || !binnie.core.genetics.EnumTolerance.canTolerate(moisture, b, moistureTol) || a == recomPH && b == recomMoisture) continue;
                stacks.add(new ItemStack((Block)Botany.gardening().soil, 1, BlockSoil.getMeta(a, b)));
            }
        }
        int soilListWidth = 17 * stacks.size() - 1;
        int soilListX = (this.getWidth() - soilListWidth) / 2;
        int t = 0;
        for (ItemStack soilStack : stacks) {
            ControlItemDisplay display = new ControlItemDisplay(this, soilListX + 17 * t++, y);
            display.setItemStack(soilStack);
            display.setTooltip();
        }
    }

    protected void createMoisture(IWidget parent, int x, int y, int w, int h, EnumMoisture value, EnumTolerance tol) {
        new ControlToleranceBar<EnumMoisture>(parent, x, y, w, h, EnumMoisture.class){

            @Override
            protected String getName(EnumMoisture value) {
                return value.getLocalisedName(false);
            }

            @Override
            protected int getColour(EnumMoisture value) {
                return (new int[]{0xCCFFCC, 0x66CCFF, 0x3366FF})[value.ordinal()];
            }
        }.setValues(value, tol);
    }

    protected void createAcidity(IWidget parent, int x, int y, int w, int h, EnumAcidity value, EnumTolerance tol) {
        new ControlToleranceBar<EnumAcidity>(parent, x, y, w, h, EnumAcidity.class){

            @Override
            protected String getName(EnumAcidity value) {
                return value.getLocalisedName(false);
            }

            @Override
            protected int getColour(EnumAcidity value) {
                return (new int[]{0xFF0066, 65280, 26367})[value.ordinal()];
            }
        }.setValues(value, tol);
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.soil.title");
    }
}

