/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network.packet;

import binnie.core.network.packet.IPacketLocation;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageNBT;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MessageTileNBT
extends MessageNBT
implements IPacketLocation {
    private int posX;
    private int posY;
    private int posZ;

    public MessageTileNBT(MessageBinnie message) {
        super(message);
    }

    public MessageTileNBT(int id, TileEntity tile, NBTTagCompound nbt) {
        super(id);
        this.posX = tile.func_174877_v().func_177958_n();
        this.posY = tile.func_174877_v().func_177956_o();
        this.posZ = tile.func_174877_v().func_177952_p();
        this.nbt = nbt;
    }

    @Override
    public void writeData(ByteBuf data) throws IOException {
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
        super.writeData(data);
    }

    @Override
    public void readData(ByteBuf data) throws IOException {
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
        super.readData(data);
    }

    @Override
    @Nullable
    public TileEntity getTarget(World world) {
        return world.func_175625_s(new BlockPos(this.posX, this.posY, this.posZ));
    }

    @Override
    public int getX() {
        return this.posX;
    }

    @Override
    public int getY() {
        return this.posY;
    }

    @Override
    public int getZ() {
        return this.posZ;
    }

    @Override
    public NBTTagCompound getTagCompound() {
        return this.nbt;
    }

    @Override
    void setTagCompound(NBTTagCompound nbt) {
        this.nbt = nbt;
    }
}

