/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.EnumTolerance;
import binnie.core.genetics.ForestryAllele;
import binnie.core.genetics.VirtualBeeHousing;
import binnie.core.util.I18N;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

class BeeBreedingSystem
extends BreedingSystem {
    public BeeBreedingSystem() {
        this.iconUndiscovered = Binnie.RESOURCE.getUndiscoveredBeeSprite();
        this.iconDiscovered = Binnie.RESOURCE.getDiscoveredBeeSprite();
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAlleleSpecies firstSpecies, IAlleleSpecies secondSpecies) {
        return ((IBeeMutation)mutation).getChance((IBeeHousing)new VirtualBeeHousing(player), (IAlleleBeeSpecies)firstSpecies, (IAlleleBeeSpecies)secondSpecies, (IBeeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(firstSpecies)), (IBeeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(secondSpecies)));
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return Binnie.GENETICS.getBeeRoot();
    }

    @Override
    public int getColour() {
        return 16767232;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return IApiaristTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumBeeChromosome.FERTILITY) {
            if (allele.getUID().contains("Low")) {
                return I18N.localise("binniecore.allele.fertility.low");
            }
            if (allele.getUID().contains("Normal")) {
                return I18N.localise("binniecore.allele.fertility.normal");
            }
            if (allele.getUID().contains("High")) {
                return I18N.localise("binniecore.allele.fertility.high");
            }
            if (allele.getUID().contains("Maximum")) {
                return I18N.localise("binniecore.allele.fertility.maximum");
            }
        }
        return super.getAlleleName(chromosome, allele);
    }

    @Override
    public boolean isDNAManipulable(ItemStack member) {
        ISpeciesType type = this.getSpeciesRoot().getType(member);
        return this.isDNAManipulable(type);
    }

    @Override
    public boolean isDNAManipulable(@Nullable ISpeciesType type) {
        return type == EnumBeeType.LARVAE;
    }

    @Override
    public ISpeciesType[] getActiveTypes() {
        return new ISpeciesType[]{EnumBeeType.DRONE, EnumBeeType.PRINCESS, EnumBeeType.QUEEN, EnumBeeType.LARVAE};
    }

    @Override
    public void addExtraAlleles(IChromosomeType chromosome, TreeSet<IAllele> alleles) {
        switch ((EnumBeeChromosome)chromosome) {
            case FERTILITY: {
                for (ForestryAllele.Fertility a : ForestryAllele.Fertility.values()) {
                    alleles.add(a.getAllele());
                }
                break;
            }
            case FLOWERING: {
                for (ForestryAllele.Flowering a2 : ForestryAllele.Flowering.values()) {
                    alleles.add(a2.getAllele());
                }
                break;
            }
            case HUMIDITY_TOLERANCE: 
            case TEMPERATURE_TOLERANCE: {
                for (EnumTolerance a3 : EnumTolerance.values()) {
                    alleles.add(a3.getAllele());
                }
                break;
            }
            case LIFESPAN: {
                for (ForestryAllele.Lifespan a4 : ForestryAllele.Lifespan.values()) {
                    alleles.add(a4.getAllele());
                }
                break;
            }
            case SPEED: {
                for (ForestryAllele.Speed a5 : ForestryAllele.Speed.values()) {
                    alleles.add(a5.getAllele());
                }
                break;
            }
            case TERRITORY: {
                for (ForestryAllele.Territory a6 : ForestryAllele.Territory.values()) {
                    alleles.add(a6.getAllele());
                }
                break;
            }
            case NEVER_SLEEPS: 
            case CAVE_DWELLING: 
            case TOLERATES_RAIN: {
                for (ForestryAllele.Bool a7 : ForestryAllele.Bool.values()) {
                    alleles.add(a7.getAllele());
                }
                break;
            }
        }
    }
}

