package binnie.extratrees.machines.lumbermill;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

import net.minecraftforge.oredict.OreDictionary;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;

import binnie.core.util.FakeCraftingWorld;
import binnie.core.util.OreDictionaryUtil;

public class LumbermillRecipes {
	//Map<input log item, Pair<input log, output planks>>
	private static Multimap<Item, Pair<ItemStack, ItemStack>> recipes = ArrayListMultimap.create();

	public static ItemStack getPlankProduct(final ItemStack logStack) {
		if (recipes.isEmpty()) {
			calculateLumbermillProducts();
		}

		Item logItem = logStack.func_77973_b();
		for (final Pair<ItemStack, ItemStack> entry : recipes.get(logItem)) {
			if (entry.getKey().func_77969_a(logStack)) {
				return entry.getValue().func_77946_l();
			}
		}
		return ItemStack.field_190927_a;
	}

	public static Collection<Pair<ItemStack, ItemStack>> getRecipes() {
		if (recipes.isEmpty()) {
			calculateLumbermillProducts();
		}

		return recipes.values();
	}

	private static void calculateLumbermillProducts() {
		int plankOreId = OreDictionary.getOreID("plankWood");

		CraftingManager craftingManager = CraftingManager.func_77594_a();
		InventoryCrafting fakeCraftingInventory = new InventoryCrafting(new FakeCraftingHandler(), 3, 3);

		List<IWoodType> registeredWoodTypes = TreeManager.woodAccess.getRegisteredWoodTypes();
		for (IWoodType woodType : registeredWoodTypes) {
			for(boolean fireproof : new boolean[]{true, false}) {
				ItemStack logStack = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.LOG, fireproof);
				ItemStack logCopy = logStack.func_77946_l();
				logCopy.func_190920_e(1);

				fakeCraftingInventory.func_174888_l();
				fakeCraftingInventory.func_70299_a(0, logCopy);

				try {
					ItemStack recipeOutput = craftingManager.func_82787_a(fakeCraftingInventory, FakeCraftingWorld.getInstance());
					if (!recipeOutput.func_190926_b()) {
						if (OreDictionaryUtil.hasOreId(recipeOutput, plankOreId)) {
							Item logItem = logCopy.func_77973_b();
							ItemStack outputCopy = recipeOutput.func_77946_l();
							outputCopy.func_190920_e((int) Math.ceil(outputCopy.func_190916_E() * 1.5f)); // turns stack of 4 up to 6
							recipes.put(logItem, Pair.of(logCopy, outputCopy));
						}
					}
				} catch (RuntimeException ignored) {

				}
			}
		}
	}

	private static class FakeCraftingHandler extends Container {
		@Override
		public void func_75130_a(IInventory inventoryIn) {

		}

		@Override
		public boolean func_75145_c(EntityPlayer playerIn) {
			return true;
		}
	}
}
