package binnie.extratrees.machines.designer;

import javax.annotation.Nullable;
import java.util.Map;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

import binnie.core.machines.Machine;
import binnie.core.machines.component.ComponentRecipe;
import binnie.core.machines.component.IComponentRecipe;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateSource;
import binnie.core.machines.network.INetwork;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.machines.ExtraTreesErrorCode;

public class ComponentDesignerRecipe extends ComponentRecipe implements IComponentRecipe, INetwork.GuiNBT, IErrorStateSource {
	public DesignerType type;
	private IDesign design;

	public ComponentDesignerRecipe(final Machine machine, final DesignerType type) {
		super(machine);
		this.design = EnumDesign.Diamond;
		this.type = type;
	}

	@Override
	public void readFromNBT(final NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);
		this.setDesign(CarpentryManager.carpentryInterface.getDesign(nbttagcompound.func_74762_e("design")));
	}

	@Override
	public NBTTagCompound writeToNBT(final NBTTagCompound nbttagcompound1) {
		NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound1);
		nbttagcompound.func_74768_a("design", CarpentryManager.carpentryInterface.getDesignIndex(this.design));
		return nbttagcompound;
	}

	@Override
	public boolean isRecipe() {
		return !this.getProduct().func_190926_b();
	}

	@Override
	public ItemStack getProduct() {
		final ItemStack plank1 = this.getUtil().getStack(Designer.DESIGN_SLOT_1);
		final ItemStack plank2 = this.getUtil().getStack(Designer.DESIGN_SLOT_2);
		if (plank1.func_190926_b() || plank2.func_190926_b()) {
			return ItemStack.field_190927_a;
		}
		final IDesignMaterial type1 = this.type.getSystem().getMaterial(plank1);
		final IDesignMaterial type2 = this.type.getSystem().getMaterial(plank2);
		final IDesign design = this.getDesign();
		return this.type.getBlock(type1, type2, design);
	}

	@Override
	public ItemStack doRecipe(final boolean takeItem) {
		if (!this.isRecipe()) {
			return ItemStack.field_190927_a;
		}
		if (this.canWork() != null) {
			return ItemStack.field_190927_a;
		}
		final ItemStack product = this.getProduct();
		if (takeItem) {
			final ItemStack a = this.getUtil().decreaseStack(Designer.DESIGN_SLOT_1, 1);
			if (a.func_190926_b()) {
				this.getUtil().decreaseStack(Designer.DESIGN_SLOT_2, 1);
			} else if (this.design != EnumDesign.Blank) {
				this.getUtil().decreaseStack(Designer.DESIGN_SLOT_2, 1);
			}
			this.getUtil().decreaseStack(Designer.BEESWAX_SLOT, 1);
		}
		return product;
	}

	public IDesign getDesign() {
		return this.design;
	}

	private void setDesign(final IDesign design) {
		this.design = design;
	}

	@Override
	@Nullable
	public ErrorState canWork() {
		if (this.getUtil().isSlotEmpty(Designer.BEESWAX_SLOT)) {
			return new ErrorState(ExtraTreesErrorCode.DESIGNER_NO_ADHESIVE, Designer.BEESWAX_SLOT);
		}
		return null;
	}

	@Override
	@Nullable
	public ErrorState canProgress() {
		return null;
	}

	@Override
	public void sendGuiNBTToClient(final Map<String, NBTTagCompound> nbt) {
		final NBTTagCompound tag = new NBTTagCompound();
		tag.func_74777_a("d", (short) CarpentryManager.carpentryInterface.getDesignIndex(this.getDesign()));
		nbt.put("design", tag);
	}

	@Override
	public void receiveGuiNBTOnClient(EntityPlayer player, String name, NBTTagCompound nbt) {
		if (name.equals("design")) {
			this.setDesign(CarpentryManager.carpentryInterface.getDesign(nbt.func_74765_d("d")));
		}
	}

	@Override
	public void receiveGuiNBTOnServer(final EntityPlayer player, final String name, final NBTTagCompound nbt) {
		if (name.equals("recipe")) {
			final InventoryPlayer playerInv = player.field_71071_by;
			final ItemStack recipe = this.doRecipe(false);
			if (!recipe.func_190926_b()) {
				if (playerInv.func_70445_o().func_190926_b()) {
					playerInv.func_70437_b(this.doRecipe(true));
				} else if (playerInv.func_70445_o().func_77969_a(recipe) && ItemStack.func_77970_a(playerInv.func_70445_o(), recipe)) {
					final int fit = recipe.func_77976_d() - (recipe.func_190916_E() + playerInv.func_70445_o().func_190916_E());
					if (fit >= 0) {
						this.doRecipe(true);
						recipe.func_190917_f(playerInv.func_70445_o().func_190916_E());
						playerInv.func_70437_b(recipe);
					}
				}
				player.field_71070_bA.func_75142_b();
				if (player instanceof EntityPlayerMP) {
					((EntityPlayerMP) player).func_71113_k();
				}
			}
		} else if (name.equals("design")) {
			setDesign(CarpentryManager.carpentryInterface.getDesign(nbt.func_74762_e("d")));
		}
	}

	public DesignerType getDesignerType() {
		return this.type;
	}
}
