/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.database.bee;

import binnie.Binnie;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlClimateBar
extends Control
implements ITooltip {
    private final int[] TEMP_COLORS = new int[]{65531, 7912447, 5242672, 0xFFFF00, 16753152, 0xFF0000};
    private final int[] HUMID_COLORS = new int[]{16770979, 1769216, 3177727};
    boolean isHumidity = false;
    List<Integer> tolerated = new ArrayList<Integer>();

    public ControlClimateBar(IWidget parent, int x, int y, int width, int height) {
        this(parent, x, y, width, height, false);
    }

    public ControlClimateBar(IWidget parent, int x, int y, int width, int height, boolean humidity) {
        super(parent, x, y, width, height);
        this.addAttribute(Attribute.MouseOver);
        this.isHumidity = humidity;
    }

    @Override
    public void getTooltip(Tooltip list) {
        if (this.tolerated.isEmpty()) {
            return;
        }
        int types = this.isHumidity ? 3 : 6;
        int type = (int)((float)((int)((float)this.getRelativeMousePosition().x() - 1.0f)) / (((float)this.getSize().x() - 2.0f) / (float)types));
        if (!this.tolerated.contains(type) || type >= types) {
            return;
        }
        if (this.isHumidity) {
            list.add(EnumHumidity.values()[type].name);
        } else {
            list.add(EnumTemperature.values()[type + 1].name);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUI.RENDER.texture((Object)CraftGUITexture.EnergyBarBack, this.getArea());
        int types = this.isHumidity ? 3 : 6;
        int w = (int)(((float)this.getSize().x() - 2.0f) / (float)types);
        for (int i = 0; i < types; ++i) {
            int x = i * w;
            if (!this.tolerated.contains(i)) continue;
            int color = this.isHumidity ? this.HUMID_COLORS[i] : this.TEMP_COLORS[i];
            RenderUtil.drawSolidRect(new Area(x + 1, 1, w, this.getSize().y() - 2), color);
        }
        CraftGUI.RENDER.texture((Object)CraftGUITexture.EnergyBarGlass, this.getArea());
    }

    public void setSpecies(IAlleleBeeSpecies species) {
        EnumTolerance tolerance;
        int main;
        this.tolerated.clear();
        IAllele[] template = Binnie.GENETICS.getBeeRoot().getTemplate((IAlleleSpecies)species);
        IBeeGenome genome = Binnie.GENETICS.getBeeRoot().templateAsGenome(template);
        if (!this.isHumidity) {
            main = species.getTemperature().ordinal() - 1;
            tolerance = genome.getToleranceTemp();
        } else {
            main = species.getHumidity().ordinal();
            tolerance = genome.getToleranceHumid();
        }
        this.tolerated.add(main);
        switch (tolerance) {
            case BOTH_5: 
            case UP_5: {
                this.tolerated.add(main + 5);
            }
            case BOTH_4: 
            case UP_4: {
                this.tolerated.add(main + 4);
            }
            case BOTH_3: 
            case UP_3: {
                this.tolerated.add(main + 3);
            }
            case BOTH_2: 
            case UP_2: {
                this.tolerated.add(main + 2);
            }
            case BOTH_1: 
            case UP_1: {
                this.tolerated.add(main + 1);
            }
        }
        switch (tolerance) {
            case BOTH_5: 
            case DOWN_5: {
                this.tolerated.add(main - 5);
            }
            case BOTH_4: 
            case DOWN_4: {
                this.tolerated.add(main - 4);
            }
            case BOTH_3: 
            case DOWN_3: {
                this.tolerated.add(main - 3);
            }
            case BOTH_2: 
            case DOWN_2: {
                this.tolerated.add(main - 2);
            }
            case BOTH_1: 
            case DOWN_1: {
                this.tolerated.add(main - 1);
            }
        }
    }
}

