/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.util.I18N;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import java.util.Objects;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageDescription
extends ControlAnalystPage {
    public AnalystPageDescription(IWidget parent, Area area, IIndividual ind) {
        super(parent, area);
        this.setColor(0x333333);
        int y = 4;
        IAlleleSpecies species = ind.getGenome().getPrimary();
        String branchBinomial = species.getBranch().getScientific();
        String branchName = species.getBranch().getName();
        String desc = species.getDescription();
        StringBuilder descBody = new StringBuilder(TextFormatting.ITALIC.toString());
        String descSig = "";
        if (Objects.equals(desc, "") || desc.contains("for.description") || desc.contains(".desc")) {
            descBody.append("");
        } else {
            String[] descStrings = desc.split("\\|");
            descBody.append(descStrings[0]);
            for (int i = 1; i < descStrings.length - 1; ++i) {
                descBody.append(" ").append(descStrings[i]);
            }
            if (descStrings.length > 1) {
                descSig = descSig + descStrings[descStrings.length - 1];
            }
        }
        String authority = species.getAuthority();
        if (authority.contains("Binnie")) {
            authority = TextFormatting.DARK_BLUE.toString() + TextFormatting.BOLD + authority;
        }
        if (authority.contains("Sengir")) {
            authority = TextFormatting.DARK_GREEN.toString() + TextFormatting.BOLD + authority;
        }
        if (authority.contains("MysteriousAges")) {
            authority = TextFormatting.DARK_PURPLE.toString() + TextFormatting.BOLD + authority;
        }
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 16, species.getAlleleName() + TextFormatting.RESET).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 10, TextFormatting.ITALIC + branchBinomial + " " + species.getBinomial() + TextFormatting.RESET).setColor(this.getColor());
        String discovered = I18N.localise("genetics.gui.analyst.description.discovered") + " " + TextFormatting.BOLD + authority + TextFormatting.RESET;
        new ControlTextCentered((IWidget)this, y += 20, discovered).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += (int)(3.0f + (float)CraftGUI.RENDER.textHeight(discovered, this.width())), I18N.localise("genetics.gui.analyst.description.complexity") + ": " + species.getComplexity()).setColor(this.getColor());
        ControlText descText = new ControlText(this, new Area(8, y += 26, this.width() - 16, 0), descBody + "\u00a7r", TextJustification.TOP_CENTER);
        ControlText signatureText = new ControlText(this, new Area(8, y, this.width() - 16, 0), descSig + "\u00a7r", TextJustification.BOTTOM_RIGHT);
        descText.setColor(this.getColor());
        signatureText.setColor(this.getColor());
        int descHeight = CraftGUI.RENDER.textHeight(descText.getValue(), descText.getSize().x());
        signatureText.setPosition(new Point(this.getPosition().x(), descText.getPosition().y() + descHeight + 10));
        this.setSize(new Point(this.width(), 20 + signatureText.getYPos()));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.description.title");
    }
}

