/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gui.machines;

import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.ContainerCraftGUI;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlProgressBase;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.StandardTexture;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.machines.fruitpress.FruitPressRecipes;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlFruitPressProgress
extends ControlProgressBase {
    private static final Texture PressTexture = new StandardTexture(6, 0, 24, 52, ExtraTreeTexture.Gui);
    private static final Texture PressSlot = new StandardTexture(9, 52, 34, 17, ExtraTreeTexture.Gui);

    protected ControlFruitPressProgress(IWidget parent, int x, int y) {
        super(parent, x, y, 37, 69);
        this.addAttribute(Attribute.MouseOver);
        this.addSelfEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (event.getY() - event.getOrigin().getAbsolutePosition().y() > 52 + Math.round(16.0f * ControlFruitPressProgress.this.progress)) {
                    NBTTagCompound action = new NBTTagCompound();
                    ((Window)Window.get(ControlFruitPressProgress.this.getWidget())).sendClientAction("clear-fruit", action);
                } else {
                    NBTTagCompound action = new NBTTagCompound();
                    ((Window)Window.get(ControlFruitPressProgress.this.getWidget())).sendClientAction("fruitpress-click", action);
                }
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUI.RENDER.texture(PressSlot, new Point(3, 52));
        ContainerCraftGUI container = ((Window)Window.get(this)).getContainer();
        IInventory inventory = ((Window)Window.get(this)).getInventory();
        Slot slotFromInventory = container.func_75147_a(inventory, 1);
        if (slotFromInventory == null) {
            return;
        }
        ItemStack input = slotFromInventory.func_75211_c();
        if (input.func_190926_b() || FruitPressRecipes.getOutput(input) == null) {
            return;
        }
        FluidStack fluid = FruitPressRecipes.getOutput(input);
        RenderUtil.drawFluid(new Point(4, 52), fluid);
        RenderUtil.drawItem(new Point(4, 52), input);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        GlStateManager.func_179147_l();
        CraftGUI.RENDER.texture(PressTexture, new Point(0, Math.round(16.0f * this.progress)));
    }
}

