/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.ITooltipHelp;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.TopLevelWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.events.EventWidget;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.ContainerCraftGUI;
import binnie.core.gui.minecraft.GuiCraftGUI;
import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.gui.minecraft.MinecraftTooltip;
import binnie.core.gui.minecraft.WindowInventory;
import binnie.core.gui.minecraft.control.ControlHelp;
import binnie.core.gui.minecraft.control.ControlInfo;
import binnie.core.gui.minecraft.control.ControlPowerSystem;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.minecraft.control.ControlUser;
import binnie.core.gui.minecraft.control.EnumHighlighting;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.StyleSheetManager;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import binnie.core.gui.resource.minecraft.StandardTexture;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.PowerSystem;
import binnie.core.network.packet.MessageCraftGUI;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.IBinnieTexture;
import binnie.core.resource.ResourceType;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Window
extends TopLevelWidget
implements INetwork.ReceiveGuiNBT {
    private final Side side;
    protected int titleButtonLeft = 8;
    protected int titleButtonRight = 8;
    @Nullable
    private GuiCraftGUI gui;
    private ContainerCraftGUI container;
    private WindowInventory windowInventory;
    @Nullable
    private ControlText title;
    @Nullable
    private StandardTexture bgText1 = null;
    @Nullable
    private StandardTexture bgText2 = null;
    private boolean hasBeenInitialised = false;
    private EntityPlayer player;
    @Nullable
    private IInventory entityInventory;

    public Window(int width, int height, EntityPlayer player, @Nullable IInventory inventory, Side side) {
        this.side = side;
        this.player = player;
        this.entityInventory = inventory;
        this.container = new ContainerCraftGUI(this);
        this.windowInventory = new WindowInventory(this);
        if (side == Side.CLIENT) {
            String showInfoButton;
            this.setSize(new Point(width, height));
            this.gui = new GuiCraftGUI(this);
            for (EnumHighlighting h : EnumHighlighting.values()) {
                ControlSlot.highlighting.put(h, new ArrayList());
            }
            CraftGUI.RENDER.setStyleSheet(StyleSheetManager.getDefault());
            this.titleButtonLeft = -14;
            if (this.showHelpButton()) {
                ControlHelp controlHelp = new ControlHelp(this, this.titleButtonLeft += 22, 8);
            }
            if ((showInfoButton = this.showInfoButton()) != null) {
                ControlInfo controlInfo = new ControlInfo(this, this.titleButtonLeft += 22, 8, showInfoButton);
            }
            this.addSelfEventHandler(new EventWidget.ChangeSize.Handler(){

                @Override
                public void onEvent(EventWidget.ChangeSize event) {
                    if (Window.this.isClient()) {
                        Window.this.getGui().resize(Window.this.getSize());
                        if (Window.this.title != null) {
                            Window.this.title.setSize(new Point(Window.this.width(), Window.this.title.height()));
                        }
                    }
                }
            });
        }
    }

    public static <T extends Window> T get(IWidget widget) {
        return (T)((Window)widget.getTopParent());
    }

    public void getTooltip(Tooltip tooltip) {
        Deque<IWidget> queue = this.calculateMousedOverWidgets();
        while (!queue.isEmpty()) {
            IWidget widget = queue.removeFirst();
            if (!widget.isEnabled() || !widget.isVisible() || !widget.calculateIsMouseOver()) continue;
            if (widget instanceof ITooltip) {
                ((ITooltip)((Object)widget)).getTooltip(tooltip);
                if (tooltip.exists()) {
                    return;
                }
            }
            if (!widget.hasAttribute(Attribute.BlockTooltip)) continue;
            return;
        }
    }

    public void getHelpTooltip(MinecraftTooltip tooltip) {
        Deque<IWidget> queue = this.calculateMousedOverWidgets();
        while (!queue.isEmpty()) {
            IWidget widget = queue.removeFirst();
            if (!widget.isEnabled() || !widget.isVisible() || !widget.calculateIsMouseOver()) continue;
            if (widget instanceof ITooltipHelp) {
                ((ITooltipHelp)((Object)widget)).getHelpTooltip(tooltip);
                if (tooltip.exists()) {
                    return;
                }
            }
            if (!widget.hasAttribute(Attribute.BlockTooltip)) continue;
            return;
        }
    }

    protected abstract AbstractMod getMod();

    protected abstract String getBackgroundTextureName();

    public IBinnieTexture getBackgroundTextureFile(final int i) {
        return new IBinnieTexture(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public BinnieResource getTexture() {
                return Binnie.RESOURCE.getPNG(Window.this.getMod(), ResourceType.GUI, Window.this.getBackgroundTextureName() + (i == 1 ? "" : Integer.valueOf(i)));
            }
        };
    }

    public boolean showHelpButton() {
        return Machine.getInterface(IInventoryMachine.class, this.getInventory()) != null;
    }

    @Nullable
    public String showInfoButton() {
        IMachineInformation machineInformation = Machine.getInterface(IMachineInformation.class, this.getInventory());
        if (machineInformation != null) {
            return machineInformation.getInformation();
        }
        return null;
    }

    public void setTitle(String title) {
        this.title = new ControlTextCentered((IWidget)this, 12, title);
        this.title.setColor(0x404040);
    }

    @SideOnly(value=Side.CLIENT)
    public final GuiCraftGUI getGui() {
        Preconditions.checkState((this.gui != null ? 1 : 0) != 0, (Object)"tried to get gui on server-side, should not be possible");
        return this.gui;
    }

    public final ContainerCraftGUI getContainer() {
        return this.container;
    }

    public final WindowInventory getWindowInventory() {
        return this.windowInventory;
    }

    @SideOnly(value=Side.CLIENT)
    public final void initGui() {
        if (this.hasBeenInitialised) {
            return;
        }
        this.bgText1 = new StandardTexture(0, 0, 256, 256, this.getBackgroundTextureFile(1));
        if (this.getSize().x() > 256) {
            this.bgText2 = new StandardTexture(0, 0, 256, 256, this.getBackgroundTextureFile(2));
        }
        if (!BinnieCore.getBinnieProxy().checkTexture(this.bgText1.getTexture())) {
            this.bgText1 = null;
            this.bgText2 = null;
        }
        this.initialiseClient();
        this.hasBeenInitialised = true;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void initialiseClient();

    public void initialiseServer() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        RenderUtil.setColour(0xFFFFFF);
        if (this.getBackground1() != null) {
            CraftGUI.RENDER.texture(this.getBackground1(), Point.ZERO);
        }
        if (this.getBackground2() != null) {
            CraftGUI.RENDER.texture(this.getBackground2(), new Point(256, 0));
        }
        RenderUtil.setColour(this.getColor());
        CraftGUI.RENDER.texture((Object)CraftGUITexture.Window, this.getArea());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
        super.onUpdateClient();
        ControlSlot.highlighting.get((Object)EnumHighlighting.Help).clear();
        ControlSlot.shiftClickActive = false;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public GameProfile getUsername() {
        return this.getPlayer().func_146103_bH();
    }

    public ItemStack getHeldItemStack() {
        return this.player.field_71071_by.func_70445_o();
    }

    public void setHeldItemStack(ItemStack stack) {
        this.player.field_71071_by.func_70437_b(stack);
    }

    @Nullable
    public IInventory getInventory() {
        return this.entityInventory;
    }

    public void onClose() {
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public boolean isClient() {
        return this.side == Side.CLIENT;
    }

    public World getWorld() {
        return this.getPlayer().field_70170_p;
    }

    public void onInventoryUpdate() {
    }

    public void sendClientAction(String name, NBTTagCompound action) {
        action.func_74778_a("type", name);
        MessageCraftGUI packet = new MessageCraftGUI(action);
        BinnieCore.getBinnieProxy().sendToServer(packet);
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
    }

    @Override
    public void receiveGuiNBTOnClient(EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("username")) {
            int titleButtonRight;
            int w = this.width();
            this.titleButtonRight = titleButtonRight = this.titleButtonRight + 16;
            ControlUser controlUser = new ControlUser(this, w - titleButtonRight, 8, nbt.func_74779_i("username"));
            this.titleButtonRight += 6;
        }
        if (name.equals("power-system")) {
            int titleButtonRight2;
            int w2 = this.width();
            this.titleButtonRight = titleButtonRight2 = this.titleButtonRight + 16;
            ControlPowerSystem controlPowerSystem = new ControlPowerSystem(this, w2 - titleButtonRight2, 8, PowerSystem.get(nbt.func_74771_c("system")));
            this.titleButtonRight += 6;
        }
    }

    public void onWindowInventoryChanged() {
    }

    @Nullable
    public Texture getBackground1() {
        return this.bgText1;
    }

    @Nullable
    public Texture getBackground2() {
        return this.bgText2;
    }
}

