/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.geometry;

import binnie.core.gui.geometry.Border;
import binnie.core.gui.geometry.Point;

public final class Area {
    private Point pos;
    private Point size;

    public Area(Area area) {
        this(area.pos().x(), area.pos().y(), area.size().x(), area.size().y());
    }

    public Area(Point pos, Point size) {
        this(pos.x(), pos.y(), size.x(), size.y());
    }

    public Area(int xywh) {
        this(xywh, xywh, xywh, xywh);
    }

    public Area(int xy, int wh) {
        this(xy, xy, wh, wh);
    }

    public Area(int x, int y, int wh) {
        this(x, y, wh, wh);
    }

    public Area(int x, int y, int w, int h) {
        this.pos = new Point(x, y);
        this.size = new Point(w, h);
    }

    public Point pos() {
        return this.pos;
    }

    public Point getPosition() {
        return this.pos;
    }

    public void setPosition(Point position) {
        this.pos = position.copy();
    }

    public Point size() {
        return this.size;
    }

    public Point getSize() {
        return this.size;
    }

    public void setSize(Point size) {
        this.size = size.copy();
    }

    public boolean contains(Point position) {
        return position.x() >= this.pos().x() && position.y() >= this.pos.y() && position.x() <= this.pos().x() + this.size().x() && position.y() <= this.pos().y() + this.size().y();
    }

    public int xPos() {
        return this.pos().x();
    }

    public int yPos() {
        return this.pos().y();
    }

    public int width() {
        return this.size().x();
    }

    public int height() {
        return this.size().y();
    }

    public void setXPos(int xPos) {
        this.pos = new Point(xPos, this.pos.y());
    }

    public void setYPos(int yPos) {
        this.pos = new Point(this.pos.x(), yPos);
    }

    public void setWidth(int width) {
        this.size = new Point(width, this.size.y());
    }

    public void setHeight(int height) {
        this.size = new Point(this.size.x(), height);
    }

    public Area inset(Border border) {
        return new Area(this.xPos() + border.l(), this.yPos() + border.t(), this.width() - border.l() - border.r(), this.height() - border.t() - border.b());
    }

    public Area outset(int outset) {
        return this.outset(new Border(outset));
    }

    public Area outset(Border border) {
        return new Area(this.xPos() - border.l(), this.yPos() - border.t(), this.width() + border.l() + border.r(), this.height() + border.t() + border.b());
    }

    public Area inset(int inset) {
        return this.inset(new Border(inset));
    }

    public String toString() {
        return this.width() + "x" + this.height() + "@" + this.xPos() + "," + this.yPos();
    }

    public Area shift(int dx, int f) {
        return new Area(this.xPos() + dx, this.yPos() + f, this.width(), this.height());
    }
}

