package binnie.genetics.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IModelManager;

import binnie.core.item.ItemCore;
import binnie.core.util.I18N;
import binnie.genetics.CreativeTabGenetics;
import binnie.genetics.Genetics;
import binnie.genetics.core.GeneticsGUI;

public class ItemDatabase extends ItemCore {

	public ItemDatabase() {
		super("geneticdatabase");
		this.func_77637_a(CreativeTabGenetics.instance);
		this.func_77625_d(1);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, 0);
		manager.registerItemModel(item, 1, "geneticdatabase_master");
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
		super.func_150895_a(itemIn, tab, subItems);
		subItems.add(new ItemStack(itemIn, 1, 1));
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
		ItemStack itemStack = player.func_184586_b(hand);
		final GeneticsGUI id;
		if (isMaster(itemStack)) {
			id = GeneticsGUI.DATABASE_NEI;
		} else {
			id = GeneticsGUI.DATABASE;
		}

		Genetics.proxy.openGui(id, player, player.func_180425_c());

		return new ActionResult(EnumActionResult.PASS, itemStack);
	}

	@Override
	public String func_77653_i(ItemStack itemStack) {
		return I18N.localise("genetics." + (isMaster(itemStack) ? "item.database.master.name" : "item.database.name"));
	}

	protected boolean isMaster(ItemStack itemStack) {
		return itemStack.func_77952_i() > 0;
	}
}
