package binnie.extrabees.genetics.effect;

import java.util.List;

import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityBeeLightning extends EntityLightningBolt {

	private int lightningState;
	private int boltLivingTime;

	public EntityBeeLightning(final World world) {
		super(world, 0, 0, 0, true);
	}

	public EntityBeeLightning(final World world, final double x, final double y, final double z) {
		super(world, x, y, z, false);
		this.lightningState = 2;
		this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
	}

	@Override
	public void func_70071_h_() {
		this.func_70030_z();
		--this.lightningState;
		if (this.lightningState < 0) {
			if (this.boltLivingTime == 0) {
				this.func_70106_y();
			} else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
				--this.boltLivingTime;
				this.lightningState = 1;
				this.field_70264_a = this.field_70146_Z.nextLong();
				final int i = MathHelper.func_76128_c(this.field_70165_t);
				final int j = MathHelper.func_76128_c(this.field_70163_u);
				final int k = MathHelper.func_76128_c(this.field_70161_v);
				final BlockPos pos = new BlockPos(i, j, k);
				if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175697_a(pos, 10)) {
					if (this.field_70170_p.func_175623_d(pos) && Blocks.field_150480_ab.func_176196_c(this.field_70170_p, pos)) {
						this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
					}
				}
			}
		}
		if (this.lightningState >= 0) {
			if (this.field_70170_p.field_72995_K) {
				this.field_70170_p.func_175702_c(2);
			} else {
				final double d0 = 3.0;
				final List<Entity> list = this.field_70170_p.func_72839_b(this, new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u - d0, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + 6.0 + d0, this.field_70161_v + d0));
				for (Entity entity : list) {
					entity.func_70077_a(this);
				}
			}
		}
	}
}
