package binnie.extrabees.client.gui;

import com.google.common.collect.Lists;

import java.awt.Color;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;

import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class GuiContainerAlvearyPart extends GuiContainer {

	@SuppressWarnings("all")
	protected FontRenderer font;
	protected AbstractAlvearyContainer container;
	private int titleS = -1;

	public GuiContainerAlvearyPart(AbstractAlvearyContainer container) {
		super(container);
		this.container = container;
		font = Minecraft.func_71410_x().field_71466_p;
	}

	@Override
	protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
		int i = (this.field_146294_l - this.field_146999_f) / 2;
		int j = (this.field_146295_m - this.field_147000_g) / 2;
		Minecraft.func_71410_x().func_110434_K().func_110577_a(container.background);
		if (titleS == -1) {
			titleS = (i + (field_146999_f / 2)) - (font.func_78256_a(container.title) / 2);
		}

		func_73729_b(i, j, 0, 0, container.dimension.width, container.dimension.height);
		font.func_78276_b(container.title, titleS, j + 8, Color.DARK_GRAY.getRGB());
		if (mouseX > i + 6 && mouseX < i + 23 && mouseY > j + 5 && mouseY < j + 22) {
			GuiUtils.drawHoveringText(Lists.newArrayList(container.tooltip), mouseX, mouseY, field_146294_l, field_146295_m, 150, font);
		}
	}
}
