/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.Binnie;
import binnie.core.Mods;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.ForestryAllele;
import binnie.core.gui.Attribute;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.EnumColor;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.integration.extrabees.ExtraBeesIntegration;
import binnie.core.resource.BinnieSprite;
import binnie.core.util.I18N;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import binnie.genetics.item.ModuleItems;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnalystPageMutations
extends ControlAnalystPage {
    public AnalystPageMutations(IWidget parent, Area area, IIndividual ind, boolean isMaster) {
        super(parent, area);
        this.setColor(0x333300);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        y += 18;
        final BreedingSystem system = Binnie.GENETICS.getSystem(ind.getGenome().getSpeciesRoot());
        List<IMutation> discovered = system.getDiscoveredMutations(((Window)Window.get(this)).getWorld(), ((Window)Window.get(this)).getUsername());
        final IAlleleSpecies speciesCurrent = ind.getGenome().getPrimary();
        List<IMutation> resultant = system.getResultantMutations(speciesCurrent);
        List<IMutation> further = system.getFurtherMutations(speciesCurrent);
        if (ind instanceof IBee) {
            ItemStack hive = null;
            if (ExtraBeesIntegration.isLoaded()) {
                if (speciesCurrent == ExtraBeesIntegration.water) {
                    hive = new ItemStack(ExtraBeesIntegration.hive, 1, 0);
                }
                if (speciesCurrent == ExtraBeesIntegration.rock) {
                    hive = new ItemStack(ExtraBeesIntegration.hive, 1, 1);
                }
                if (speciesCurrent == ExtraBeesIntegration.basalt) {
                    hive = new ItemStack(ExtraBeesIntegration.hive, 1, 2);
                }
                if (speciesCurrent == ExtraBeesIntegration.marble) {
                    hive = new ItemStack(ExtraBeesIntegration.hive, 1, 3);
                }
            }
            if (speciesCurrent == ForestryAllele.BeeSpecies.Forest.getAllele()) {
                hive = new ItemStack(Mods.Forestry.block("beehives"), 1, 1);
            }
            if (speciesCurrent == ForestryAllele.BeeSpecies.Meadows.getAllele()) {
                hive = new ItemStack(Mods.Forestry.block("beehives"), 1, 2);
            }
            if (speciesCurrent == ForestryAllele.BeeSpecies.Modest.getAllele()) {
                hive = new ItemStack(Mods.Forestry.block("beehives"), 1, 3);
            }
            if (speciesCurrent == ForestryAllele.BeeSpecies.Tropical.getAllele()) {
                hive = new ItemStack(Mods.Forestry.block("beehives"), 1, 4);
            }
            if (speciesCurrent == ForestryAllele.BeeSpecies.Ended.getAllele()) {
                hive = new ItemStack(Mods.Forestry.block("beehives"), 1, 5);
            }
            if (speciesCurrent == ForestryAllele.BeeSpecies.Wintry.getAllele()) {
                hive = new ItemStack(Mods.Forestry.block("beehives"), 1, 6);
            }
            if (speciesCurrent == ForestryAllele.BeeSpecies.Marshy.getAllele()) {
                hive = new ItemStack(Mods.Forestry.block("beehives"), 1, 7);
            }
            if (speciesCurrent == ForestryAllele.BeeSpecies.Steadfast.getAllele()) {
                hive = new ItemStack((Block)Blocks.field_150486_ae);
            }
            if (speciesCurrent == ForestryAllele.BeeSpecies.Valiant.getAllele()) {
                new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.mutations.bee.natural")).setColor(this.getColor());
                new ControlTextCentered((IWidget)this, y += 10, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.mutations.bee.hive")).setColor(this.getColor());
                y += 22;
            } else if (speciesCurrent == ForestryAllele.BeeSpecies.Monastic.getAllele()) {
                new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.mutations.bee.natural")).setColor(this.getColor());
                new ControlTextCentered((IWidget)this, y += 10, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.mutations.bee.villager")).setColor(this.getColor());
                y += 22;
            } else if (hive != null) {
                new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.mutations.bee.natural")).setColor(this.getColor());
                ControlItemDisplay display = new ControlItemDisplay(this, (this.width() - 16) / 2, y += 10);
                if (speciesCurrent == ForestryAllele.BeeSpecies.Steadfast.getAllele()) {
                    display.addTooltip(I18N.localise("genetics.gui.analyst.mutations.bee.dungeon"));
                } else {
                    display.setTooltip();
                }
                display.setItemStack(hive);
                y += 24;
            }
        }
        int ox = (this.width() - 88 - 8) / 2;
        int dx = 0;
        if (!resultant.isEmpty()) {
            if (resultant.size() == 1) {
                ox = (this.width() - 44) / 2;
            }
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.mutations.resultant")).setColor(this.getColor());
            y += 10;
            for (final IMutation mutation : resultant) {
                final float specificChance = this.getSpecificChance(ind, mutation, system);
                if (!isMaster && !this.isKnown(system, mutation)) {
                    new ControlUnknownMutation(this, ox + dx, y, 44, 16);
                } else {
                    new Control(this, ox + dx, y, 44, 16){

                        @Override
                        public void initialise() {
                            IAlleleSpecies species0 = mutation.getAllele0();
                            IAlleleSpecies species2 = mutation.getAllele1();
                            String comb = species0.getAlleleName() + " + " + species2.getAlleleName();
                            this.addTooltip(comb);
                            String chance = AnalystPageMutations.this.getMutationColour(mutation.getBaseChance()).getCode() + (int)mutation.getBaseChance() + "% " + I18N.localise("genetics.gui.analyst.mutations.chance");
                            if (specificChance != mutation.getBaseChance()) {
                                chance = chance + AnalystPageMutations.this.getMutationColour(specificChance).getCode() + " (" + (int)specificChance + "% " + I18N.localise("genetics.gui.analyst.mutations.currently") + ")";
                            }
                            this.addTooltip(chance);
                            for (String s : mutation.getSpecialConditions()) {
                                this.addTooltip(s);
                            }
                        }

                        @Override
                        @SideOnly(value=Side.CLIENT)
                        public void onRenderBackground(int guiWidth, int guiHeight) {
                            RenderUtil.drawItem(Point.ZERO, system.getDefaultMember(mutation.getAllele0().getUID()));
                            RenderUtil.drawItem(new Point(28, 0), system.getDefaultMember(mutation.getAllele1().getUID()));
                            if (specificChance != mutation.getBaseChance()) {
                                RenderUtil.setColour(AnalystPageMutations.this.getMutationColour(mutation.getBaseChance()).getColour());
                                AnalystPageMutations.this.drawSprite(ModuleItems.iconAdd0);
                                RenderUtil.setColour(AnalystPageMutations.this.getMutationColour(specificChance).getColour());
                                AnalystPageMutations.this.drawSprite(ModuleItems.iconAdd1);
                            } else {
                                RenderUtil.setColour(AnalystPageMutations.this.getMutationColour(mutation.getBaseChance()).getColour());
                                AnalystPageMutations.this.drawSprite(ModuleItems.iconAdd);
                            }
                        }
                    };
                }
                if ((dx = 52 - dx) != 0 && resultant.size() != 1) continue;
                y += 18;
            }
            if (dx != 0 && resultant.size() != 1) {
                y += 18;
            }
            y += 10;
        }
        ox = (this.width() - 88 - 8) / 2;
        dx = 0;
        if (!further.isEmpty()) {
            if (further.size() == 1) {
                ox = (this.width() - 44) / 2;
            }
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.mutations.further")).setColor(this.getColor());
            y += 10;
            for (final IMutation mutation : further) {
                final IAllele speciesComb = mutation.getPartner((IAllele)speciesCurrent);
                final float specificChance2 = this.getSpecificChance(ind, mutation, system);
                if (!isMaster && !this.isKnown(system, mutation)) {
                    new ControlUnknownMutation(this, ox + dx, y, 44, 16);
                } else {
                    new Control(this, ox + dx, y, 44, 16){

                        @Override
                        public void initialise() {
                            IAlleleSpecies species0 = (IAlleleSpecies)speciesComb;
                            IAlleleSpecies species2 = (IAlleleSpecies)mutation.getTemplate()[0];
                            this.addTooltip(species2.getAlleleName());
                            String comb = speciesCurrent.getAlleleName() + " + " + species0.getAlleleName();
                            this.addTooltip(comb);
                            String chance = AnalystPageMutations.this.getMutationColour(mutation.getBaseChance()).getCode() + (int)mutation.getBaseChance() + "% " + I18N.localise("genetics.gui.analyst.mutations.chance");
                            if (specificChance2 != mutation.getBaseChance()) {
                                chance = chance + AnalystPageMutations.this.getMutationColour(specificChance2).getCode() + " (" + (int)specificChance2 + "% " + I18N.localise("genetics.gui.analyst.mutations.currently") + ")";
                            }
                            this.addTooltip(chance);
                            for (String s : mutation.getSpecialConditions()) {
                                this.addTooltip(s);
                            }
                        }

                        @Override
                        @SideOnly(value=Side.CLIENT)
                        public void onRenderBackground(int guiWidth, int guiHeight) {
                            RenderUtil.drawItem(Point.ZERO, system.getDefaultMember(speciesComb.getUID()));
                            RenderUtil.drawItem(new Point(28, 0), system.getDefaultMember(mutation.getTemplate()[0].getUID()));
                            RenderUtil.setColour(AnalystPageMutations.this.getMutationColour(mutation.getBaseChance()).getColour());
                            if (specificChance2 != mutation.getBaseChance()) {
                                RenderUtil.setColour(AnalystPageMutations.this.getMutationColour(mutation.getBaseChance()).getColour());
                                AnalystPageMutations.this.drawSprite(ModuleItems.iconArrow0);
                                RenderUtil.setColour(AnalystPageMutations.this.getMutationColour(specificChance2).getColour());
                                AnalystPageMutations.this.drawSprite(ModuleItems.iconArrow1);
                            } else {
                                RenderUtil.setColour(AnalystPageMutations.this.getMutationColour(mutation.getBaseChance()).getColour());
                                AnalystPageMutations.this.drawSprite(ModuleItems.iconArrow);
                            }
                        }
                    };
                }
                if ((dx = 52 - dx) != 0 && further.size() != 1) continue;
                y += 18;
            }
            if (dx != 0 && further.size() != 1) {
                y += 18;
            }
        }
        this.setSize(new Point(this.width(), y += 8));
    }

    @SideOnly(value=Side.CLIENT)
    private void drawSprite(BinnieSprite sprite) {
        RenderUtil.drawSprite(new Point(14, 0), sprite.getSprite());
    }

    private boolean isKnown(BreedingSystem system, IMutation mutation) {
        return system.getDiscoveredMutations(this.getWindow().getWorld(), this.getWindow().getPlayer().func_146103_bH()).contains(mutation);
    }

    private float getSpecificChance(IIndividual ind, IMutation mutation, BreedingSystem system) {
        return system.getChance(mutation, this.getWindow().getPlayer(), mutation.getAllele0(), mutation.getAllele1());
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.mutations.title");
    }

    protected EnumColor getMutationColour(float percent) {
        if (percent >= 20.0f) {
            return EnumColor.DarkGreen;
        }
        if (percent >= 15.0f) {
            return EnumColor.Green;
        }
        if (percent >= 10.0f) {
            return EnumColor.Yellow;
        }
        if (percent >= 5.0f) {
            return EnumColor.Gold;
        }
        if (percent > 0.0f) {
            return EnumColor.Red;
        }
        return EnumColor.DarkRed;
    }

    static class ControlUnknownMutation
    extends Control {
        public ControlUnknownMutation(IWidget parent, int x, int y, int w, int h) {
            super(parent, x, y, w, h);
            this.addAttribute(Attribute.MouseOver);
            this.addTooltip(I18N.localise("genetics.gui.analyst.mutations.unknown.tooltip"));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onRenderBackground(int guiWidth, int guiHeight) {
            RenderUtil.drawText(this.getArea(), TextJustification.MIDDLE_CENTER, I18N.localise("genetics.gui.analyst.mutations.unknown"), 0xAAAAAA);
        }
    }
}

