/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.window;

import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Panel
extends Control {
    IPanelType type;

    public Panel(IWidget parent, int x, int y, int width, int height, IPanelType type) {
        super(parent, x, y, width, height);
        this.type = type;
    }

    public Panel(IWidget parent, Area area, IPanelType type) {
        this(parent, area.xPos(), area.yPos(), area.width(), area.height(), type);
    }

    public IPanelType getType() {
        return this.type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        IPanelType panelType = this.getType();
        if (panelType instanceof MinecraftGUI.PanelType) {
            switch ((MinecraftGUI.PanelType)panelType) {
                case Black: {
                    CraftGUI.RENDER.texture((Object)CraftGUITexture.PanelBlack, this.getArea());
                    break;
                }
                case Gray: {
                    CraftGUI.RENDER.texture((Object)CraftGUITexture.PanelGray, this.getArea());
                    break;
                }
                case Tinted: {
                    CraftGUI.RENDER.texture((Object)CraftGUITexture.PanelTinted, this.getArea());
                    break;
                }
                case Outline: {
                    CraftGUI.RENDER.texture((Object)CraftGUITexture.Outline, this.getArea());
                    break;
                }
                case TabOutline: {
                    CraftGUI.RENDER.texture((Object)CraftGUITexture.TabOutline, this.getArea());
                    break;
                }
            }
        }
    }

    public static interface IPanelType {
    }
}

