/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.geometry;

import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;

public class CraftGUIUtil {
    public static void alignToWidget(IWidget target, IWidget relativeTo) {
        Point startPos = target.getAbsolutePosition();
        Point endPos = relativeTo.getAbsolutePosition();
        CraftGUIUtil.moveWidget(target, endPos.sub(startPos));
    }

    public static void moveWidget(IWidget target, Point movement) {
        target.setPosition(target.getPosition().add(movement));
    }

    public static void horizontalGrid(int px, int py, IWidget ... widgets) {
        CraftGUIUtil.horizontalGrid(px, py, TextJustification.MIDDLE_CENTER, 0, widgets);
    }

    public static void horizontalGrid(int px, int py, TextJustification just, int spacing, IWidget ... widgets) {
        int x = 0;
        int h = 0;
        for (IWidget widget : widgets) {
            h = Math.max(h, widget.getSize().y());
        }
        for (IWidget widget : widgets) {
            widget.setPosition(new Point(px + x, py + Math.round((float)(h - widget.getSize().y()) * just.getYOffset())));
            x += widget.getSize().x() + spacing;
        }
    }

    public static void verticalGrid(int px, int py, IWidget ... widgets) {
        CraftGUIUtil.horizontalGrid(px, py, TextJustification.MIDDLE_CENTER, 0, widgets);
    }

    public static void verticalGrid(int px, int py, TextJustification just, int spacing, IWidget ... widgets) {
        int y = 0;
        int w = 0;
        for (IWidget widget : widgets) {
            w = Math.max(w, widget.getSize().x());
        }
        for (IWidget widget : widgets) {
            widget.setPosition(new Point(px + Math.round((float)(w - widget.getSize().x()) * just.getXOffset()), py + y));
            y += widget.getSize().y() + spacing;
        }
    }

    public static <T> void linkWidgets(final IControlValue<T> tab, final IControlValue<T> target) {
        tab.addSelfEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                target.setValue(event.getValue());
            }
        });
        target.addSelfEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                tab.setValue(event.getValue());
            }
        });
    }
}

