/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls.listbox;

import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.geometry.Point;
import binnie.core.util.IValidator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ControlList<T>
extends Control
implements IControlValue<T> {
    ControlListBox<T> parent;
    Map<T, IWidget> allOptions;
    Map<T, IWidget> optionWidgets;
    boolean creating;
    @Nullable
    IValidator<IWidget> validator;
    @Nullable
    private T defaultValue;
    @Nullable
    private T value;

    protected ControlList(ControlListBox<T> parent, int x, int y, int w, int h, @Nullable T defaultValue) {
        super(parent, x, y, w, h);
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        this.allOptions = new LinkedHashMap<T, IWidget>();
        this.optionWidgets = new LinkedHashMap<T, IWidget>();
        this.creating = false;
        this.parent = parent;
    }

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(@Nullable T value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        if (this.optionWidgets.containsKey(value)) {
            IWidget child = this.optionWidgets.get(value);
            this.parent.ensureVisible(child.getYPos(), child.getYPos() + child.height(), this.height());
        }
        this.parent.callEvent(new EventValueChanged<T>(this.parent, value));
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void filterOptions() {
        int height = 0;
        this.optionWidgets.clear();
        for (Map.Entry<T, IWidget> entry : this.allOptions.entrySet()) {
            if (this.isValidOption(entry.getValue())) {
                entry.getValue().show();
                this.optionWidgets.put(entry.getKey(), entry.getValue());
                entry.getValue().setPosition(new Point(0, height));
                height += entry.getValue().getSize().y();
                continue;
            }
            entry.getValue().hide();
        }
        this.creating = true;
        this.setValue(this.getValue());
        this.setSize(new Point(this.getSize().x(), height));
    }

    public Collection<T> getOptions() {
        return this.optionWidgets.keySet();
    }

    public void setOptions(Collection<T> options) {
        this.deleteAllChildren();
        this.allOptions.clear();
        for (T option : options) {
            IWidget optionWidget = this.parent.createOption(option, 0);
            this.allOptions.put(option, optionWidget);
        }
        this.filterOptions();
    }

    public Collection<T> getAllOptions() {
        return this.allOptions.keySet();
    }

    public int getIndexOf(T value) {
        int index = 0;
        for (T option : this.getOptions()) {
            if (option.equals(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getCurrentIndex() {
        return this.getIndexOf(this.getValue());
    }

    public void setIndex(int currentIndex) {
        int index = 0;
        for (T option : this.getOptions()) {
            if (index == currentIndex) {
                this.setValue(option);
                return;
            }
            ++index;
        }
        this.setValue(this.defaultValue);
    }

    private boolean isValidOption(IWidget widget) {
        return this.validator == null || this.validator.isValid(widget);
    }

    public void setValidator(IValidator<IWidget> validator) {
        if (this.validator != validator) {
            this.validator = validator;
            this.filterOptions();
        }
    }
}

