/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls.button;

import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.events.EventButtonClicked;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlButton
extends Control {
    @Nullable
    private ControlText textWidget;
    @Nullable
    private String text;

    public ControlButton(IWidget parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.addAttribute(Attribute.MouseOver);
        this.addEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                ControlButton.this.callEvent(new EventButtonClicked(ControlButton.this.getWidget()));
                ControlButton.this.onMouseClick(event);
            }
        }.setOrigin(EventHandler.Origin.Self, this));
    }

    public ControlButton(IWidget parent, int x, int y, int width, int height, String text) {
        this(parent, x, y, width, height);
        this.text = text;
        this.textWidget = new ControlText(this, this.getArea(), text, TextJustification.MIDDLE_CENTER);
    }

    protected void onMouseClick(EventMouse.Down event) {
    }

    @Override
    public void onUpdateClient() {
        String text;
        if (this.textWidget != null && (text = this.getText()) != null) {
            this.textWidget.setValue(text);
        }
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUITexture texture = CraftGUITexture.ButtonDisabled;
        if (this.isMouseOver()) {
            texture = CraftGUITexture.ButtonHighlighted;
        } else if (this.isEnabled()) {
            texture = CraftGUITexture.Button;
        }
        CraftGUI.RENDER.texture((Object)texture, this.getArea());
    }
}

