/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gui.database;

import binnie.botany.api.IColorMix;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.CraftGUITextureSheet;
import binnie.core.gui.resource.minecraft.StandardTexture;
import binnie.core.util.I18N;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlColorMixSymbol
extends Control
implements ITooltip {
    static Texture MutationPlus = new StandardTexture(2, 94, 16, 16, CraftGUITextureSheet.Controls2);
    static Texture MutationArrow = new StandardTexture(20, 94, 32, 16, CraftGUITextureSheet.Controls2);
    IColorMix value;
    int type;

    protected ControlColorMixSymbol(IWidget parent, int x, int y, int type, IColorMix value) {
        super(parent, x, y, 16 + type * 16, 16);
        this.value = value;
        this.type = type;
        this.addAttribute(Attribute.MouseOver);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        super.onRenderBackground(guiWidth, guiHeight);
        if (this.type == 0) {
            CraftGUI.render.texture(MutationPlus, Point.ZERO);
        } else {
            CraftGUI.render.texture(MutationArrow, Point.ZERO);
        }
    }

    public void setValue(IColorMix value) {
        this.value = value;
        this.setColor(0xFFFFFF);
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.type == 1) {
            float chance = this.value.getChance();
            tooltip.add(I18N.localise("botany.gui.database.control.color_mix_symbol.chance", Float.valueOf(chance)));
        }
    }
}

