package binnie.core.machines.inventory;

import javax.annotation.Nullable;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

import binnie.core.util.I18N;

public class InventorySlot extends BaseSlot<ItemStack> {
	private ItemStack itemStack;
	private Type type;

	public InventorySlot(final int index, final String unlocName) {
		super(index, unlocName);
		this.itemStack = ItemStack.field_190927_a;
		this.type = Type.Standard;
	}

	@Override
	@Nullable
	public ItemStack getContent() {
		return this.itemStack.func_190926_b() ? null : this.itemStack;
	}

	@Override
	public void setContent(final ItemStack itemStack) {
		this.itemStack = itemStack;
	}

	public ItemStack getItemStack() {
		return this.itemStack;
	}

	public void setItemStack(final ItemStack duplicate) {
		this.setContent(duplicate);
	}

	@Override
	public boolean isEmpty() {
		return this.itemStack.func_190926_b();
	}

	public ItemStack decrStackSize(final int amount) {
		if (this.itemStack.func_190926_b()) {
			return ItemStack.field_190927_a;
		}
		if (this.itemStack.func_190916_E() <= amount) {
			final ItemStack returnStack = this.itemStack.func_77946_l();
			this.itemStack = ItemStack.field_190927_a;
			return returnStack;
		}
		final ItemStack returnStack = this.itemStack.func_77946_l();
		final ItemStack itemStack = this.itemStack;
		itemStack.func_190918_g(amount);
		returnStack.func_190920_e(amount);
		return returnStack;
	}

	@Override
	public void readFromNBT(final NBTTagCompound slotNBT) {
		if (slotNBT.func_74764_b("item")) {
			final NBTTagCompound itemNBT = slotNBT.func_74775_l("item");
			this.itemStack = new ItemStack(itemNBT);
		} else {
			this.itemStack = ItemStack.field_190927_a;
		}
	}

	@Override
	public NBTTagCompound writeToNBT(final NBTTagCompound slotNBT) {
		final NBTTagCompound itemNBT = new NBTTagCompound();
		if (!this.itemStack.func_190926_b()) {
			this.itemStack.func_77955_b(itemNBT);
		}
		slotNBT.func_74782_a("item", itemNBT);
		return slotNBT;
	}

	@Override
	public SlotValidator getValidator() {
		return (SlotValidator) this.validator;
	}

	public Type getType() {
		return this.type;
	}

	public void setType(final Type type) {
		this.type = type;
		if (type == Type.Recipe) {
			//this.setReadOnly();
			this.forbidInteraction();
		}
	}

	public boolean isRecipe() {
		return this.type == Type.Recipe;
	}

	@Override
	public String getName() {
		return I18N.localise("binniecore.gui.slot." + this.unlocName);
	}

	public enum Type {
		Standard,
		Recipe
	}
}
