/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.craftgui;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Window;
import binnie.genetics.genetics.GeneTracker;
import binnie.genetics.machine.craftgui.ControlGene;
import binnie.genetics.machine.craftgui.WindowGeneBank;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ControlGeneScroll
extends Control
implements IControlValue<BreedingSystem> {
    private String filter = "";
    @Nullable
    private BreedingSystem system = null;

    protected ControlGeneScroll(IWidget parent, int x, int y, int w, int h) {
        super(parent, x, y, w, h);
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase();
        this.refresh();
    }

    public void setGenes(BreedingSystem system) {
        this.system = system;
        this.refresh();
    }

    public void refresh() {
        if (this.system == null) {
            return;
        }
        this.deleteAllChildren();
        GeneTracker tracker = GeneTracker.getTracker(((Window)Window.get(this)).getWorld(), ((Window)Window.get(this)).getUsername());
        Map<IChromosomeType, List<IAllele>> genes = Binnie.GENETICS.getChromosomeMap(this.system.getSpeciesRoot());
        int x = 0;
        int y = 0;
        boolean isNEI = ((WindowGeneBank)Window.get((IWidget)this)).isNei;
        for (Map.Entry<IChromosomeType, List<IAllele>> entry : genes.entrySet()) {
            ArrayList<IAllele> discovered = new ArrayList<IAllele>();
            for (IAllele allele : entry.getValue()) {
                Gene gene = new Gene(allele, entry.getKey(), this.system.getSpeciesRoot());
                if (!isNEI && !tracker.isSequenced(new Gene(allele, entry.getKey(), this.system.getSpeciesRoot())) || !gene.getName().toLowerCase().contains(this.filter)) continue;
                discovered.add(allele);
            }
            if (discovered.size() == 0) continue;
            x = 0;
            new ControlText((IWidget)this, new Point(x, y), this.system.getChromosomeName(entry.getKey()));
            y += 12;
            for (IAllele allele : discovered) {
                if (x + 18 > this.getSize().x()) {
                    y += 20;
                    x = 0;
                }
                new ControlGene(this, x, y, new Gene(allele, entry.getKey(), this.system.getSpeciesRoot()));
                x += 18;
            }
            y += 24;
        }
        this.setSize(new Point(this.getSize().x(), y));
    }

    @Override
    public BreedingSystem getValue() {
        return this.system;
    }

    @Override
    public void setValue(BreedingSystem system) {
        this.setGenes(system);
    }
}

