/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst.flower;

import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerGenome;
import binnie.botany.api.IFlowerType;
import binnie.botany.flower.FlowerSpriteManager;
import binnie.botany.gui.database.ControlColorDisplay;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.control.ControlIconDisplay;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.util.I18N;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnalystPageAppearance
extends ControlAnalystPage {
    public AnalystPageAppearance(IWidget parent, Area area, final IFlower flower) {
        super(parent, area);
        this.setColor(0x333333);
        int y = 4;
        IFlowerGenome genome = flower.getGenome();
        IAlleleFlowerSpecies species = genome.getPrimary();
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        ControlColorDisplay a = new ControlColorDisplay(this, this.width() / 2 - 28, y += 12, genome.getPrimaryColor());
        a.addTooltip(I18N.localise("genetics.gui.analyst.appearance.primary"));
        ControlColorDisplay b = new ControlColorDisplay(this, this.width() / 2 - 8, y, genome.getSecondaryColor());
        b.addTooltip(I18N.localise("genetics.gui.analyst.appearance.secondary"));
        ControlColorDisplay c = new ControlColorDisplay(this, this.width() / 2 + 12, y, genome.getStemColor());
        c.addTooltip(I18N.localise("genetics.gui.analyst.appearance.stem"));
        final IFlowerType type = genome.getType();
        final int sections = type.getSections();
        final int width = sections > 1 ? 50 : 100;
        new ControlIconDisplay(this, (this.width() - width) / 2, (y += 26) - (sections == 1 ? 0 : 0)){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onRenderForeground(int guiWidth, int guiHeight) {
                GlStateManager.func_179094_E();
                float scale = (float)width / 16.0f;
                int dy = sections > 1 ? 16 : 0;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                RenderUtil.setColour(flower.getGenome().getStemColor().getColor(false));
                if (sections > 1) {
                    RenderUtil.drawSprite(Point.ZERO, FlowerSpriteManager.getStem(type, 1, true));
                }
                RenderUtil.drawSprite(new Point(0, dy), FlowerSpriteManager.getStem(type, 0, true));
                RenderUtil.setColour(flower.getGenome().getPrimaryColor().getColor(false));
                if (sections > 1) {
                    RenderUtil.drawSprite(Point.ZERO, FlowerSpriteManager.getPetal(type, 1, true));
                }
                RenderUtil.drawSprite(new Point(0, dy), FlowerSpriteManager.getPetal(type, 0, true));
                RenderUtil.setColour(flower.getGenome().getSecondaryColor().getColor(false));
                if (sections > 1) {
                    RenderUtil.drawSprite(Point.ZERO, FlowerSpriteManager.getVariant(type, 1, true));
                }
                RenderUtil.drawSprite(new Point(0, dy), FlowerSpriteManager.getVariant(type, 0, true));
                GlStateManager.func_179121_F();
            }
        };
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.appearance.title");
    }
}

