/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.lumbermill;

import binnie.core.machines.Machine;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateDefinition;
import binnie.core.machines.power.IProcess;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.machines.ExtraTreesErrorCode;
import binnie.extratrees.machines.lumbermill.LumbermillRecipes;
import net.minecraft.item.ItemStack;

public class LumbermillLogic
extends ComponentProcessSetCost
implements IProcess {
    public static final int PROCESS_ENERGY = 900;
    public static final int PROCESS_LENGTH = 30;
    public static final int WATER_PER_TICK = 10;

    public LumbermillLogic(Machine machine) {
        super(machine, 900, 30);
    }

    @Override
    public ErrorState canWork() {
        ItemStack itemStack;
        ItemStack currentPlank;
        MachineUtil util = this.getUtil();
        ItemStack logStack = util.getStack(0);
        if (logStack.func_190926_b()) {
            return new ErrorState((IErrorStateDefinition)ExtraTreesErrorCode.LUMBERMILL_NO_WOOD, 0);
        }
        ItemStack plankResult = LumbermillRecipes.getPlankProduct(logStack);
        if (!(util.isSlotEmpty(1) || plankResult.func_190926_b() || plankResult.func_77969_a(currentPlank = util.getStack(1)) && plankResult.func_190916_E() + currentPlank.func_190916_E() <= currentPlank.func_77976_d())) {
            return new ErrorState((IErrorStateDefinition)ExtraTreesErrorCode.LUMBERMILL_NO_SPACE_PLANKS, new int[]{1});
        }
        if (!util.isSlotEmpty(2) && (itemStack = util.getStack(2)).func_190916_E() + 1 > itemStack.func_77976_d()) {
            return new ErrorState((IErrorStateDefinition)ExtraTreesErrorCode.LUMBERMILL_NO_SPACE_BARK, new int[]{2});
        }
        if (!util.isSlotEmpty(3) && (itemStack = util.getStack(3)).func_190916_E() + 1 > itemStack.func_77976_d()) {
            return new ErrorState((IErrorStateDefinition)ExtraTreesErrorCode.LUMBERMILL_NO_SPACE_SAW_DUST, new int[]{3});
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (!this.getUtil().liquidInTank(0, 5)) {
            return new ErrorState((IErrorStateDefinition)ExtraTreesErrorCode.LUMBERMILL_INSUFFICIENT_WATER, 0);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        MachineUtil util = this.getUtil();
        ItemStack logStack = util.getStack(0);
        ItemStack result = LumbermillRecipes.getPlankProduct(logStack);
        if (result == null) {
            return;
        }
        util.addStack(1, result);
        util.addStack(3, ExtraTreeItems.Sawdust.get(1));
        util.addStack(2, ExtraTreeItems.Bark.get(1));
        util.decreaseStack(0, 1);
    }

    @Override
    protected void onTickTask() {
        this.getUtil().drainTank(0, 10);
    }
}

