/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.infuser;

import binnie.core.machines.Machine;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.CoreErrorCode;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateDefinition;
import binnie.core.machines.power.IProcess;
import binnie.extratrees.machines.infuser.InfuserRecipes;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class InfuserLogic
extends ComponentProcessSetCost
implements IProcess {
    ItemStack infusing;

    public InfuserLogic(Machine machine) {
        super(machine, 16000, 800);
    }

    @Override
    public int getProcessEnergy() {
        return this.getProcessLength() * 2;
    }

    @Override
    public int getProcessLength() {
        return 20;
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isTankEmpty(0)) {
            return new ErrorState((IErrorStateDefinition)CoreErrorCode.TANK_EMPTY, 0);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        FluidStack outputTankFluid = this.getUtil().getFluid(1);
        if (!this.getUtil().isTankEmpty(1) && this.getOutput() != null && !this.getOutput().isFluidEqual(outputTankFluid)) {
            return new ErrorState((IErrorStateDefinition)CoreErrorCode.NO_SPACE_TANK, new int[]{1});
        }
        if (outputTankFluid != null && !outputTankFluid.isFluidEqual(this.getOutput())) {
            return new ErrorState((IErrorStateDefinition)CoreErrorCode.TANK_DIFFRENT_FLUID, 1);
        }
        return super.canProgress();
    }

    @Nullable
    private FluidStack getOutput() {
        FluidStack fluid = this.getUtil().getFluid(0);
        if (fluid == null) {
            return null;
        }
        return InfuserRecipes.getOutput(fluid, this.infusing);
    }

    @Override
    protected void onFinishTask() {
        FluidStack output = this.getOutput();
        if (output != null) {
            this.getUtil().fillTank(1, output.copy());
        }
    }

    @Override
    protected void onTickTask() {
    }

    @Override
    public String getTooltip() {
        return "Infusing";
    }
}

