/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.brewery;

import binnie.extratrees.machines.brewery.BreweryCrafting;
import binnie.extratrees.machines.brewery.BreweryRecipe;
import binnie.extratrees.machines.brewery.IBreweryRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class BreweryRecipes {
    public static final int GRAIN_BARLEY = OreDictionary.getOreID((String)"seedBarley");
    public static final int GRAIN_WHEAT = OreDictionary.getOreID((String)"seedWheat");
    public static final int GRAIN_RYE = OreDictionary.getOreID((String)"seedRye");
    public static final int GRAIN_CORN = OreDictionary.getOreID((String)"seedCorn");
    public static final int GRAIN_ROASTED = OreDictionary.getOreID((String)"seedRoasted");
    public static final int HOPS = OreDictionary.getOreID((String)"cropHops");
    private static List<IBreweryRecipe> recipes = new ArrayList<IBreweryRecipe>();

    public static boolean isValidGrain(ItemStack itemstack) {
        for (IBreweryRecipe recipe : recipes) {
            if (!recipe.isGrain(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidYeast(ItemStack itemstack) {
        for (IBreweryRecipe recipe : recipes) {
            ItemStack yeast = recipe.getYeast();
            if (!yeast.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FluidStack getOutput(FluidStack stack) {
        BreweryCrafting crafting = new BreweryCrafting(stack, ItemStack.field_190927_a, null, ItemStack.field_190927_a);
        for (IBreweryRecipe recipe : recipes) {
            FluidStack output = recipe.getOutput(crafting);
            if (output == null) continue;
            return output;
        }
        return null;
    }

    @Nullable
    public static FluidStack getOutput(BreweryCrafting crafting) {
        if (crafting.inputFluid != null && !crafting.yeast.func_190926_b()) {
            for (IBreweryRecipe recipe : recipes) {
                FluidStack output = recipe.getOutput(crafting);
                if (output == null) continue;
                return output;
            }
        }
        return null;
    }

    @Nullable
    public static IBreweryRecipe getRecipe(BreweryCrafting crafting) {
        if (crafting.inputFluid != null && !crafting.yeast.func_190926_b()) {
            for (IBreweryRecipe recipe : recipes) {
                FluidStack output = recipe.getOutput(crafting);
                if (output == null) continue;
                return recipe;
            }
        }
        return null;
    }

    public static boolean isValidIngredient(ItemStack itemstack) {
        for (IBreweryRecipe recipe : recipes) {
            if (!recipe.isIngredient(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInputLiquid(FluidStack fluid) {
        for (IBreweryRecipe recipe : recipes) {
            FluidStack input = recipe.getInput();
            if (!input.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidOutputLiquid(FluidStack fluid) {
        for (IBreweryRecipe recipe : recipes) {
            FluidStack output = recipe.getOutput();
            if (!output.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public static void addRecipe(FluidStack input, FluidStack output) {
        recipes.add(new BreweryRecipe(input, output));
    }

    public static void addRecipe(IBreweryRecipe recipe) {
        recipes.add(recipe);
    }

    public static void addRecipes(IBreweryRecipe ... recipes) {
        Collections.addAll(BreweryRecipes.recipes, recipes);
    }

    public static List<IBreweryRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }
}

