/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.brewery;

import binnie.Binnie;
import binnie.core.util.OreDictionaryUtil;
import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.machines.brewery.BreweryCrafting;
import binnie.extratrees.machines.brewery.IBreweryRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BrewedGrainRecipe
implements IBreweryRecipe {
    public static final FluidStack WATER = Binnie.LIQUID.getFluidStack("water", 1000);
    private final FluidStack output;
    private final int grainOreId;
    @Nullable
    private final Integer ingredientOreId;
    private final ItemStack yeast;

    public BrewedGrainRecipe(Alcohol output, int grainOreId) {
        this(output, grainOreId, null, ExtraTreeItems.Yeast.get(1));
    }

    public BrewedGrainRecipe(Alcohol output, int grainOreId, Integer ingredientOreId) {
        this(output, grainOreId, ingredientOreId, ExtraTreeItems.Yeast.get(1));
    }

    public BrewedGrainRecipe(Alcohol output, int grainOreId, @Nullable Integer ingredientOreId, ItemStack specificYeast) {
        this.output = output.get(1000);
        this.grainOreId = grainOreId;
        this.ingredientOreId = ingredientOreId;
        this.yeast = specificYeast;
    }

    @Override
    @Nullable
    public FluidStack getOutput(BreweryCrafting crafting) {
        if (WATER.isFluidEqual(crafting.inputFluid) && this.isIngredient(crafting.ingredient) && this.yeast.func_77969_a(crafting.yeast)) {
            int grainCount = 0;
            for (ItemStack stack : crafting.inputGrains) {
                if (stack == null) {
                    return null;
                }
                if (!this.isGrain(stack)) continue;
                ++grainCount;
            }
            if (grainCount >= 2) {
                return this.output.copy();
            }
        }
        return null;
    }

    @Override
    public FluidStack getInput() {
        return WATER;
    }

    @Override
    public FluidStack getOutput() {
        return this.output;
    }

    @Override
    public boolean isIngredient(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return this.ingredientOreId == null;
        }
        return this.ingredientOreId != null && OreDictionaryUtil.hasOreId(itemstack, this.ingredientOreId);
    }

    @Override
    public List<ItemStack> getIngredients() {
        if (this.ingredientOreId == null) {
            return Collections.emptyList();
        }
        return OreDictionaryUtil.getOres(this.ingredientOreId);
    }

    @Override
    public boolean isGrain(ItemStack itemStack) {
        return OreDictionaryUtil.hasOreId(itemStack, this.grainOreId);
    }

    @Override
    public List<ItemStack> getGrains() {
        return OreDictionaryUtil.getOres(this.grainOreId);
    }

    @Override
    public ItemStack getYeast() {
        return this.yeast;
    }
}

