/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.item;

import binnie.core.Mods;
import binnie.core.item.IItemMiscProvider;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.Juice;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum Food implements IItemMiscProvider
{
    CRABAPPLE(2),
    ORANGE(4),
    KUMQUAT(2),
    LIME(2),
    WILD_CHERRY(2),
    SOUR_CHERRY(2),
    BLACK_CHERRY(2),
    Blackthorn(3),
    CHERRY_PLUM(3),
    ALMOND(1),
    APRICOT(4),
    GRAPEFRUIT(4),
    PEACH(4),
    SATSUMA(3),
    BUDDHA_HAND(3),
    CITRON(3),
    FINGER_LIME(3),
    KEY_LIME(2),
    MANDERIN(3),
    NECTARINE(3),
    POMELO(3),
    TANGERINE(3),
    PEAR(4),
    SAND_PEAR(2),
    HAZELNUT(2),
    BUTTERNUT(1),
    BEECHNUT(0),
    PECAN(0),
    BANANA(4),
    RED_BANANA(4),
    PLANTAIN(2),
    BRAZIL_NUT(0),
    FIG(2),
    ACORN(0),
    ELDERBERRY(1),
    OLIVE(1),
    GINGKO_NUT(1),
    COFFEE(0),
    OSANGE_ORANGE(1),
    CLOVE(0),
    PAPAYIMAR(8),
    BLACKCURRANT(2),
    REDCURRANT(2),
    BLACKBERRY(2),
    RASPBERRY(2),
    BLUEBERRY(2),
    CRANBERRY(2),
    JUNIPER(0),
    GOOSEBERRY(2),
    GOLDEN_RASPBERRY(2),
    COCONUT(2),
    CASHEW(0),
    AVACADO(2),
    NUTMEG(0),
    ALLSPICE(0),
    CHILLI(2),
    STAR_ANISE(0),
    MANGO(4),
    STARFRUIT(2),
    CANDLENUT(0);

    public static Food[] VALUES;
    int hunger;
    private List<String> ores = new ArrayList<String>();

    private Food() {
        this(0);
    }

    private Food(int hunger) {
        this.hunger = hunger;
    }

    public static void registerOreDictionary() {
        CRABAPPLE.ore("Apple").ore("Crabapple");
        ORANGE.ore("Orange");
        KUMQUAT.ore("Kumquat");
        LIME.ore("Lime");
        WILD_CHERRY.ore("Cherry").ore("WildCherry");
        SOUR_CHERRY.ore("Cherry").ore("SourCherry");
        BLACK_CHERRY.ore("Cherry").ore("BlackCherry");
        Blackthorn.ore("Blackthorn");
        CHERRY_PLUM.ore("Plum").ore("CherryPlum");
        ALMOND.ore("Almond");
        APRICOT.ore("Apricot");
        GRAPEFRUIT.ore("Grapefruit");
        PEACH.ore("Peach");
        SATSUMA.ore("Satsuma").ore("Orange");
        BUDDHA_HAND.ore("BuddhaHand").ore("Citron");
        CITRON.ore("Citron");
        FINGER_LIME.ore("Lime").ore("FingerLime");
        KEY_LIME.ore("KeyLime").ore("Lime");
        MANDERIN.ore("Orange").ore("Manderin");
        NECTARINE.ore("Peach").ore("Nectarine");
        POMELO.ore("Pomelo");
        TANGERINE.ore("Tangerine").ore("Orange");
        PEAR.ore("Pear");
        SAND_PEAR.ore("SandPear");
        HAZELNUT.ore("Hazelnut");
        BUTTERNUT.ore("Butternut").ore("Walnut");
        BEECHNUT.ore("Beechnut");
        PECAN.ore("Pecan");
        BANANA.ore("Banana");
        RED_BANANA.ore("RedBanana").ore("Banana");
        PLANTAIN.ore("Plantain");
        BRAZIL_NUT.ore("BrazilNut");
        FIG.ore("Fig");
        ACORN.ore("Acorn");
        ELDERBERRY.ore("Elderberry");
        OLIVE.ore("Olive");
        GINGKO_NUT.ore("GingkoNut");
        COFFEE.ore("Coffee");
        OSANGE_ORANGE.ore("OsangeOrange");
        CLOVE.ore("Clove");
    }

    public boolean isEdible() {
        return this.hunger > 0;
    }

    public int getHealth() {
        return this.hunger;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public String getDisplayName(ItemStack stack) {
        return I18N.localise("extratrees.item.food." + this.name().toLowerCase());
    }

    @Override
    public ItemStack get(int i) {
        return new ItemStack(ExtraTrees.items().itemFood, i, this.ordinal());
    }

    @Override
    public String getModelPath() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void addInformation(List<String> tooltip) {
    }

    public void addJuice(Juice juice, int time, int amount, int mulch) {
        RecipeManagers.squeezerManager.addRecipe(time, this.get(1), Fluids.JUICE.getFluid(amount), Mods.Forestry.stack("mulch"), mulch);
    }

    public void addJuice(int time, int amount, int mulch) {
        RecipeManagers.squeezerManager.addRecipe(time, this.get(1), Fluids.JUICE.getFluid(amount), Mods.Forestry.stack("mulch"), mulch);
    }

    public void addOil(int time, int amount, int mulch) {
        RecipeManagers.squeezerManager.addRecipe(time, this.get(1), Fluids.SEED_OIL.getFluid(amount), Mods.Forestry.stack("mulch"), mulch);
    }

    private Food ore(String string) {
        OreDictionary.registerOre((String)("crop" + string), (ItemStack)this.get(1));
        this.ores.add("crop" + string);
        return this;
    }

    public Collection<String> getOres() {
        return this.ores;
    }

    static {
        VALUES = Food.values();
    }
}

