/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.Binnie;
import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.IFluidType;
import binnie.extratrees.alcohol.ICocktailLiquid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum MiscFluid implements IFluidType,
ICocktailLiquid
{
    CarbonatedWater("Carbonated Water", "water.carbonated", 0xCCCCFF, (double)0.1f),
    TonicWater("Tonic Water", "water.tonic", 0xCCCCFF, (double)0.1f),
    Cream("Carbonated Water", "cream", 0xEAEADE, 2.0),
    GingerAle("Ginger Ale", "gingerAle", 0xFFFFFF, (double)0.6f),
    Coffee("Coffee", "coffee", 5910789, (double)0.3f),
    SugarSyrup("Simple Syrup", "syrup.simple", 16120049, (double)0.1f),
    AgaveNectar("Agave Nectar", "syrup.agave", 13598245, (double)0.7f),
    GrenadineSyrup("Grenadine Syrup", "syrup.grenadine", 16009573, (double)0.8f);

    String name;
    String ident;
    int colour;
    float transparency;

    private MiscFluid(String name, String ident, int colour, double transparency) {
        this.name = name;
        this.ident = ident;
        this.colour = colour;
        this.transparency = (float)transparency;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean canPlaceIn(FluidContainerType container) {
        return true;
    }

    @Override
    public boolean showInCreative(FluidContainerType container) {
        return container == FluidContainerType.GLASS;
    }

    @Override
    public ResourceLocation getFlowing() {
        return new ResourceLocation("extratrees", "blocks/liquids/liquid");
    }

    @Override
    public ResourceLocation getStill() {
        return new ResourceLocation("extratrees", "blocks/liquids/liquid");
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getIdentifier() {
        return "binnie." + this.ident;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public FluidStack get(int amount) {
        return Binnie.LIQUID.getFluidStack(this.getIdentifier(), amount);
    }

    @Override
    public int getTransparency() {
        return (int)(Math.min(1.0, (double)this.transparency + 0.3) * 255.0);
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.getDisplayName();
    }

    @Override
    public int getContainerColour() {
        return this.getColour();
    }

    @Override
    public float getABV() {
        return 0.0f;
    }
}

