/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.items;

import binnie.core.Mods;
import binnie.core.util.I18N;
import binnie.extrabees.items.IItemModelProvider;
import forestry.api.core.Tabs;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(modid="ic2", iface="ic2.api.item.IElectricItem"), @Optional.Interface(modid="ic2", iface="ic2.api.item.IItemHudInfo")})
public class ItemHoneyCrystal
extends Item
implements IElectricItem,
IItemHudInfo,
IItemModelProvider {
    private int maxCharge = 8000;
    private int transferLimit = 500;
    private int tier = 1;

    public ItemHoneyCrystal() {
        this.func_77656_e(27);
        this.func_77625_d(16);
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77655_b("honey_crystal");
        this.setRegistryName("honey_crystal");
    }

    public String func_77653_i(ItemStack stack) {
        if (Mods.IC2.active()) {
            double charge = ElectricItem.manager.getCharge(stack);
            double maxCharge = ElectricItem.manager.getMaxCharge(stack);
            if (charge <= 0.0) {
                return I18N.localise("extrabees.item.honeycrystal.empty");
            }
        }
        return I18N.localise("extrabees.item.honeycrystal");
    }

    @Optional.Method(modid="ic2")
    public boolean showDurabilityBar(ItemStack stack) {
        double maxCharge;
        double charge = ElectricItem.manager.getCharge(stack);
        return charge != (maxCharge = ElectricItem.manager.getMaxCharge(stack));
    }

    @Optional.Method(modid="ic2")
    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = ElectricItem.manager.getCharge(stack);
        double maxCharge = ElectricItem.manager.getMaxCharge(stack);
        return 1.0 - charge / maxCharge;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item) {
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("extrabees:honey_crystal_full", "inventory"), new ModelResourceLocation("extrabees:honey_crystal_empty", "inventory"), new ModelResourceLocation("extrabees:honey_crystal", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new HoneyCrystalMeshDefinition());
    }

    @Optional.Method(modid="ic2")
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && stack.func_190916_E() == 1) {
            if (ElectricItem.manager.getCharge(stack) > 0.0) {
                boolean transferred = false;
                for (int i = 0; i < 9; ++i) {
                    double transfer;
                    ItemStack target = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                    if (target == null || target == stack || !(ElectricItem.manager.discharge(target, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true, true) <= 0.0) || !((transfer = ElectricItem.manager.discharge(stack, 2.0 * (double)this.transferLimit, Integer.MAX_VALUE, true, true, true)) > 0.0) || !((transfer = ElectricItem.manager.charge(target, transfer, this.tier, true, false)) > 0.0)) continue;
                    ElectricItem.manager.discharge(stack, transfer, Integer.MAX_VALUE, true, true, false);
                    transferred = true;
                }
                if (transferred && !world.field_72995_K) {
                    player.field_71070_bA.func_75142_b();
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Optional.Method(modid="ic2")
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="ic2")
    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    @Optional.Method(modid="ic2")
    public int getTier(ItemStack stack) {
        return this.tier;
    }

    @Optional.Method(modid="ic2")
    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    @Optional.Method(modid="ic2")
    public List<String> getHudInfo(ItemStack stack, boolean advanced) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(stack));
        return info;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (Mods.IC2.active()) {
            subItems.add((Object)this.getCharged(0.0));
            subItems.add((Object)this.getCharged(Double.POSITIVE_INFINITY));
        }
    }

    @Optional.Method(modid="ic2")
    public ItemStack getCharged(double charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, charge, Integer.MAX_VALUE, true, false);
        return ret;
    }

    private static class HoneyCrystalMeshDefinition
    implements ItemMeshDefinition {
        private HoneyCrystalMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            int damage = stack.func_77952_i();
            String name = "honey_crystal";
            if (damage == 0) {
                name = "honey_crystal_full";
            } else if (damage == 26) {
                name = "honey_crystal_empty";
            }
            return new ModelResourceLocation("extrabees:" + name, "inventory");
        }
    }
}

