/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.power.CoreErrorCode;
import binnie.core.machines.power.EnumErrorType;
import binnie.core.machines.power.IErrorStateDefinition;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import net.minecraft.nbt.NBTTagCompound;

public class ErrorState
implements INbtReadable,
INbtWritable {
    private String name;
    private String desc;
    private int[] data = new int[0];
    private boolean progress = false;
    private boolean itemError = false;
    private boolean tankError = false;
    private boolean powerError = false;

    public ErrorState(IErrorStateDefinition definition) {
        this(definition, definition);
    }

    public ErrorState(IErrorStateDefinition definition, int[] data) {
        this(definition, definition, data);
    }

    public ErrorState(IErrorStateDefinition definition, int data) {
        this(definition, definition, new int[]{data});
    }

    public ErrorState(IErrorStateDefinition nameDefinition, IErrorStateDefinition definition) {
        this(nameDefinition.getName(), definition.getDescription());
        EnumErrorType type = definition.getType();
        this.itemError = type.isItemError();
        this.tankError = type.isTankError();
        this.powerError = type.isPowerError();
    }

    public ErrorState(IErrorStateDefinition nameDefinition, IErrorStateDefinition definition, int data) {
        this(nameDefinition.getName(), definition.getDescription(), new int[]{data});
        EnumErrorType type = definition.getType();
        this.itemError = type.isItemError();
        this.tankError = type.isTankError();
        this.powerError = type.isPowerError();
    }

    public ErrorState(IErrorStateDefinition nameDefinition, IErrorStateDefinition definition, int[] data) {
        this(nameDefinition.getName(), definition.getDescription(), data);
        EnumErrorType type = definition.getType();
        this.itemError = type.isItemError();
        this.tankError = type.isTankError();
        this.powerError = type.isPowerError();
    }

    public ErrorState(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public ErrorState(String name, String desc, int[] data) {
        this.name = name;
        this.desc = desc;
        this.data = data;
    }

    public String toString() {
        return this.name;
    }

    public String getTooltip() {
        return this.desc;
    }

    public int[] getData() {
        return this.data;
    }

    public boolean isProgress() {
        return this.progress;
    }

    public void setIsProgress() {
        this.progress = true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.desc = nbt.func_74779_i("desc");
        this.data = nbt.func_74759_k("data");
        this.itemError = nbt.func_74767_n("item");
        this.tankError = nbt.func_74767_n("tank");
        this.powerError = nbt.func_74767_n("power");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.toString());
        nbt.func_74778_a("desc", this.getTooltip());
        nbt.func_74783_a("data", this.data);
        if (this.isItemError()) {
            nbt.func_74757_a("item", true);
        }
        if (this.isTankError()) {
            nbt.func_74757_a("tank", true);
        }
        if (this.isPowerError()) {
            nbt.func_74757_a("power", true);
        }
        return nbt;
    }

    public boolean isItemError() {
        return this.itemError || this instanceof Item;
    }

    public boolean isTankError() {
        return this.tankError;
    }

    public boolean isPowerError() {
        return this.powerError || this instanceof InsufficientPower;
    }

    public static class InsufficientPower
    extends ErrorState {
        public InsufficientPower() {
            super(CoreErrorCode.INSUFFICIENT_POWER);
        }
    }

    public static class NoItem
    extends Item {
        public NoItem(String desc, int slot) {
            this(desc, new int[]{slot});
        }

        public NoItem(String desc, int[] slots) {
            super("No Item", desc, slots);
        }

        public NoItem(IErrorStateDefinition definition, int[] slots) {
            super("No Item", definition.getDescription(), slots);
        }

        public NoItem(IErrorStateDefinition definition, int slot) {
            this(definition.getDescription(), new int[]{slot});
        }
    }

    public static class Item
    extends ErrorState {
        public Item(String name, String desc, int[] slots) {
            super(name, desc, slots);
        }

        public Item(IErrorStateDefinition nameDefinition, IErrorStateDefinition definition, int[] slots) {
            super(nameDefinition, definition, slots);
        }
    }
}

