/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.BinnieCore;
import binnie.core.ManagerBase;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.ValidatorSprite;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ManagerMachine
extends ManagerBase {
    private Map<Class<?>, Class<?>[]> componentInterfaceMap = new HashMap();
    private Map<String, MachineGroup> machineGroups = new HashMap<String, MachineGroup>();
    private Map<Integer, Class<?>> networkIDToComponent = new HashMap();
    private Map<Class<?>, Integer> componentToNetworkID = new HashMap();
    private int nextNetworkID = 0;

    public void registerMachineGroup(MachineGroup group) {
        this.machineGroups.put(group.getUID(), group);
    }

    public MachineGroup getGroup(String name) {
        return this.machineGroups.get(name);
    }

    public MachinePackage getPackage(String group, String name) {
        MachineGroup machineGroup = this.getGroup(group);
        return machineGroup == null ? null : machineGroup.getPackage(name);
    }

    private void registerComponentClass(Class<? extends MachineComponent> component) {
        if (this.componentInterfaceMap.containsKey(component)) {
            return;
        }
        HashSet interfaces = new HashSet();
        Class<? extends MachineComponent> currentClass = component;
        while (currentClass != null) {
            Collections.addAll(interfaces, currentClass.getInterfaces());
            currentClass = currentClass.getSuperclass();
            if (currentClass == Object.class) {
                // empty if block
            }
            currentClass = null;
        }
        interfaces.remove(INbtWritable.class);
        interfaces.remove(INbtReadable.class);
        this.componentInterfaceMap.put(component, interfaces.toArray(new Class[0]));
        int networkID = this.nextNetworkID++;
        this.networkIDToComponent.put(networkID, component);
        this.componentToNetworkID.put(component, networkID);
    }

    public int getNetworkID(Class<?> component) {
        return this.componentToNetworkID.get(component);
    }

    public Class<?> getComponentClass(int networkID) {
        return this.networkIDToComponent.get(networkID);
    }

    @Override
    public void init() {
        SlotValidator.spriteBee = new ValidatorSprite(BinnieCore.getInstance(), "validator/bee.0", "validator/bee.1");
        SlotValidator.spriteFrame = new ValidatorSprite(BinnieCore.getInstance(), "validator/frame.0", "validator/frame.1");
        SlotValidator.spriteCircuit = new ValidatorSprite(BinnieCore.getInstance(), "validator/circuit.0", "validator/circuit.1");
        SlotValidator.spriteBlock = new ValidatorSprite(BinnieCore.getInstance(), "validator/block.0", "validator/block.1");
    }

    @Override
    public void postInit() {
        Object rendererMachine = null;
        BinnieCore.getBinnieProxy().registerTileEntity(TileEntityMachine.class, "binnie.tile.machine", rendererMachine);
    }

    public Class<?>[] getComponentInterfaces(Class<? extends MachineComponent> clss) {
        if (!this.componentInterfaceMap.containsKey(clss)) {
            this.registerComponentClass(clss);
        }
        return this.componentInterfaceMap.get(clss);
    }
}

