/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.machines.BlockMachine;
import binnie.core.machines.IMachineType;
import binnie.core.machines.ItemMachine;
import binnie.core.machines.MachinePackage;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public class MachineGroup {
    public boolean customRenderer = true;
    private AbstractMod mod;
    private String blockName;
    private String uid;
    private Map<String, MachinePackage> packages = new LinkedHashMap<String, MachinePackage>();
    private Map<Integer, MachinePackage> packagesID = new LinkedHashMap<Integer, MachinePackage>();
    private BlockMachine block;
    private boolean renderedTileEntity = true;

    public MachineGroup(AbstractMod mod, String uid, String blockName, IMachineType[] types) {
        this.mod = mod;
        this.uid = uid;
        this.blockName = blockName;
        this.createPackages(types);
        Binnie.MACHINE.registerMachineGroup(this);
        this.block = new BlockMachine(this, blockName);
        mod.getProxy().registerBlock(this.block);
        Item i = mod.getProxy().registerItem((Item)new ItemMachine(this.block));
        for (int j = 0; j < types.length; ++j) {
            BinnieCore.getBinnieProxy().registerModel(i, j, new ModelResourceLocation(i.getRegistryName(), "machine_type=" + j));
        }
        for (MachinePackage pack : this.getPackages()) {
            pack.register();
        }
    }

    private void createPackages(IMachineType[] types) {
        for (IMachineType type : types) {
            if (type.getPackageClass() == null || !type.isActive()) continue;
            try {
                MachinePackage pack = type.getPackageClass().newInstance();
                pack.assignMetadata(type.ordinal());
                pack.setActive(type.isActive());
                this.addPackage(pack);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to create machine package " + type.toString(), e);
            }
        }
    }

    private void addPackage(MachinePackage pack) {
        this.packages.put(pack.getUID(), pack);
        this.packagesID.put(pack.getMetadata(), pack);
        pack.setGroup(this);
    }

    public Collection<MachinePackage> getPackages() {
        return this.packages.values();
    }

    public BlockMachine getBlock() {
        return this.block;
    }

    @Nullable
    public MachinePackage getPackage(int metadata) {
        return this.packagesID.get(metadata);
    }

    public MachinePackage getPackage(String name) {
        return this.packages.get(name);
    }

    public String getUID() {
        return this.mod.getModID() + "." + this.uid;
    }

    public String getShortUID() {
        return this.uid;
    }

    boolean isTileEntityRenderered() {
        return this.renderedTileEntity;
    }

    public void renderAsBlock() {
        this.renderedTileEntity = false;
    }

    public void setCreativeTab(CreativeTabs tab) {
        this.block.func_149647_a(tab);
    }

    public AbstractMod getMod() {
        return this.mod;
    }
}

