/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.resource.minecraft;

import binnie.core.gui.CraftGUI;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Border;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.ParsedTextureSheet;
import binnie.core.resource.IBinnieTexture;
import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class CraftGUIResourceManager
implements IResourceManagerReloadListener {
    private Map<String, ParsedTextureSheet> textureSheets = new HashMap<String, ParsedTextureSheet>();
    private Map<String, Texture> textures = new HashMap<String, Texture>();

    public CraftGUIResourceManager() {
        CraftGUI.resourceManager = this;
    }

    public void func_110549_a(IResourceManager manager) {
        this.textureSheets.clear();
        try {
            IResource res = manager.func_110536_a(new ResourceLocation("binniecore", "gui/stylesheet.json"));
            JsonObject jsonobject = null;
            BufferedReader bufferedreader = null;
            try {
                String name;
                JsonObject sheet;
                bufferedreader = new BufferedReader(new InputStreamReader(res.func_110527_b(), Charsets.UTF_8));
                jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
                for (JsonElement el : jsonobject.get("texture-sheets").getAsJsonArray()) {
                    if (!(el instanceof JsonObject)) continue;
                    sheet = (JsonObject)el;
                    name = sheet.get("name").getAsString();
                    String modid = sheet.get("modid").getAsString();
                    String path = sheet.get("path").getAsString();
                    this.textureSheets.put(name, new ParsedTextureSheet(name, modid, path));
                }
                for (JsonElement el : jsonobject.get("textures").getAsJsonArray()) {
                    if (!(el instanceof JsonObject)) continue;
                    sheet = (JsonObject)el;
                    name = sheet.get("name").getAsString();
                    IBinnieTexture textureSheet = this.getTextureSheet(sheet.get("sheet").getAsString());
                    Area uv = this.getArea(sheet.get("uv").getAsString());
                    Border border = Border.ZERO;
                    Border padding = Border.ZERO;
                    if (sheet.has("border")) {
                        border = this.getBorder(sheet.get("border").getAsString());
                    }
                    if (sheet.has("padding")) {
                        padding = this.getBorder(sheet.get("padding").getAsString());
                    }
                    this.textures.put(name, new Texture(uv, padding, border, textureSheet));
                }
            }
            catch (RuntimeException runtimeexception) {
                try {
                    throw new JsonParseException("Failed to parse stylesheet for Binnie's Mods", (Throwable)runtimeexception);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedreader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)bufferedreader);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load default stylesheet for Binnie's Mods.", e);
        }
    }

    public Area getArea(String name) {
        String[] split = name.split(" ");
        if (split.length < 1 || split.length > 4) {
            throw new RuntimeException("Parameter must have between one and four numbers");
        }
        ArrayList<Integer> i = new ArrayList<Integer>();
        for (String string : split) {
            i.add(Integer.parseInt(string));
        }
        if (i.size() == 1) {
            return new Area((Integer)i.get(0));
        }
        if (i.size() == 2) {
            return new Area((Integer)i.get(0), (Integer)i.get(1));
        }
        if (i.size() == 3) {
            return new Area((Integer)i.get(0), (Integer)i.get(1), (Integer)i.get(2));
        }
        return new Area((Integer)i.get(0), (Integer)i.get(1), (Integer)i.get(2), (Integer)i.get(3));
    }

    public Border getBorder(String name) {
        String[] split = name.split(" ");
        if (split.length < 1 || split.length > 4) {
            throw new RuntimeException("Parameter must have between one and four numbers");
        }
        ArrayList<Integer> i = new ArrayList<Integer>();
        for (String string : split) {
            i.add(Integer.parseInt(string));
        }
        if (i.size() == 1) {
            return new Border((Integer)i.get(0));
        }
        if (i.size() == 2) {
            return new Border((Integer)i.get(0), (int)((Integer)i.get(1)));
        }
        if (i.size() == 3) {
            return new Border((Integer)i.get(0), (Integer)i.get(1), (Integer)i.get(2));
        }
        return new Border((Integer)i.get(0), (Integer)i.get(1), (Integer)i.get(2), (Integer)i.get(3));
    }

    public IBinnieTexture getTextureSheet(String name) {
        if (!this.textureSheets.containsKey(name)) {
            throw new RuntimeException("Missing GUI texture sheet for Binnie Mods: " + name);
        }
        return this.textureSheets.get(name);
    }

    public Texture getTexture(String name) {
        if (!this.textures.containsKey(name)) {
            throw new RuntimeException("Missing GUI texture Binnie Mods: " + name);
        }
        return this.textures.get(name);
    }
}

