/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.renderer;

import binnie.core.BinnieCore;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import com.google.common.base.Preconditions;
import forestry.api.core.ForestryAPI;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderUtil {
    private RenderUtil() {
    }

    public static void drawItem(Point pos, ItemStack itemStack) {
        RenderUtil.drawItem(pos, itemStack, false);
    }

    public static void drawItem(Point pos, ItemStack itemStack, boolean rotating) {
        GlStateManager.func_179123_a();
        Preconditions.checkNotNull((Object)itemStack);
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderHelper.func_74520_c();
        FontRenderer font = RenderUtil.getFontRenderer(minecraft, itemStack);
        if (rotating) {
            GlStateManager.func_179094_E();
            float phase = Minecraft.func_71386_F() / 20L;
            GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)150.0f);
            GlStateManager.func_179114_b((float)phase, (float)0.0f, (float)-0.866f, (float)0.5f);
            GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)-150.0f);
        }
        minecraft.func_175599_af().func_184391_a(null, itemStack, pos.x(), pos.y());
        if (rotating) {
            GlStateManager.func_179121_F();
        }
        minecraft.func_175599_af().func_180453_a(font, itemStack, pos.x(), pos.y(), null);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
    }

    private static FontRenderer getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        FontRenderer fontRenderer = ingredient.func_77973_b().getFontRenderer(ingredient);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }

    public static void drawTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        vertexBuffer.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void setColour(int hexColour) {
        int a = (hexColour & 0xFF000000) >> 24;
        int r = (hexColour & 0xFF0000) >> 16;
        int g = (hexColour & 0xFF00) >> 8;
        int b = hexColour & 0xFF;
        if (a < 0) {
            a += 256;
        }
        if (a > 0 && a != 255) {
            GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
        } else {
            GlStateManager.func_179124_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f));
        }
    }

    public static int getTextWidth(String text) {
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        return fontRendererObj.func_78256_a(text);
    }

    public static int getTextHeight() {
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        return fontRendererObj == null ? 0 : fontRendererObj.field_78288_b;
    }

    public static void drawText(Point pos, String text, int colour) {
        RenderUtil.drawText(new Area(pos, new Point(500, 500)), TextJustification.TOP_LEFT, text, colour);
    }

    public static void drawText(Area area, TextJustification justification, String text, int colour) {
        Point pos = area.pos();
        if ((float)area.size().x() <= 0.0f) {
            return;
        }
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        List wrappedStrings = fontRendererObj.func_78271_c(text, area.size().x());
        float totalHeight = wrappedStrings.size() * RenderUtil.getTextHeight();
        float posY = area.pos().y();
        if ((float)area.size().y() > totalHeight) {
            posY += ((float)area.size().y() - totalHeight) * justification.getYOffset();
        }
        for (String string : wrappedStrings) {
            float stringWidth = RenderUtil.getTextWidth(string);
            float posX = (float)area.size().x() - stringWidth;
            GlStateManager.func_179097_i();
            fontRendererObj.func_78276_b(string, (int)((float)pos.x() + (posX *= justification.getXOffset())), (int)posY, colour);
            posY += (float)RenderUtil.getTextHeight();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSolidRect(float left, float top, float right, float bottom, int color) {
        GuiUtils.drawGradientRect((int)0, (int)((int)left), (int)((int)top), (int)((int)right), (int)((int)bottom), (int)color, (int)color);
    }

    public static void drawSolidRect(Area area, int colour) {
        RenderUtil.drawSolidRect(area.pos().x(), area.pos().y(), area.pos().x() + area.size().x(), area.pos().y() + area.size().y(), 0xFF000000 | colour);
    }

    public static void drawSolidRectWithAlpha(Area area, int color) {
        RenderUtil.drawSolidRect(area.pos().x(), area.pos().y(), area.pos().x() + area.size().x(), area.pos().y() + area.size().y(), color);
    }

    public static void drawGradientRect(Area area, int startColor, int endColor) {
        GuiUtils.drawGradientRect((int)0, (int)area.pos().x(), (int)area.pos().y(), (int)(area.pos().x() + area.size().x()), (int)(area.pos().y() + area.size().y()), (int)startColor, (int)endColor);
    }

    public static void drawSprite(Point pos, @Nullable TextureAtlasSprite icon) {
        if (icon != null) {
            BinnieCore.getBinnieProxy().bindTexture(TextureMap.field_110575_b);
            RenderUtil.drawTexture(pos.x(), pos.y(), icon, 0, 0, 0.0);
        }
    }

    public static void drawGuiSprite(Point pos, @Nullable TextureAtlasSprite icon) {
        if (icon != null) {
            BinnieCore.getBinnieProxy().bindTexture(ForestryAPI.textureManager.getGuiTextureMap());
            RenderUtil.drawTexture(pos.x(), pos.y(), icon, 0, 0, 0.0);
        }
    }

    public static void drawFluid(Point pos, @Nullable FluidStack fluid) {
        Fluid fluid1;
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        Minecraft minecraft = Minecraft.func_71410_x();
        if (fluid != null && (fluid1 = fluid.getFluid()) != null) {
            TextureAtlasSprite fluidStillSprite = RenderUtil.getStillFluidSprite(minecraft, fluid1);
            int fluidColor = fluid1.getColor(fluid);
            minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            RenderUtil.setColour(fluidColor);
            RenderUtil.drawTexture(pos.x(), pos.y(), fluidStillSprite, 0, 0, 100.0);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private static TextureAtlasSprite getStillFluidSprite(Minecraft minecraft, Fluid fluid) {
        TextureMap textureMapBlocks = minecraft.func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
        }
        if (fluidStillSprite == null) {
            fluidStillSprite = textureMapBlocks.func_174944_f();
        }
        return fluidStillSprite;
    }
}

