/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.minecraft.InventoryType;
import binnie.core.gui.minecraft.control.ControlSlot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ControlPlayerInventory
extends Control {
    private final List<ControlSlot> slots = new ArrayList<ControlSlot>();

    public ControlPlayerInventory(IWidget parent, boolean wide) {
        super(parent, parent.getSize().x() / 2 - (wide ? 110 : 81), parent.getSize().y() - (wide ? 54 : 76) - 12, wide ? 220 : 162, wide ? 54 : 76);
        int i1;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                ControlSlot slot = new ControlSlot.Builder(this, (wide ? 58 : 0) + column * 18, row * 18).assign(InventoryType.Player, 9 + column + row * 9);
                this.slots.add(slot);
            }
        }
        if (wide) {
            for (i1 = 0; i1 < 9; ++i1) {
                ControlSlot slot2 = new ControlSlot.Builder(this, i1 % 3 * 18, i1 / 3 * 18).assign(InventoryType.Player, i1);
                this.slots.add(slot2);
            }
        } else {
            for (i1 = 0; i1 < 9; ++i1) {
                ControlSlot slot2 = new ControlSlot.Builder(this, i1 * 18, 58).assign(InventoryType.Player, i1);
                this.slots.add(slot2);
            }
        }
    }

    public ControlPlayerInventory(IWidget parent) {
        this(parent, false);
    }

    public ControlPlayerInventory(IWidget parent, int x, int y) {
        super(parent, x, y, 54, 220);
        for (int row = 0; row < 6; ++row) {
            for (int column = 0; column < 6; ++column) {
                ControlSlot slot = new ControlSlot.Builder(this, column * 18, row * 18).assign(InventoryType.Player, column + row * 6);
                this.slots.add(slot);
            }
        }
    }

    public void addItem(ItemStack item) {
        for (ControlSlot slot : this.slots) {
            if (slot.slot.func_75216_d()) continue;
            slot.slot.func_75215_d(item);
        }
    }

    public void addInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            this.addItem(stackInSlot);
        }
    }

    @Nullable
    public ControlSlot getSlot(int i) {
        if (i < 0 || i >= this.slots.size()) {
            return null;
        }
        return this.slots.get(i);
    }

    @Override
    public void onUpdateClient() {
    }
}

